/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.GameParser;
import games.strategy.engine.data.Territory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AddGridGameMapChange
extends Change {
    private static final long serialVersionUID = -8326219690181895908L;
    final Map<Territory, Set<Territory>> m_removeTerritoriesAndConnections;
    final Map<Territory, Set<Territory>> m_addTerritoriesAndConnections;
    final String m_gridType;
    final String m_name;
    final int m_xs;
    final int m_ys;
    final Set<String> m_water;
    final Set<String> m_oldWater;
    final String m_horizontalConnections;
    final String m_verticalConnections;
    final String m_diagonalConnections;
    final int m_oldXs;
    final int m_oldYs;

    public AddGridGameMapChange(GameMap map, String gridType, String name, int xs, int ys, Set<String> water, String horizontalConnections, String verticalConnections, String diagonalConnections) {
        String tname;
        this.m_oldXs = map.getXDimension();
        this.m_oldYs = map.getYDimension();
        this.m_gridType = gridType;
        this.m_name = name;
        this.m_xs = xs;
        this.m_ys = ys;
        this.m_water = water;
        this.m_horizontalConnections = horizontalConnections;
        this.m_verticalConnections = verticalConnections;
        this.m_diagonalConnections = diagonalConnections;
        this.m_oldWater = new HashSet<String>();
        for (Territory t : map.getTerritories()) {
            if (!t.isWater()) continue;
            this.m_oldWater.add(t.getName());
        }
        this.m_removeTerritoriesAndConnections = new HashMap<Territory, Set<Territory>>();
        this.m_addTerritoriesAndConnections = new HashMap<Territory, Set<Territory>>();
        if (map.getXDimension() > this.m_xs) {
            for (Territory t : map.getTerritories()) {
                tname = t.getName().replaceFirst(this.m_name + "_", "");
                int tx = Integer.parseInt(tname = tname.substring(0, tname.indexOf("_")));
                if (tx <= this.m_xs - 1) continue;
                this.m_removeTerritoriesAndConnections.put(t, map.getNeighbors(t));
            }
        } else if (map.getXDimension() < this.m_xs) {
            // empty if block
        }
        if (map.getYDimension() > this.m_ys) {
            for (Territory t : map.getTerritories()) {
                tname = t.getName().replaceFirst(this.m_name + "_", "");
                int ty = Integer.parseInt(tname = tname.substring(tname.indexOf("_") + 1, tname.length()));
                if (ty <= this.m_ys - 1) continue;
                this.m_removeTerritoriesAndConnections.put(t, map.getNeighbors(t));
            }
        } else if (map.getYDimension() < this.m_ys) {
            // empty if block
        }
    }

    public AddGridGameMapChange(String gridType, String name, int oldXs, int oldYs, int newXs, int newYs, Set<String> oldWater, Set<String> water, String horizontalConnections, String verticalConnections, String diagonalConnections, Map<Territory, Set<Territory>> removeTerritoriesAndConnections, Map<Territory, Set<Territory>> addTerritoriesAndConnections) {
        this.m_oldXs = oldXs;
        this.m_oldYs = oldYs;
        this.m_gridType = gridType;
        this.m_name = name;
        this.m_xs = newXs;
        this.m_ys = newYs;
        this.m_oldWater = oldWater;
        this.m_water = water;
        this.m_horizontalConnections = horizontalConnections;
        this.m_verticalConnections = verticalConnections;
        this.m_diagonalConnections = diagonalConnections;
        this.m_removeTerritoriesAndConnections = removeTerritoriesAndConnections;
        this.m_addTerritoriesAndConnections = addTerritoriesAndConnections;
    }

    @Override
    protected void perform(GameData data) {
        if (data.getMap().getXDimension() != this.m_xs || data.getMap().getYDimension() != this.m_ys) {
            try {
                GameMap map = data.getMap();
                for (Territory t : this.m_removeTerritoriesAndConnections.keySet()) {
                    map.removeTerritory(t);
                }
                GameParser.setGrids(data, this.m_gridType, this.m_name, Integer.toString(this.m_xs), Integer.toString(this.m_ys), this.m_water, this.m_horizontalConnections, this.m_verticalConnections, this.m_diagonalConnections, true);
                map.notifyChanged();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Change invert() {
        return new AddGridGameMapChange(this.m_gridType, this.m_name, this.m_xs, this.m_ys, this.m_oldXs, this.m_oldYs, this.m_water, this.m_oldWater, this.m_horizontalConnections, this.m_verticalConnections, this.m_diagonalConnections, this.m_addTerritoriesAndConnections, this.m_removeTerritoriesAndConnections);
    }
}

