/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.AddAttachmentChange;
import games.strategy.engine.data.AddAvailableTech;
import games.strategy.engine.data.AddBattleRecordsChange;
import games.strategy.engine.data.AddGridGameMapChange;
import games.strategy.engine.data.AddProductionRule;
import games.strategy.engine.data.AddUnits;
import games.strategy.engine.data.Attachable;
import games.strategy.engine.data.AttachmentPropertyReset;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeAttachmentChange;
import games.strategy.engine.data.ChangeResourceChange;
import games.strategy.engine.data.ChangeUnitProduction;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.GameSequence;
import games.strategy.engine.data.GameSequenceChange;
import games.strategy.engine.data.GameStep;
import games.strategy.engine.data.GenericTechChange;
import games.strategy.engine.data.IAttachment;
import games.strategy.engine.data.ObjectPropertyChange;
import games.strategy.engine.data.OwnerChange;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.PlayerOwnerChange;
import games.strategy.engine.data.PlayerWhoAmIChange;
import games.strategy.engine.data.ProductionFrontier;
import games.strategy.engine.data.ProductionFrontierChange;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.RelationshipChange;
import games.strategy.engine.data.RelationshipType;
import games.strategy.engine.data.RemoveAvailableTech;
import games.strategy.engine.data.RemoveProductionRule;
import games.strategy.engine.data.RemoveUnits;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.ResourceCollection;
import games.strategy.engine.data.SetPropertyChange;
import games.strategy.engine.data.TechnologyFrontier;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitHitsChange;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.TechAttachment;
import games.strategy.triplea.delegate.TechAdvance;
import games.strategy.triplea.delegate.dataObjects.BattleRecords;
import games.strategy.util.IntegerMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeFactory {
    public static final Change EMPTY_CHANGE = new Change(){
        private static final long serialVersionUID = -5514560889478876641L;

        protected void perform(GameData data) {
        }

        public Change invert() {
            return this;
        }

        private Object readResolve() {
            return EMPTY_CHANGE;
        }

        public boolean isEmpty() {
            return true;
        }
    };

    public static Change changeOwner(Territory territory, PlayerID owner) {
        return new OwnerChange(territory, owner);
    }

    public static Change changeOwner(Collection<Unit> units, PlayerID owner, Territory location) {
        return new PlayerOwnerChange(units, owner, location);
    }

    public static Change changeOwner(Unit unit, PlayerID owner, Territory location) {
        ArrayList<Unit> list = new ArrayList<Unit>(1);
        list.add(unit);
        return new PlayerOwnerChange(list, owner, location);
    }

    public static Change changeUnitProduction(Territory terr, int value) {
        return new ChangeUnitProduction(terr, value);
    }

    public static Change addUnits(Territory territory, Collection<Unit> units) {
        return new AddUnits(territory.getUnits(), units);
    }

    public static Change removeUnits(Territory territory, Collection<Unit> units) {
        return new RemoveUnits(territory.getUnits(), units);
    }

    public static Change addUnits(PlayerID player, Collection<Unit> units) {
        return new AddUnits(player.getUnits(), units);
    }

    public static Change removeUnits(PlayerID player, Collection<Unit> units) {
        return new RemoveUnits(player.getUnits(), units);
    }

    public static Change moveUnits(Territory start, Territory end, Collection<Unit> units) {
        units = new ArrayList<Unit>(units);
        ArrayList<Change> changes = new ArrayList<Change>(2);
        changes.add(ChangeFactory.removeUnits(start, units));
        changes.add(ChangeFactory.addUnits(end, units));
        return new CompositeChange(changes);
    }

    public static Change changeProductionFrontier(PlayerID player, ProductionFrontier frontier) {
        return new ProductionFrontierChange(frontier, player);
    }

    public static Change changeProductionFrontierChange(PlayerID player, ProductionFrontier newFrontier) {
        return new ProductionFrontierChange(newFrontier, player);
    }

    public static Change changePlayerWhoAmIChange(PlayerID player, String humanOrAI_colon_playerName) {
        return new PlayerWhoAmIChange(humanOrAI_colon_playerName, player);
    }

    public static Change changeResourcesChange(PlayerID player, Resource resource, int quantity) {
        return new ChangeResourceChange(player, resource, quantity);
    }

    public static Change addResourceCollection(PlayerID id, ResourceCollection rCollection) {
        CompositeChange cChange = new CompositeChange();
        for (Resource r : rCollection.getResourcesCopy().keySet()) {
            cChange.add(new ChangeResourceChange(id, r, rCollection.getQuantity(r)));
        }
        return cChange;
    }

    public static Change removeResourceCollection(PlayerID id, ResourceCollection rCollection) {
        CompositeChange cChange = new CompositeChange();
        for (Resource r : rCollection.getResourcesCopy().keySet()) {
            cChange.add(new ChangeResourceChange(id, r, -rCollection.getQuantity(r)));
        }
        return cChange;
    }

    public static Change setProperty(String property, Object value, GameData data) {
        return new SetPropertyChange(property, value, data.getProperties());
    }

    public static Change unitsHit(IntegerMap<Unit> newHits) {
        return new UnitHitsChange(newHits);
    }

    public static Change addProductionRule(ProductionRule rule, ProductionFrontier frontier) {
        return new AddProductionRule(rule, frontier);
    }

    public static Change removeProductionRule(ProductionRule rule, ProductionFrontier frontier) {
        return new RemoveProductionRule(rule, frontier);
    }

    public static Change addAvailableTech(TechnologyFrontier tf, TechAdvance ta, PlayerID player) {
        return new AddAvailableTech(tf, ta, player);
    }

    public static Change removeAvailableTech(TechnologyFrontier tf, TechAdvance ta, PlayerID player) {
        return new RemoveAvailableTech(tf, ta, player);
    }

    public static Change attachmentPropertyChange(IAttachment attachment, Object newValue, String property) {
        return new ChangeAttachmentChange(attachment, newValue, property);
    }

    public static Change attachmentPropertyChange(IAttachment attachment, Object newValue, String property, boolean getRaw, boolean resetFirst) {
        return new ChangeAttachmentChange(attachment, newValue, property, getRaw, resetFirst);
    }

    public static Change attachmentPropertyChange(Attachable attachment, String attachmentName, Object newValue, Object oldValue, String property, boolean clearFirst) {
        return new ChangeAttachmentChange(attachment, attachmentName, newValue, oldValue, property, clearFirst);
    }

    public static Change attachmentPropertyReset(IAttachment attachment, String property, boolean getRaw) {
        return new AttachmentPropertyReset(attachment, property, getRaw);
    }

    public static Change genericTechChange(TechAttachment attachment, Boolean value, String property) {
        return new GenericTechChange(attachment, value, property);
    }

    public static Change changeGameSteps(GameSequence oldSequence, GameStep[] newSteps) {
        return new GameSequenceChange(oldSequence, newSteps);
    }

    public static Change unitPropertyChange(Unit unit, Object newValue, String propertyName) {
        return new ObjectPropertyChange(unit, propertyName, newValue);
    }

    public static Change addAttachmentChange(IAttachment attachment, Attachable attachable, String name) {
        return new AddAttachmentChange(attachment, attachable, name);
    }

    public static Change addGridGameMapChange(GameMap map, String gridType, String name, int xs, int ys, Set<String> water, String horizontalConnections, String verticalConnections, String diagonalConnections) {
        return new AddGridGameMapChange(map, gridType, name, xs, ys, water, horizontalConnections, verticalConnections, diagonalConnections);
    }

    public static Change addBattleRecords(BattleRecords records, GameData data) {
        return new AddBattleRecordsChange(records, data);
    }

    private ChangeFactory() {
    }

    public static Change relationshipChange(PlayerID player, PlayerID player2, RelationshipType currentRelation, RelationshipType newRelation) {
        return new RelationshipChange(player, player2, currentRelation, newRelation);
    }

    public static Change markNoMovementChange(Collection<Unit> units) {
        CompositeChange change = new CompositeChange();
        for (Unit unit : units) {
            if (TripleAUnit.get(unit).getMovementLeft() <= 0) continue;
            change.add(ChangeFactory.markNoMovementChange(unit));
        }
        if (change.isEmpty()) {
            return EMPTY_CHANGE;
        }
        return change;
    }

    public static Change markNoMovementChange(Unit unit) {
        return ChangeFactory.unitPropertyChange(unit, TripleAUnit.get(unit).getMaxMovementAllowed(), "alreadyMoved");
    }
}

