/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.Territory;
import games.strategy.triplea.attatchments.TerritoryAttachment;

class ChangeUnitProduction
extends Change {
    private static final long serialVersionUID = -1485932997086849018L;
    private final int m_unitProduction;
    private final int m_old;
    private final Territory m_location;

    ChangeUnitProduction(Territory terr, int quantity, int oldQuantity) {
        this.m_location = terr;
        this.m_unitProduction = quantity;
        this.m_old = oldQuantity;
    }

    ChangeUnitProduction(Territory terr, int quantity) {
        this.m_location = terr;
        this.m_unitProduction = quantity;
        this.m_old = TerritoryAttachment.get(terr).getUnitProduction();
    }

    public Change invert() {
        return new ChangeUnitProduction(this.m_location, this.m_old, this.m_unitProduction);
    }

    protected void perform(GameData data) {
        TerritoryAttachment ta = TerritoryAttachment.get(this.m_location);
        ta.setUnitProduction(this.m_unitProduction);
        this.m_location.notifyChanged();
    }

    public String toString() {
        return "Change unit production.  Quantity:" + this.m_unitProduction + " Territory:" + this.m_location;
    }
}

