/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeChange
extends Change {
    static final long serialVersionUID = 8152962976769419486L;
    private final List<Change> m_changes;

    public CompositeChange(Change ... changes) {
        this();
        this.add(changes);
    }

    public CompositeChange() {
        this.m_changes = new ArrayList<Change>();
    }

    public CompositeChange(List<Change> changes) {
        this.m_changes = new ArrayList<Change>(changes);
    }

    public void add(Change ... changes) {
        for (Change aChange : changes) {
            if (aChange.isEmpty()) continue;
            this.m_changes.add(aChange);
        }
    }

    @Override
    public Change invert() {
        ArrayList<Change> newChanges = new ArrayList<Change>();
        for (int i = this.m_changes.size() - 1; i >= 0; --i) {
            Change current = this.m_changes.get(i);
            newChanges.add(current.invert());
        }
        return new CompositeChange(newChanges);
    }

    @Override
    protected void perform(GameData data) {
        for (int i = 0; i < this.m_changes.size(); ++i) {
            Change current = this.m_changes.get(i);
            current.perform(data);
        }
    }

    @Override
    public boolean isEmpty() {
        for (Change c : this.m_changes) {
            if (c.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public List<Change> getChanges() {
        return new ArrayList<Change>(this.m_changes);
    }

    public String toString() {
        return "CompositeChange <" + (this.m_changes == null ? "null" : this.m_changes.toString()) + ">";
    }
}

