/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameDataComponent;
import games.strategy.engine.data.GameStep;
import games.strategy.engine.data.PlayerID;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameSequence
extends GameDataComponent
implements Iterable<GameStep> {
    private final List<GameStep> m_steps = new ArrayList<GameStep>();
    private int m_currentIndex;
    private int m_round = 1;
    private int m_roundOffset = 0;
    private transient Object m_currentStepMutex = new Object();
    private static final long serialVersionUID = 8205078386807440137L;

    public GameSequence(GameData data) {
        super(data);
    }

    public synchronized void setRoundAndStep(int currentRound, String stepDisplayName, PlayerID player) {
        System.out.println("Finding step for: Player: " + player + "  at Step: " + stepDisplayName);
        this.m_round = currentRound;
        boolean found = false;
        for (int i = 0; i < this.m_steps.size(); ++i) {
            GameStep step = this.m_steps.get(i);
            if (step == null || !step.getDisplayName().equalsIgnoreCase(stepDisplayName) || (player != null || step.getPlayerID() != null) && (player == null || !player.equals(step.getPlayerID()))) continue;
            this.m_currentIndex = i;
            found = true;
            break;
        }
        if (!found) {
            this.m_currentIndex = 0;
            System.out.println("Step Not Found, will instead use: " + this.m_steps.get(this.m_currentIndex));
        } else {
            System.out.println("Step Found: " + this.m_steps.get(this.m_currentIndex));
        }
    }

    protected void addStep(GameStep step) {
        this.m_steps.add(step);
    }

    protected void remove(GameStep step) {
        if (!this.m_steps.contains(step)) {
            throw new IllegalArgumentException("Step does not exist");
        }
        this.m_steps.remove(step);
    }

    protected void removeStep(int index) {
        this.m_steps.remove(index);
    }

    protected void removeAllSteps() {
        this.m_steps.clear();
        this.m_round = 1;
    }

    public int getRound() {
        return this.m_round + this.m_roundOffset;
    }

    public int getRoundOffset() {
        return this.m_roundOffset;
    }

    public void setRoundOffset(int roundOffset) {
        this.m_roundOffset = roundOffset;
    }

    public int getStepIndex() {
        return this.m_currentIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() {
        Object object = this.m_currentStepMutex;
        synchronized (object) {
            ++this.m_currentIndex;
            if (this.m_currentIndex == this.m_steps.size()) {
                this.m_currentIndex = 0;
                ++this.m_round;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testWeAreOnLastStep() {
        Object object = this.m_currentStepMutex;
        synchronized (object) {
            return this.m_currentIndex + 1 == this.m_steps.size();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GameStep getStep() {
        Object object = this.m_currentStepMutex;
        synchronized (object) {
            return this.getStep(this.m_currentIndex);
        }
    }

    public GameStep getStep(int index) {
        if (index < 0 || index >= this.m_steps.size()) {
            throw new IllegalArgumentException("Attempt to access invalid state: " + index);
        }
        return this.m_steps.get(index);
    }

    @Override
    public Iterator<GameStep> iterator() {
        return this.m_steps.iterator();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.m_currentStepMutex == null) {
            this.m_currentStepMutex = new Object();
        }
    }
}

