/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameSequence;
import games.strategy.engine.data.GameStep;
import java.util.ArrayList;

class GameSequenceChange
extends Change {
    private static final long serialVersionUID = -8925565771506676074L;
    private final GameStep[] m_oldSteps;
    private final GameStep[] m_newSteps;

    GameSequenceChange(GameSequence oldSequence, GameStep[] newSteps) {
        ArrayList<GameStep> oldSteps = new ArrayList<GameStep>();
        for (GameStep step : oldSequence) {
            oldSteps.add(step);
        }
        this.m_oldSteps = oldSteps.toArray(new GameStep[oldSteps.size()]);
        this.m_newSteps = newSteps;
    }

    private GameSequenceChange(GameStep[] oldSteps, GameStep[] newSteps) {
        this.m_oldSteps = oldSteps;
        this.m_newSteps = newSteps;
    }

    protected void perform(GameData data) {
        GameSequence steps = data.getSequence();
        steps.removeAllSteps();
        for (GameStep newStep : this.m_newSteps) {
            steps.addStep(newStep);
        }
    }

    public Change invert() {
        return new GameSequenceChange(this.m_newSteps, this.m_oldSteps);
    }
}

