/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameDataComponent;
import games.strategy.engine.data.PlayerID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerList
extends GameDataComponent
implements Iterable<PlayerID> {
    private static final long serialVersionUID = -3895068111754745446L;
    private final Map<String, PlayerID> m_players = new LinkedHashMap<String, PlayerID>();

    public PlayerList(GameData data) {
        super(data);
    }

    protected void addPlayerID(PlayerID player) {
        this.m_players.put(player.getName(), player);
    }

    public int size() {
        return this.m_players.size();
    }

    public PlayerID getPlayerID(String name) {
        if (PlayerID.NULL_PLAYERID.getName().equals(name)) {
            return PlayerID.NULL_PLAYERID;
        }
        return this.m_players.get(name);
    }

    public String[] getNames() {
        String[] values = new String[this.size()];
        this.m_players.keySet().toArray(values);
        return values;
    }

    public Collection<PlayerID> getPlayers() {
        return new ArrayList<PlayerID>(this.m_players.values());
    }

    @Override
    public Iterator<PlayerID> iterator() {
        return this.getPlayers().iterator();
    }
}

