/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.net.INode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerManager {
    private final Map<String, INode> m_playerMapping;

    public PlayerManager(Map<String, INode> map) {
        this.m_playerMapping = new HashMap<String, INode>(map);
    }

    public Map<String, INode> getPlayerMapping() {
        return new HashMap<String, INode>(this.m_playerMapping);
    }

    public String toString() {
        if (this.m_playerMapping == null || this.m_playerMapping.isEmpty()) {
            return "empty";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = this.m_playerMapping.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next();
            INode value = this.m_playerMapping.get(key);
            sb.append(key + "=" + value.getName());
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public Set<INode> getNodes() {
        return new HashSet<INode>(this.m_playerMapping.values());
    }

    public INode getNode(String playerName) {
        return this.m_playerMapping.get(playerName);
    }

    public boolean isPlaying(INode node) {
        return this.m_playerMapping.containsValue(node);
    }

    public Set<String> getPlayers() {
        return new HashSet<String>(this.m_playerMapping.keySet());
    }

    public Set<String> getPlayedBy(INode playerNode) {
        HashSet<String> rVal = new HashSet<String>();
        for (String player : this.m_playerMapping.keySet()) {
            if (!this.m_playerMapping.get(player).equals(playerNode)) continue;
            rVal.add(player);
        }
        return rVal;
    }

    public PlayerID getRemoteOpponent(INode localNode, GameData data) {
        PlayerID local = null;
        for (String player : this.m_playerMapping.keySet()) {
            if (!this.m_playerMapping.get(player).equals(localNode)) continue;
            local = data.getPlayerList().getPlayerID(player);
            break;
        }
        if (local == null) {
            String remote = this.m_playerMapping.keySet().iterator().next();
            return data.getPlayerList().getPlayerID(remote);
        }
        String any = null;
        for (String player : this.m_playerMapping.keySet()) {
            if (this.m_playerMapping.get(player).equals(localNode)) continue;
            any = player;
            PlayerID remotePlayerID = data.getPlayerList().getPlayerID(player);
            if (data.getRelationshipTracker().isAllied(local, remotePlayerID)) continue;
            return remotePlayerID;
        }
        return data.getPlayerList().getPlayerID(any);
    }
}

