/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.net.GUID;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PlayerOwnerChange
extends Change {
    private final Map<GUID, String> m_old;
    private final Map<GUID, String> m_new;
    private final String m_location;
    private static final long serialVersionUID = -9154938431233632882L;

    PlayerOwnerChange(Collection<Unit> units, PlayerID newOwner, Territory location) {
        this.m_old = new HashMap<GUID, String>();
        this.m_new = new HashMap<GUID, String>();
        this.m_location = location.getName();
        for (Unit unit : units) {
            this.m_old.put(unit.getID(), unit.getOwner().getName());
            this.m_new.put(unit.getID(), newOwner.getName());
        }
    }

    PlayerOwnerChange(Map<GUID, String> newOwner, Map<GUID, String> oldOwner, String location) {
        this.m_old = oldOwner;
        this.m_new = newOwner;
        this.m_location = location;
    }

    @Override
    public Change invert() {
        return new PlayerOwnerChange(this.m_old, this.m_new, this.m_location);
    }

    @Override
    protected void perform(GameData data) {
        for (GUID id : this.m_new.keySet()) {
            Unit unit = data.getUnits().get(id);
            if (!this.m_old.get(id).equals(unit.getOwner().getName())) {
                throw new IllegalStateException("Wrong owner, expecting" + this.m_old.get(id) + " but got " + unit.getOwner());
            }
            String owner = this.m_new.get(id);
            PlayerID player = data.getPlayerList().getPlayerID(owner);
            unit.setOwner(player);
        }
        data.getMap().getTerritory(this.m_location).notifyChanged();
    }

    public String toString() {
        return "Some units change owners in territory " + this.m_location;
    }
}

