/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionFrontier;

class ProductionFrontierChange
extends Change {
    private final String m_startFrontier;
    private final String m_endFrontier;
    private final String m_player;
    private static final long serialVersionUID = 3336145814067456701L;

    ProductionFrontierChange(ProductionFrontier newFrontier, PlayerID player) {
        this.m_startFrontier = player.getProductionFrontier().getName();
        this.m_endFrontier = newFrontier.getName();
        this.m_player = player.getName();
    }

    ProductionFrontierChange(String startFrontier, String endFrontier, String player) {
        this.m_startFrontier = startFrontier;
        this.m_endFrontier = endFrontier;
        this.m_player = player;
    }

    protected void perform(GameData data) {
        PlayerID player = data.getPlayerList().getPlayerID(this.m_player);
        ProductionFrontier frontier = data.getProductionFrontierList().getProductionFrontier(this.m_endFrontier);
        player.setProductionFrontier(frontier);
    }

    public Change invert() {
        return new ProductionFrontierChange(this.m_endFrontier, this.m_startFrontier, this.m_player);
    }
}

