/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.DefaultNamed;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.NamedAttachable;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.UnitType;
import games.strategy.util.IntegerMap;
import java.io.Serializable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductionRule
extends DefaultNamed
implements Serializable {
    private static final long serialVersionUID = -6598296283127741307L;
    private IntegerMap<Resource> m_cost = new IntegerMap();
    private IntegerMap<NamedAttachable> m_results = new IntegerMap();

    public ProductionRule(String name, GameData data) {
        super(name, data);
    }

    public ProductionRule(String name, GameData data, IntegerMap<NamedAttachable> results, IntegerMap<Resource> costs) {
        super(name, data);
        this.m_results = results;
        this.m_cost = costs;
    }

    protected void addCost(Resource resource, int quantity) {
        this.m_cost.put(resource, quantity);
    }

    protected void addResult(NamedAttachable obj, int quantity) {
        if (!(obj instanceof UnitType) && !(obj instanceof Resource)) {
            throw new IllegalArgumentException("results must be units or resources, not:" + obj.getClass().getName());
        }
        this.m_results.put(obj, quantity);
    }

    public IntegerMap<Resource> getCosts() {
        return this.m_cost.copy();
    }

    public IntegerMap<NamedAttachable> getResults() {
        return this.m_results;
    }

    @Override
    public String toString() {
        return "ProductionRule:" + this.getName();
    }

    public String toStringCosts() {
        StringBuilder sb = new StringBuilder();
        Resource pus = this.getData().getResourceList().getResource("PUs");
        if (this.m_cost.getInt(pus) != 0) {
            sb.append("; ");
            sb.append(this.m_cost.getInt(pus));
            sb.append(" " + pus.getName());
        }
        for (Map.Entry<Resource, Integer> entry : this.m_cost.entrySet()) {
            Resource r = entry.getKey();
            if (r.equals(pus)) continue;
            int c = entry.getValue();
            sb.append("; ");
            sb.append(c);
            sb.append(" " + r.getName());
        }
        return sb.toString().replaceFirst("; ", "");
    }
}

