/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.AddAvailableTech;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.TechnologyFrontier;
import games.strategy.triplea.delegate.TechAdvance;

class RemoveAvailableTech
extends Change {
    private static final long serialVersionUID = 6131447662760022521L;
    private final TechAdvance m_tech;
    private final TechnologyFrontier m_frontier;
    private final PlayerID m_player;

    public RemoveAvailableTech(TechnologyFrontier front, TechAdvance tech, PlayerID player) {
        if (front == null) {
            throw new IllegalArgumentException("Null tech category");
        }
        if (tech == null) {
            throw new IllegalArgumentException("Null tech");
        }
        this.m_tech = tech;
        this.m_frontier = front;
        this.m_player = player;
    }

    public void perform(GameData data) {
        TechnologyFrontier front = this.m_player.getTechnologyFrontierList().getTechnologyFrontier(this.m_frontier.getName());
        front.removeAdvance(this.m_tech);
    }

    public Change invert() {
        return new AddAvailableTech(this.m_frontier, this.m_tech, this.m_player);
    }
}

