/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.NamedAttachable;
import games.strategy.engine.data.NamedUnitHolder;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.UnitCollection;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rule
extends NamedAttachable
implements NamedUnitHolder,
Serializable,
Comparable<Rule> {
    private static final long serialVersionUID = -6390555051736721082L;
    private final boolean m_water;
    private final PlayerID m_owner = PlayerID.NULL_PLAYERID;
    private final UnitCollection m_units;
    int[] m_coordinate = null;

    public Rule(String name, boolean water, GameData data) {
        super(name, data);
        this.m_water = water;
        this.m_units = new UnitCollection(this, this.getData());
    }

    public Rule(String name, boolean water, GameData data, int ... coordinate) {
        super(name, data);
        this.m_water = water;
        this.m_units = new UnitCollection(this, this.getData());
        if (!data.getMap().isCoordinateValid(coordinate)) {
            throw new IllegalArgumentException("Invalid coordinate: " + coordinate[0] + "," + coordinate[1]);
        }
        this.m_coordinate = coordinate;
    }

    public boolean isWater() {
        return this.m_water;
    }

    public PlayerID getOwner() {
        return this.m_owner;
    }

    @Override
    public UnitCollection getUnits() {
        return this.m_units;
    }

    @Override
    public void notifyChanged() {
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(Rule r) {
        return this.getName().compareTo(r.getName());
    }

    @Override
    public String getType() {
        return "T";
    }

    public boolean matchesCoordinates(int ... coordinate) {
        if (coordinate.length != this.m_coordinate.length) {
            return false;
        }
        for (int i = 0; i < coordinate.length; ++i) {
            if (coordinate[i] == this.m_coordinate[i]) continue;
            return false;
        }
        return true;
    }

    public int getX() {
        try {
            return this.m_coordinate[0];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RuntimeException("Territory " + this.getName() + " doesn't have a defined x coordinate");
        }
    }

    public int getY() {
        try {
            return this.m_coordinate[1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RuntimeException("Territory " + this.getName() + " doesn't have a defined y coordinate");
        }
    }
}

