/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameDataComponent;
import games.strategy.engine.data.TechnologyFrontier;
import games.strategy.triplea.delegate.TechAdvance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TechnologyFrontierList
extends GameDataComponent {
    private static final long serialVersionUID = 2958122401265284935L;
    private final List<TechnologyFrontier> m_technologyFrontiers = new ArrayList<TechnologyFrontier>();

    public TechnologyFrontierList(GameData data) {
        super(data);
    }

    public void addTechnologyFrontier(TechnologyFrontier tf) {
        this.m_technologyFrontiers.add(tf);
    }

    public void addTechnologyFrontier(List<TechnologyFrontier> tfs) {
        for (TechnologyFrontier tf : tfs) {
            this.m_technologyFrontiers.add(tf);
        }
    }

    public int size() {
        return this.m_technologyFrontiers.size();
    }

    public TechnologyFrontier getTechnologyFrontier(String name) {
        for (TechnologyFrontier tf : this.m_technologyFrontiers) {
            if (!tf.getName().equals(name)) continue;
            return tf;
        }
        return null;
    }

    public List<TechAdvance> getAdvances() {
        ArrayList<TechAdvance> techs = new ArrayList<TechAdvance>();
        for (TechnologyFrontier t : this.m_technologyFrontiers) {
            techs.addAll(t.getTechs());
        }
        return techs;
    }

    public List<TechnologyFrontier> getFrontiers() {
        return Collections.unmodifiableList(this.m_technologyFrontiers);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }
}

