/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.NamedAttachable;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.ui.TooltipProperties;
import games.strategy.util.LocalizeHTML;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitType
extends NamedAttachable
implements Serializable {
    private static final long serialVersionUID = 4885339076798905247L;

    public UnitType(String name, GameData data) {
        super(name, data);
    }

    public List<Unit> create(int quantity, PlayerID owner) {
        return this.create(quantity, owner, false);
    }

    public List<Unit> create(int quantity, PlayerID owner, boolean isTemp) {
        ArrayList<Unit> collection = new ArrayList<Unit>();
        for (int i = 0; i < quantity; ++i) {
            collection.add(this.create(owner, isTemp));
        }
        return collection;
    }

    private Unit create(PlayerID owner, boolean isTemp) {
        Unit u = this.getData().getGameLoader().getUnitFactory().createUnit(this, owner, this.getData());
        if (!isTemp) {
            this.getData().getUnits().put(u);
        }
        return u;
    }

    public Unit create(PlayerID owner) {
        return this.create(owner, false);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof UnitType)) {
            return false;
        }
        return ((UnitType)o).getName().equals(this.getName());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getTooltip(PlayerID playerId, boolean useHTML) {
        String customTip = TooltipProperties.getInstance().getToolTip(this, playerId);
        if (customTip == null || customTip.trim().length() <= 0) {
            return UnitAttachment.get(this).toStringShortAndOnlyImportantDifferences(playerId, useHTML, false);
        }
        return LocalizeHTML.localizeImgLinksInHTML(customTip.trim());
    }
}

