/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameDataComponent;
import games.strategy.engine.data.UnitType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitTypeList
extends GameDataComponent
implements Iterable<UnitType> {
    private static final long serialVersionUID = 9002927658524651749L;
    private final Map<String, UnitType> m_unitTypes = new HashMap<String, UnitType>();

    public UnitTypeList(GameData data) {
        super(data);
    }

    protected void addUnitType(UnitType type) {
        this.m_unitTypes.put(type.getName(), type);
    }

    public UnitType getUnitType(String name) {
        return this.m_unitTypes.get(name);
    }

    public Set<UnitType> getUnitTypes(String[] names) {
        HashSet<UnitType> types = new HashSet<UnitType>();
        for (String name : names) {
            UnitType type = this.m_unitTypes.get(name);
            if (type == null) {
                return null;
            }
            types.add(type);
        }
        return types;
    }

    public int size() {
        return this.m_unitTypes.size();
    }

    @Override
    public Iterator<UnitType> iterator() {
        return this.m_unitTypes.values().iterator();
    }

    public Set<UnitType> getAllUnitTypes() {
        return new LinkedHashSet<UnitType>(this.m_unitTypes.values());
    }
}

