/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data.export;

import games.strategy.engine.EngineVersion;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.GameStep;
import games.strategy.engine.data.IAttachment;
import games.strategy.engine.data.NamedAttachable;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionFrontier;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.RelationshipTracker;
import games.strategy.engine.data.RelationshipType;
import games.strategy.engine.data.RepairFrontier;
import games.strategy.engine.data.RepairRule;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.TechnologyFrontier;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.TerritoryEffect;
import games.strategy.engine.data.UnitCollection;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.data.export.AttachmentExportException;
import games.strategy.engine.data.export.AttachmentExporterFactory;
import games.strategy.engine.data.export.IAttachmentExporter;
import games.strategy.engine.data.properties.BooleanProperty;
import games.strategy.engine.data.properties.ColorProperty;
import games.strategy.engine.data.properties.ComboProperty;
import games.strategy.engine.data.properties.FileProperty;
import games.strategy.engine.data.properties.GameProperties;
import games.strategy.engine.data.properties.IEditableProperty;
import games.strategy.engine.data.properties.NumberProperty;
import games.strategy.engine.data.properties.StringProperty;
import games.strategy.engine.delegate.IDelegate;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.delegate.TechAdvance;
import games.strategy.util.IntegerMap;
import games.strategy.util.Tuple;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameDataExporter {
    private final StringBuffer xmlfile = new StringBuffer();

    public GameDataExporter(GameData data, boolean currentAttachmentObjects) {
        this.init(data);
        this.tripleaMinimumVersion();
        this.diceSides(data);
        this.map(data);
        this.resourceList(data);
        this.playerList(data);
        this.unitList(data);
        this.relationshipTypeList(data);
        this.territoryEffectList(data);
        this.gamePlay(data);
        this.production(data);
        this.technology(data);
        this.attachments(data, currentAttachmentObjects);
        this.initialize(data);
        this.propertyList(data);
        this.finish();
    }

    private void tripleaMinimumVersion() {
        this.xmlfile.append("    <triplea minimumVersion=\"" + EngineVersion.VERSION + "\"/>\n");
    }

    private void diceSides(GameData data) {
        int diceSides = data.getDiceSides();
        this.xmlfile.append("    <diceSides value=\"" + diceSides + "\"/>\n");
    }

    private void technology(GameData data) {
        String technologies = this.technologies(data);
        String playerTechs = this.playertechs(data);
        if (technologies.length() > 0 || playerTechs.length() > 0) {
            this.xmlfile.append("    <technology>\n");
            this.xmlfile.append(technologies);
            this.xmlfile.append(playerTechs);
            this.xmlfile.append("    </technology>\n");
        }
    }

    private String playertechs(GameData data) {
        Iterator<PlayerID> players = data.getPlayerList().iterator();
        StringBuffer returnValue = new StringBuffer();
        while (players.hasNext()) {
            PlayerID player = players.next();
            Iterator<TechnologyFrontier> frontierList = player.getTechnologyFrontierList().getFrontiers().iterator();
            if (!frontierList.hasNext()) continue;
            returnValue.append("        <playerTech player=\"" + player.getName() + "\">\n");
            while (frontierList.hasNext()) {
                TechnologyFrontier frontier = frontierList.next();
                returnValue.append("            <category name=\"" + frontier.getName() + "\">\n");
                for (TechAdvance tech : frontier.getTechs()) {
                    String name = tech.getName();
                    String cat = tech.getProperty();
                    for (String definedName : TechAdvance.s_allPreDefinedTechnologyNames) {
                        if (!definedName.equals(name)) continue;
                        name = cat;
                    }
                    returnValue.append("                <tech name=\"" + name + "\"/>\n");
                }
                returnValue.append("            </category>\n");
            }
            returnValue.append("        </playerTech>\n");
        }
        return returnValue.toString();
    }

    private String technologies(GameData data) {
        Iterator<TechAdvance> techs = data.getTechnologyFrontier().getTechs().iterator();
        StringBuffer returnValue = new StringBuffer();
        if (techs.hasNext()) {
            returnValue.append("        <technologies>\n");
            while (techs.hasNext()) {
                TechAdvance tech = techs.next();
                String name = tech.getName();
                String cat = tech.getProperty();
                for (String definedName : TechAdvance.s_allPreDefinedTechnologyNames) {
                    if (!definedName.equals(name)) continue;
                    name = cat;
                }
                returnValue.append("            <techname name=\"" + name + "\"");
                if (!name.equals(cat)) {
                    returnValue.append(" tech=\"" + cat + "\" ");
                }
                returnValue.append("/>\n");
            }
            returnValue.append("        </technologies>\n");
        }
        return returnValue.toString();
    }

    private void propertyList(GameData data) {
        this.xmlfile.append("    <propertyList>\n");
        try {
            GameProperties gameProperties = data.getProperties();
            Field conPropField = GameProperties.class.getDeclaredField("m_constantProperties");
            conPropField.setAccessible(true);
            Field edPropField = GameProperties.class.getDeclaredField("m_editableProperties");
            edPropField.setAccessible(true);
            this.printConstantProperties((Map)conPropField.get(gameProperties));
            this.printEditableProperties((Map)edPropField.get(gameProperties));
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.xmlfile.append("    </propertyList>\n");
    }

    private void printEditableProperties(Map<String, IEditableProperty> edProperties) {
        Iterator<String> propertyNames = edProperties.keySet().iterator();
        while (propertyNames.hasNext()) {
            this.printEditableProperty(edProperties.get(propertyNames.next()));
        }
    }

    private void printEditableProperty(IEditableProperty prop) {
        String typeString = "";
        String value = "" + prop.getValue();
        if (prop.getClass().equals(BooleanProperty.class)) {
            typeString = "            <boolean/>\n";
        }
        if (prop.getClass().equals(FileProperty.class)) {
            typeString = "            <file/>\n";
        }
        if (prop.getClass().equals(StringProperty.class)) {
            typeString = "            <string/>\n";
        }
        if (prop.getClass().equals(ColorProperty.class)) {
            typeString = "            <color/>\n";
            value = "0x" + Integer.toHexString((Integer)prop.getValue()).toUpperCase();
        }
        if (prop.getClass().equals(ComboProperty.class)) {
            try {
                Field listField = ComboProperty.class.getDeclaredField("m_possibleValues");
                listField.setAccessible(true);
                Iterator values = ((ArrayList)listField.get(prop)).iterator();
                String possibleValues = (String)values.next();
                while (values.hasNext()) {
                    possibleValues = possibleValues + "," + (String)values.next();
                }
                typeString = "            <list>" + possibleValues + "</list>\n";
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (prop.getClass().equals(NumberProperty.class)) {
            try {
                Field maxField = NumberProperty.class.getDeclaredField("m_max");
                Field minField = NumberProperty.class.getDeclaredField("m_min");
                maxField.setAccessible(true);
                minField.setAccessible(true);
                int max = maxField.getInt(prop);
                int min = minField.getInt(prop);
                typeString = "            <number min=\"" + min + "\" max=\"" + max + "\"/>\n";
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        this.xmlfile.append("        <property name=\"" + prop.getName() + "\" value=\"" + value + "\" editable=\"true\">\n");
        this.xmlfile.append(typeString);
        this.xmlfile.append("        </property>\n");
    }

    private void printConstantProperties(Map<String, Object> conProperties) {
        for (String propName : conProperties.keySet()) {
            if (propName.equals("notes")) {
                this.printNotes((String)conProperties.get(propName));
                continue;
            }
            if (propName.equals("EditMode") || propName.equals("GAME_UUID") || propName.equals("games.strategy.engine.framework.ServerGame.GameHasBeenSaved")) continue;
            this.printConstantProperty(propName, conProperties.get(propName));
        }
    }

    private void printNotes(String notes) {
        this.xmlfile.append("        <property name=\"notes\">\n");
        this.xmlfile.append("            <value>\n");
        this.xmlfile.append("            <![CDATA[\n");
        this.xmlfile.append(notes);
        this.xmlfile.append("]]>\n");
        this.xmlfile.append("            </value>\n");
        this.xmlfile.append("        </property>\n");
    }

    private void printConstantProperty(String propName, Object property) {
        this.xmlfile.append("        <property name=\"" + propName + "\" value=\"" + property.toString() + "\" editable=\"false\">\n");
        if (property.getClass().equals(String.class)) {
            this.xmlfile.append("            <string/>\n");
        }
        if (property.getClass().equals(File.class)) {
            this.xmlfile.append("            <file/>\n");
        }
        if (property.getClass().equals(Boolean.class)) {
            this.xmlfile.append("            <boolean/>\n");
        }
        this.xmlfile.append("        </property>\n");
    }

    private void initialize(GameData data) {
        this.xmlfile.append("    <initialize>\n");
        this.ownerInitialize(data);
        this.unitInitialize(data);
        this.resourceInitialize(data);
        this.relationshipInitialize(data);
        this.xmlfile.append("    </initialize>\n");
    }

    private void relationshipInitialize(GameData data) {
        if (data.getRelationshipTypeList().getAllRelationshipTypes().size() <= 4) {
            return;
        }
        RelationshipTracker rt = data.getRelationshipTracker();
        this.xmlfile.append("        <relationshipInitialize>\n");
        Collection<PlayerID> players = data.getPlayerList().getPlayers();
        HashSet<PlayerID> playersAlreadyDone = new HashSet<PlayerID>();
        for (PlayerID p1 : players) {
            for (PlayerID p2 : players) {
                if (p1.equals(p2) || playersAlreadyDone.contains(p2)) continue;
                RelationshipType type = rt.getRelationshipType(p1, p2);
                int roundValue = rt.getRoundRelationshipWasCreated(p1, p2);
                this.xmlfile.append("            <relationship type=\"" + type.getName() + "\" player1=\"" + p1.getName() + "\" player2=\"" + p2.getName() + "\" roundValue=\"" + roundValue + "\"/>\n");
            }
            playersAlreadyDone.add(p1);
        }
        this.xmlfile.append("        </relationshipInitialize>\n");
    }

    private void resourceInitialize(GameData data) {
        this.xmlfile.append("        <resourceInitialize>\n");
        for (PlayerID player : data.getPlayerList()) {
            for (Resource resource : data.getResourceList().getResources()) {
                if (player.getResources().getQuantity(resource.getName()) <= 0) continue;
                this.xmlfile.append("            <resourceGiven player=\"" + player.getName() + "\" resource=\"" + resource.getName() + "\" quantity=\"" + player.getResources().getQuantity(resource.getName()) + "\"/>\n");
            }
        }
        this.xmlfile.append("        </resourceInitialize>\n");
    }

    private void unitInitialize(GameData data) {
        this.xmlfile.append("        <unitInitialize>\n");
        for (Territory terr : data.getMap().getTerritories()) {
            UnitCollection uc = terr.getUnits();
            for (PlayerID player : uc.getPlayersWithUnits()) {
                IntegerMap<UnitType> ucp = uc.getUnitsByType(player);
                for (UnitType unit : ucp.keySet()) {
                    if (player == null || player.getName().equals("Neutral")) {
                        this.xmlfile.append("            <unitPlacement unitType=\"" + unit.getName() + "\" territory=\"" + terr.getName() + "\" quantity=\"" + ucp.getInt(unit) + "\"/>\n");
                        continue;
                    }
                    this.xmlfile.append("            <unitPlacement unitType=\"" + unit.getName() + "\" territory=\"" + terr.getName() + "\" quantity=\"" + ucp.getInt(unit) + "\" owner=\"" + player.getName() + "\"/>\n");
                }
            }
        }
        this.xmlfile.append("        </unitInitialize>\n");
    }

    private void ownerInitialize(GameData data) {
        this.xmlfile.append("        <ownerInitialize>\n");
        for (Territory terr : data.getMap().getTerritories()) {
            if (terr.getOwner().getName().equals("Neutral")) continue;
            this.xmlfile.append("            <territoryOwner territory=\"" + terr.getName() + "\" owner=\"" + terr.getOwner().getName() + "\"/>\n");
        }
        this.xmlfile.append("        </ownerInitialize>\n");
    }

    private void attachments(GameData data, boolean currentAttachmentObjects) {
        this.xmlfile.append("\n");
        this.xmlfile.append("    <attatchmentList>\n");
        for (Tuple<IAttachment, ArrayList<Tuple<String, String>>> current : data.getAttachmentOrderAndValues()) {
            this.printAttachments(current, currentAttachmentObjects);
        }
        this.xmlfile.append("    </attatchmentList>\n");
    }

    private String printAttachmentOptionsBasedOnOriginalXML(ArrayList<Tuple<String, String>> attachmentPlusValues, IAttachment attachment) {
        TerritoryAttachment ta;
        if (attachmentPlusValues.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer("");
        boolean alreadyHasOccupiedTerrOf = false;
        for (Tuple<String, String> current : attachmentPlusValues) {
            sb.append("            <option name=\"" + current.getFirst() + "\" value=\"" + current.getSecond() + "\"/>\n");
            if (!current.getFirst().equals("occupiedTerrOf")) continue;
            alreadyHasOccupiedTerrOf = true;
        }
        if (!alreadyHasOccupiedTerrOf && attachment instanceof TerritoryAttachment && (ta = (TerritoryAttachment)attachment).getOriginalOwner() != null) {
            sb.append("            <option name=\"occupiedTerrOf\" value=\"" + ta.getOriginalOwner().getName() + "\"/>\n");
        }
        return sb.toString();
    }

    private void printAttachments(Tuple<IAttachment, ArrayList<Tuple<String, String>>> attachmentPlusValues, boolean currentAttachmentObjects) {
        try {
            String attachmentOptions;
            IAttachment attachment = attachmentPlusValues.getFirst();
            if (currentAttachmentObjects) {
                IAttachmentExporter exporter = AttachmentExporterFactory.getExporter(attachment);
                attachmentOptions = exporter.getAttachmentOptions(attachment);
            } else {
                attachmentOptions = this.printAttachmentOptionsBasedOnOriginalXML(attachmentPlusValues.getSecond(), attachment);
            }
            NamedAttachable attachTo = (NamedAttachable)attachment.getAttachedTo();
            String type = "";
            if (attachTo.getClass().equals(PlayerID.class)) {
                type = "player";
            }
            if (attachTo.getClass().equals(UnitType.class)) {
                type = "unitType";
            }
            if (attachTo.getClass().equals(Territory.class)) {
                type = "territory";
            }
            if (attachTo.getClass().equals(TerritoryEffect.class)) {
                type = "territoryEffect";
            }
            if (attachTo.getClass().equals(Resource.class)) {
                type = "resource";
            }
            if (attachTo.getClass().equals(RelationshipType.class)) {
                type = "relationship";
            }
            if (TechAdvance.class.isAssignableFrom(attachTo.getClass())) {
                type = "technology";
            }
            if (type.equals("")) {
                throw new AttachmentExportException("no attachmentType known for " + attachTo.getClass().getCanonicalName());
            }
            if (attachmentOptions.length() > 0) {
                this.xmlfile.append("        <attatchment name=\"" + attachment.getName() + "\" attatchTo=\"" + attachTo.getName() + "\" javaClass=\"" + attachment.getClass().getCanonicalName() + "\" type=\"" + type + "\">\n");
                this.xmlfile.append(attachmentOptions);
                this.xmlfile.append("        </attatchment>\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void production(GameData data) {
        this.xmlfile.append("\n");
        this.xmlfile.append("    <production>\n");
        this.productionRules(data);
        this.repairRules(data);
        this.repairFrontiers(data);
        this.productionFrontiers(data);
        this.playerProduction(data);
        this.playerRepair(data);
        this.xmlfile.append("    </production>\n");
    }

    private void repairRules(GameData data) {
        for (RepairRule rr : data.getRepairRuleList().getRepairRules()) {
            this.xmlfile.append("        <repairRule name=\"" + rr.getName() + "\">\n");
            for (Resource cost : rr.getCosts().keySet()) {
                this.xmlfile.append("            <cost resource=\"" + cost.getName() + "\" quantity=\"" + rr.getCosts().getInt(cost) + "\"/>\n");
            }
            for (NamedAttachable result : rr.getResults().keySet()) {
                this.xmlfile.append("            <result resourceOrUnit=\"" + result.getName() + "\" quantity=\"" + rr.getResults().getInt(result) + "\"/>\n");
            }
            this.xmlfile.append("        </repairRule>\n");
        }
    }

    private void repairFrontiers(GameData data) {
        Iterator<String> frontiers = data.getRepairFrontierList().getRepairFrontierNames().iterator();
        while (frontiers.hasNext()) {
            RepairFrontier frontier = data.getRepairFrontierList().getRepairFrontier(frontiers.next());
            this.xmlfile.append("\n");
            this.xmlfile.append("        <repairFrontier name=\"" + frontier.getName() + "\">\n");
            Iterator<RepairRule> rules = frontier.getRules().iterator();
            while (rules.hasNext()) {
                this.xmlfile.append("            <repairRules name=\"" + rules.next().getName() + "\"/>\n");
            }
            this.xmlfile.append("        </repairFrontier>\n");
        }
        this.xmlfile.append("\n");
    }

    private void playerRepair(GameData data) {
        for (PlayerID player : data.getPlayerList()) {
            try {
                String playerRepair = player.getRepairFrontier().getName();
                String playername = player.getName();
                this.xmlfile.append("        <playerRepair player=\"" + playername + "\" frontier=\"" + playerRepair + "\"/>\n");
            }
            catch (NullPointerException npe) {}
        }
    }

    private void playerProduction(GameData data) {
        for (PlayerID player : data.getPlayerList()) {
            try {
                String playerfrontier = player.getProductionFrontier().getName();
                String playername = player.getName();
                this.xmlfile.append("        <playerProduction player=\"" + playername + "\" frontier=\"" + playerfrontier + "\"/>\n");
            }
            catch (NullPointerException npe) {}
        }
    }

    private void productionFrontiers(GameData data) {
        Iterator<String> frontiers = data.getProductionFrontierList().getProductionFrontierNames().iterator();
        while (frontiers.hasNext()) {
            ProductionFrontier frontier = data.getProductionFrontierList().getProductionFrontier(frontiers.next());
            this.xmlfile.append("\n");
            this.xmlfile.append("        <productionFrontier name=\"" + frontier.getName() + "\">\n");
            Iterator<ProductionRule> rules = frontier.getRules().iterator();
            while (rules.hasNext()) {
                this.xmlfile.append("            <frontierRules name=\"" + rules.next().getName() + "\"/>\n");
            }
            this.xmlfile.append("        </productionFrontier>\n");
        }
        this.xmlfile.append("\n");
    }

    private void productionRules(GameData data) {
        for (ProductionRule pr : data.getProductionRuleList().getProductionRules()) {
            this.xmlfile.append("        <productionRule name=\"" + pr.getName() + "\">\n");
            for (Resource cost : pr.getCosts().keySet()) {
                this.xmlfile.append("            <cost resource=\"" + cost.getName() + "\" quantity=\"" + pr.getCosts().getInt(cost) + "\"/>\n");
            }
            for (NamedAttachable result : pr.getResults().keySet()) {
                this.xmlfile.append("            <result resourceOrUnit=\"" + result.getName() + "\" quantity=\"" + pr.getResults().getInt(result) + "\"/>\n");
            }
            this.xmlfile.append("        </productionRule>\n");
        }
    }

    private void gamePlay(GameData data) {
        this.xmlfile.append("\n");
        this.xmlfile.append("    <gamePlay>\n");
        for (IDelegate delegate : data.getDelegateList()) {
            if (delegate.getName().equals("edit")) continue;
            this.xmlfile.append("        <delegate name=\"" + delegate.getName() + "\" javaClass=\"" + delegate.getClass().getCanonicalName() + "\" display=\"" + delegate.getDisplayName() + "\"/>\n");
        }
        this.sequence(data);
        this.xmlfile.append("        <offset round=\"" + (data.getSequence().getRound() - 1) + "\"/>\n");
        this.xmlfile.append("    </gamePlay>\n");
    }

    private void sequence(GameData data) {
        this.xmlfile.append("\n");
        this.xmlfile.append("        <sequence>\n");
        for (GameStep step : data.getSequence()) {
            try {
                Field mDelegateField = GameStep.class.getDeclaredField("m_delegate");
                mDelegateField.setAccessible(true);
                String delegate = (String)mDelegateField.get(step);
                this.xmlfile.append("            <step name=\"" + step.getName() + "\" delegate=\"" + delegate + "\"");
            }
            catch (NullPointerException npe) {
                npe.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (step.getPlayerID() != null) {
                this.xmlfile.append(" player=\"" + step.getPlayerID().getName() + "\"");
            }
            if (step.getDisplayName() != null) {
                this.xmlfile.append(" display=\"" + step.getDisplayName() + "\"");
            }
            if (step.getMaxRunCount() > -1) {
                int maxRun = step.getMaxRunCount();
                if (maxRun == 0) {
                    maxRun = 1;
                }
                this.xmlfile.append(" maxRunCount=\"" + maxRun + "\"");
            }
            this.xmlfile.append("/>\n");
        }
        this.xmlfile.append("        </sequence>\n");
    }

    private void unitList(GameData data) {
        this.xmlfile.append("\n");
        this.xmlfile.append("    <unitList>\n");
        Iterator<UnitType> units = data.getUnitTypeList().iterator();
        while (units.hasNext()) {
            this.xmlfile.append("        <unit name=\"" + units.next().getName() + "\"/>\n");
        }
        this.xmlfile.append("    </unitList>\n");
    }

    private void playerList(GameData data) {
        this.xmlfile.append("\n");
        this.xmlfile.append("    <playerList>\n");
        for (PlayerID player : data.getPlayerList().getPlayers()) {
            this.xmlfile.append("        <player name=\"" + player.getName() + "\" optional=\"" + player.getOptional() + "\"/>\n");
        }
        for (String allianceName : data.getAllianceTracker().getAlliances()) {
            Iterator<PlayerID> alliedPlayers = data.getAllianceTracker().getPlayersInAlliance(allianceName).iterator();
            while (alliedPlayers.hasNext()) {
                this.xmlfile.append("        <alliance player=\"" + alliedPlayers.next().getName() + "\" alliance=\"" + allianceName + "\"/>\n");
            }
        }
        this.xmlfile.append("    </playerList>\n");
    }

    private void relationshipTypeList(GameData data) {
        Collection<RelationshipType> types = data.getRelationshipTypeList().getAllRelationshipTypes();
        if (types.size() <= 4) {
            return;
        }
        this.xmlfile.append("\n");
        this.xmlfile.append("    <relationshipTypes>\n");
        for (RelationshipType current : types) {
            String name = current.getName();
            if (name.equals("self_relation") || name.equals("null_relation") || name.equals("default_war_relation") || name.equals("default_allied_relation")) continue;
            this.xmlfile.append("        <relationshipType name=\"" + name + "\"/>\n");
        }
        this.xmlfile.append("    </relationshipTypes>\n");
    }

    private void territoryEffectList(GameData data) {
        Collection<TerritoryEffect> types = data.getTerritoryEffectList().values();
        if (types.isEmpty()) {
            return;
        }
        this.xmlfile.append("\n");
        this.xmlfile.append("    <territoryEffectList>\n");
        for (TerritoryEffect current : types) {
            this.xmlfile.append("        <territoryEffect name=\"" + current.getName() + "\"/>\n");
        }
        this.xmlfile.append("    </territoryEffectList>\n");
    }

    private void resourceList(GameData data) {
        this.xmlfile.append("\n");
        this.xmlfile.append("    <resourceList>\n");
        Iterator<Resource> resources = data.getResourceList().getResources().iterator();
        while (resources.hasNext()) {
            this.xmlfile.append("        <resource name=\"" + resources.next().getName() + "\"/>\n");
        }
        this.xmlfile.append("    </resourceList>\n");
    }

    private void map(GameData data) {
        this.xmlfile.append("\n");
        this.xmlfile.append("    <map>\n");
        this.xmlfile.append("        <!-- Territory Definitions -->\n");
        GameMap map = data.getMap();
        for (Territory ter : map.getTerritories()) {
            this.xmlfile.append("        <territory name=\"" + ter.getName() + "\"");
            if (ter.isWater()) {
                this.xmlfile.append(" water=\"true\"");
            }
            this.xmlfile.append("/>\n");
        }
        this.connections(data);
        this.xmlfile.append("    </map>\n");
    }

    private void connections(GameData data) {
        this.xmlfile.append("        <!-- Territory Connections -->\n");
        GameMap map = data.getMap();
        ArrayList<Connection> reverseConnectionTracker = new ArrayList<Connection>();
        for (Territory ter : map.getTerritories()) {
            for (Territory nb : map.getNeighbors(ter)) {
                if (reverseConnectionTracker.contains(new Connection(ter, nb))) continue;
                this.xmlfile.append("        <connection t1=\"" + ter.getName() + "\" t2=\"" + nb.getName() + "\"/>\n");
                reverseConnectionTracker.add(new Connection(nb, ter));
            }
        }
    }

    private void init(GameData data) {
        this.xmlfile.append("<?xml version=\"1.0\"?>\n");
        this.xmlfile.append("<!DOCTYPE game SYSTEM \"game.dtd\">\n");
        this.xmlfile.append("<game>\n");
        this.xmlfile.append("    <info name=\"" + data.getGameName() + "\" version=\"" + data.getGameVersion().toString() + "\"/>\n");
        this.xmlfile.append("    <loader javaClass=\"" + data.getGameLoader().getClass().getCanonicalName() + "\"/>\n");
    }

    private void finish() {
        this.xmlfile.append("\n");
        this.xmlfile.append("</game>\n");
    }

    public String getXML() {
        return this.xmlfile.toString();
    }

    private class Connection {
        private final Territory _t1;
        private final Territory _t2;

        private Connection(Territory t1, Territory t2) {
            this._t1 = t1;
            this._t2 = t2;
        }

        public int hashCode() {
            return this._t1.hashCode() + this._t2.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            Connection con = (Connection)o;
            return this._t1 == con._t1 && this._t2 == con._t2;
        }
    }
}

