/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data.export;

import games.strategy.engine.data.IAttachment;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.export.AttachmentExportException;
import games.strategy.engine.data.export.DefaultAttachmentExporter;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import java.lang.reflect.Field;

public class TerritoryAttachmentExporter
extends DefaultAttachmentExporter {
    protected String printOption(Field field, IAttachment attachment) throws AttachmentExportException {
        String fieldName = field.getName();
        if (fieldName.equals("m_changeUnitOwners")) {
            return this.mChangeUnitOwnersHandler(field, attachment);
        }
        if (fieldName.equals("m_captureUnitOnEnteringBy")) {
            return this.mCaptureUnitOnEnteringByHandler(field, attachment);
        }
        if (fieldName.equals("m_production")) {
            return super.printIntegerOption(field, "production", attachment, true);
        }
        if (fieldName.equals("m_unitProduction")) {
            return this.mUnitProductionHandler(field, attachment);
        }
        if (fieldName.equals("m_originalOwner")) {
            return this.mOriginalOwnerHandler(field, attachment);
        }
        return super.printOption(field, attachment);
    }

    private String mOriginalOwnerHandler(Field field, IAttachment attachment) {
        TerritoryAttachment att = (TerritoryAttachment)attachment;
        PlayerID originalOwner = att.getOriginalOwner();
        Territory t = (Territory)att.getAttachedTo();
        if (originalOwner == null && t.getOwner() != null && !t.getOwner().equals(PlayerID.NULL_PLAYERID)) {
            return this.printDefaultOption("originalOwner", PlayerID.NULL_PLAYERID.getName());
        }
        if (originalOwner == null) {
            return "";
        }
        if (!originalOwner.equals(t.getOwner())) {
            return this.printDefaultOption("originalOwner", originalOwner.getName());
        }
        return "";
    }

    private String mUnitProductionHandler(Field field, IAttachment attachment) throws AttachmentExportException {
        TerritoryAttachment att = (TerritoryAttachment)attachment;
        if (att.getProduction() != att.getUnitProduction()) {
            return this.printIntegerOption(field, "unitProduction", attachment, true);
        }
        return "";
    }

    private String mCaptureUnitOnEnteringByHandler(Field field, IAttachment attachment) throws AttachmentExportException {
        return this.printPlayerList(field, attachment);
    }

    private String mChangeUnitOwnersHandler(Field field, IAttachment attachment) throws AttachmentExportException {
        return this.printPlayerList(field, attachment);
    }
}

