/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data.properties;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameDataComponent;
import games.strategy.engine.data.properties.IEditableProperty;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameProperties
extends GameDataComponent {
    private static final long serialVersionUID = -1448163357090677564L;
    private final Map<String, Object> m_constantProperties = new HashMap<String, Object>();
    private final Map<String, IEditableProperty> m_editableProperties = new HashMap<String, IEditableProperty>();
    private final List<String> m_ordering = new ArrayList<String>();

    public GameProperties(GameData data) {
        super(data);
    }

    public void set(String key, Object value) {
        if (value == null) {
            this.m_constantProperties.remove(key);
            this.m_ordering.remove(key);
        } else {
            this.m_constantProperties.put(key, value);
            this.m_ordering.add(key);
        }
    }

    public Object get(String key) {
        if (this.m_editableProperties.containsKey(key)) {
            return this.m_editableProperties.get(key).getValue();
        }
        return this.m_constantProperties.get(key);
    }

    public boolean get(String key, boolean defaultValue) {
        Object value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (Boolean)value;
    }

    public int get(String key, int defaultValue) {
        Object value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (Integer)value;
    }

    public String get(String key, String defaultValue) {
        Object value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (String)value;
    }

    public Object get(String key, Object defaultValue) {
        Object value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public void addEditableProperty(IEditableProperty property) {
        this.m_editableProperties.put(property.getName(), property);
        this.m_ordering.add(property.getName());
    }

    public List<IEditableProperty> getEditableProperties() {
        ArrayList<IEditableProperty> properties = new ArrayList<IEditableProperty>();
        for (String propertyName : this.m_ordering) {
            if (!this.m_editableProperties.containsKey(propertyName)) continue;
            properties.add(this.m_editableProperties.get(propertyName));
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toOutputStream(OutputStream sink, List<IEditableProperty> editableProperties) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(5000);
        ObjectOutputStream outStream = null;
        GZIPOutputStream zippedOut = null;
        try {
            outStream = new ObjectOutputStream(bos);
            outStream.writeObject(editableProperties);
            zippedOut = new GZIPOutputStream(sink);
            zippedOut.write(bos.toByteArray());
            zippedOut.flush();
        }
        finally {
            try {
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                zippedOut.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IEditableProperty> streamToIEditablePropertiesList(byte[] byteArray) throws IOException, ClassNotFoundException, ClassCastException {
        ByteArrayInputStream byteStream = null;
        InputStream inputStream = null;
        ObjectInputStream objectStream = null;
        List editableProperties = null;
        try {
            byteStream = new ByteArrayInputStream(byteArray);
            inputStream = new BufferedInputStream(byteStream);
            objectStream = new ObjectInputStream(new GZIPInputStream(inputStream));
            editableProperties = (List)objectStream.readObject();
        }
        finally {
            if (byteStream != null) {
                try {
                    byteStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (objectStream != null) {
                try {
                    objectStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return editableProperties;
    }

    public static void applyByteMapToChangeProperties(byte[] byteArray, GameProperties gamePropertiesToBeChanged) {
        List<IEditableProperty> editableProperties = null;
        try {
            editableProperties = GameProperties.streamToIEditablePropertiesList(byteArray);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        GameProperties.applyListToChangeProperties(editableProperties, gamePropertiesToBeChanged);
    }

    public static void applyListToChangeProperties(List<IEditableProperty> editableProperties, GameProperties gamePropertiesToBeChanged) {
        if (editableProperties == null || editableProperties.isEmpty()) {
            return;
        }
        for (IEditableProperty prop : editableProperties) {
            IEditableProperty p;
            if (prop == null || prop.getName() == null || (p = gamePropertiesToBeChanged.m_editableProperties.get(prop.getName())) == null || !prop.getName().equals(p.getName()) || !p.validate(prop.getValue())) continue;
            p.setValue(prop.getValue());
        }
    }
}

