/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data.properties;

import games.strategy.engine.data.properties.AEditableProperty;
import games.strategy.engine.data.properties.BooleanProperty;
import games.strategy.engine.data.properties.CollectionProperty;
import games.strategy.engine.data.properties.ColorProperty;
import games.strategy.engine.data.properties.DoubleProperty;
import games.strategy.engine.data.properties.FileProperty;
import games.strategy.engine.data.properties.IEditableProperty;
import games.strategy.engine.data.properties.NumberProperty;
import games.strategy.engine.data.properties.PropertiesUI;
import games.strategy.engine.data.properties.StringProperty;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapProperty<T, U>
extends AEditableProperty {
    private static final long serialVersionUID = -8021039503574228146L;
    private Map<T, U> m_map;
    final List<IEditableProperty> m_properties = new ArrayList<IEditableProperty>();

    public MapProperty(String name, String description, Map<T, U> map) {
        super(name, description);
        this.m_map = map;
        this.resetProperties(map, this.m_properties, name, description);
    }

    private void resetProperties(Map<T, U> map, List<IEditableProperty> properties, String name, String description) {
        properties.clear();
        for (Map.Entry<T, U> entry : map.entrySet()) {
            String key = (String)entry.getKey();
            U value = entry.getValue();
            if (value instanceof Boolean) {
                properties.add(new BooleanProperty(key, description, (Boolean)value));
                continue;
            }
            if (value instanceof Color) {
                properties.add(new ColorProperty(key, description, (Color)value));
                continue;
            }
            if (value instanceof File) {
                properties.add(new FileProperty(key, description, (File)value));
                continue;
            }
            if (value instanceof String) {
                properties.add(new StringProperty(key, description, (String)value));
                continue;
            }
            if (value instanceof Collection || value instanceof List || value instanceof Set) {
                properties.add(new CollectionProperty(name, description, (Collection)value));
                continue;
            }
            if (value instanceof Integer) {
                properties.add(new NumberProperty(key, description, Integer.MAX_VALUE, Integer.MIN_VALUE, (Integer)value));
                continue;
            }
            if (value instanceof Double) {
                properties.add(new DoubleProperty(key, description, Double.MAX_VALUE, Double.MIN_VALUE, (Double)value, 5));
                continue;
            }
            throw new IllegalArgumentException("Can not instantiate MapProperty with: " + value.getClass().getCanonicalName());
        }
    }

    @Override
    public int getRowsNeeded() {
        return Math.max(1, this.m_properties.size());
    }

    @Override
    public Object getValue() {
        return this.m_map;
    }

    public Map<T, U> getValueT() {
        return this.m_map;
    }

    @Override
    public void setValue(Object value) throws ClassCastException {
        this.m_map = (Map)value;
        this.resetProperties(this.m_map, this.m_properties, this.getName(), this.getDescription());
    }

    public void setValueT(Map<T, U> value) {
        this.m_map = value;
        this.resetProperties(this.m_map, this.m_properties, this.getName(), this.getDescription());
    }

    @Override
    public JComponent getEditorComponent() {
        PropertiesUI ui = new PropertiesUI(this.m_properties, true);
        return ui;
    }

    @Override
    public JComponent getViewComponent() {
        PropertiesUI ui = new PropertiesUI(this.m_properties, false);
        return ui;
    }

    @Override
    public boolean validate(Object value) {
        if (value == null) {
            return false;
        }
        if (Map.class.isAssignableFrom(value.getClass())) {
            try {
                Map test = (Map)value;
                if (this.m_map != null && !this.m_map.isEmpty() && test != null && !test.isEmpty()) {
                    Object key = null;
                    Object val = null;
                    for (Map.Entry<T, U> entry : this.m_map.entrySet()) {
                        if (entry.getValue() == null || entry.getKey() == null) continue;
                        key = entry.getKey();
                        val = entry.getValue();
                        break;
                    }
                    if (key != null && val != null) {
                        for (Map.Entry<Object, Object> entry : test.entrySet()) {
                            if (entry.getKey() == null || entry.getValue() == null || entry.getKey().getClass().isAssignableFrom(key.getClass()) && entry.getValue().getClass().isAssignableFrom(val.getClass())) continue;
                            return false;
                        }
                    }
                }
                ArrayList<IEditableProperty> testProps = new ArrayList<IEditableProperty>();
                this.resetProperties(test, testProps, this.getName(), this.getDescription());
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        return false;
    }
}

