/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.delegate;

import games.strategy.engine.GameOverException;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.delegate.DelegateExecutionManager;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.display.IDisplay;
import games.strategy.engine.framework.IGame;
import games.strategy.engine.framework.ServerGame;
import games.strategy.engine.gamePlayer.IRemotePlayer;
import games.strategy.engine.history.IDelegateHistoryWriter;
import games.strategy.engine.message.IChannelSubscribor;
import games.strategy.engine.message.IRemote;
import games.strategy.engine.message.MessengerException;
import games.strategy.engine.random.IRandomSource;
import games.strategy.engine.random.IRandomStats;
import games.strategy.engine.random.RandomStats;
import games.strategy.sound.ISound;
import java.util.Properties;

public class DefaultDelegateBridge
implements IDelegateBridge {
    private final GameData m_data;
    private final IGame m_game;
    private final IDelegateHistoryWriter m_historyWriter;
    private final RandomStats m_randomStats;
    private final DelegateExecutionManager m_delegateExecutionManager;
    private IRandomSource m_randomSource;

    public DefaultDelegateBridge(GameData data, IGame game, IDelegateHistoryWriter historyWriter, RandomStats randomStats, DelegateExecutionManager delegateExecutionManager) {
        this.m_data = data;
        this.m_game = game;
        this.m_historyWriter = historyWriter;
        this.m_randomStats = randomStats;
        this.m_delegateExecutionManager = delegateExecutionManager;
    }

    public GameData getData() {
        return this.m_data;
    }

    public PlayerID getPlayerID() {
        return this.m_data.getSequence().getStep().getPlayerID();
    }

    public void setRandomSource(IRandomSource randomSource) {
        this.m_randomSource = randomSource;
    }

    public int getRandom(int max, PlayerID player, IRandomStats.DiceType diceType, String annotation) {
        int random = this.m_randomSource.getRandom(max, annotation);
        this.m_randomStats.addRandom(random, player, diceType);
        return random;
    }

    public int[] getRandom(int max, int count, PlayerID player, IRandomStats.DiceType diceType, String annotation) {
        int[] rVal = this.m_randomSource.getRandom(max, count, annotation);
        this.m_randomStats.addRandom(rVal, player, diceType);
        return rVal;
    }

    public void addChange(Change aChange) {
        CompositeChange c;
        if (aChange instanceof CompositeChange && (c = (CompositeChange)aChange).getChanges().size() == 1) {
            this.addChange(c.getChanges().get(0));
            return;
        }
        if (!aChange.isEmpty()) {
            this.m_game.addChange(aChange);
        }
    }

    public String getStepName() {
        return this.m_data.getSequence().getStep().getName();
    }

    public IDelegateHistoryWriter getHistoryWriter() {
        return this.m_historyWriter;
    }

    private Object getOutbound(Object o) {
        Class<?>[] interfaces = o.getClass().getInterfaces();
        return this.m_delegateExecutionManager.createOutboundImplementation(o, interfaces);
    }

    public IRemotePlayer getRemotePlayer() {
        return this.getRemotePlayer(this.getPlayerID());
    }

    public IRemotePlayer getRemotePlayer(PlayerID id) {
        try {
            IRemote implementor = this.m_game.getRemoteMessenger().getRemote(ServerGame.getRemoteName(id, this.m_data));
            return (IRemotePlayer)this.getOutbound(implementor);
        }
        catch (MessengerException me) {
            throw new GameOverException("Game Over!");
        }
    }

    public IDisplay getDisplayChannelBroadcaster() {
        IChannelSubscribor implementor = this.m_game.getChannelMessenger().getChannelBroadcastor(ServerGame.getDisplayChannel(this.m_data));
        return (IDisplay)this.getOutbound(implementor);
    }

    public ISound getSoundChannelBroadcaster() {
        IChannelSubscribor implementor = this.m_game.getChannelMessenger().getChannelBroadcastor(ServerGame.getSoundChannel(this.m_data));
        return (ISound)this.getOutbound(implementor);
    }

    public Properties getStepProperties() {
        return this.m_data.getSequence().getStep().getProperties();
    }

    public void leaveDelegateExecution() {
        this.m_delegateExecutionManager.leaveDelegateExecution();
    }

    public void enterDelegateExecution() {
        this.m_delegateExecutionManager.enterDelegateExecution();
    }

    public void stopGameSequence() {
        ((ServerGame)this.m_game).stopGameSequence();
    }
}

