/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework;

import games.strategy.engine.data.ChangePerformer;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.PlayerList;
import games.strategy.engine.data.PlayerManager;
import games.strategy.engine.data.events.GameStepListener;
import games.strategy.engine.display.DefaultDisplayBridge;
import games.strategy.engine.display.IDisplay;
import games.strategy.engine.framework.IGame;
import games.strategy.engine.framework.IGameModifiedChannel;
import games.strategy.engine.framework.ServerGame;
import games.strategy.engine.gamePlayer.DefaultPlayerBridge;
import games.strategy.engine.gamePlayer.IGamePlayer;
import games.strategy.engine.message.IChannelMessenger;
import games.strategy.engine.message.IRemoteMessenger;
import games.strategy.engine.message.RemoteName;
import games.strategy.engine.vault.Vault;
import games.strategy.net.IMessenger;
import games.strategy.net.INode;
import games.strategy.net.Messengers;
import games.strategy.sound.ISound;
import games.strategy.util.ListenerList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGame
implements IGame {
    protected static final String DISPLAY_CHANNEL = "games.strategy.engine.framework.AbstractGame.DISPLAY_CHANNEL";
    protected static final String SOUND_CHANNEL = "games.strategy.engine.framework.AbstractGame.SOUND_CHANNEL";
    protected final GameData m_data;
    protected final IMessenger m_messenger;
    protected final IRemoteMessenger m_remoteMessenger;
    protected final IChannelMessenger m_channelMessenger;
    protected final ChangePerformer m_changePerformer;
    protected final Map<PlayerID, IGamePlayer> m_gamePlayers = new HashMap<PlayerID, IGamePlayer>();
    protected volatile boolean m_isGameOver = false;
    protected final Vault m_vault;
    protected IGameModifiedChannel m_gameModifiedChannel;
    protected final PlayerManager m_playerManager;
    protected boolean m_firstRun = true;
    protected final ListenerList<GameStepListener> m_gameStepListeners = new ListenerList();

    public AbstractGame(GameData data, Set<IGamePlayer> gamePlayers, Map<String, INode> remotePlayerMapping, Messengers messengers) {
        this.m_data = data;
        this.m_messenger = messengers.getMessenger();
        this.m_remoteMessenger = messengers.getRemoteMessenger();
        this.m_channelMessenger = messengers.getChannelMessenger();
        this.m_changePerformer = new ChangePerformer(this.m_data);
        this.m_vault = new Vault(this.m_channelMessenger);
        HashMap<String, INode> allPlayers = new HashMap<String, INode>(remotePlayerMapping);
        for (IGamePlayer player : gamePlayers) {
            allPlayers.put(player.getName(), this.m_messenger.getLocalNode());
        }
        this.m_playerManager = new PlayerManager(allPlayers);
        if (this.m_playerManager == null) {
            throw new IllegalArgumentException("Player manager cant be null");
        }
        this.setupLocalPlayers(gamePlayers);
    }

    private final void setupLocalPlayers(Set<IGamePlayer> localPlayers) {
        PlayerList playerList = this.m_data.getPlayerList();
        for (IGamePlayer gp : localPlayers) {
            PlayerID player = playerList.getPlayerID(gp.getName());
            this.m_gamePlayers.put(player, gp);
            DefaultPlayerBridge bridge = new DefaultPlayerBridge(this);
            gp.initialize(bridge, player);
            RemoteName descriptor = ServerGame.getRemoteName(gp.getPlayerID(), this.m_data);
            this.m_remoteMessenger.registerRemote(gp, descriptor);
        }
    }

    protected void notifyGameStepListeners(String stepName, String delegateName, PlayerID player, int round, String displayName) {
        for (GameStepListener listener : this.m_gameStepListeners) {
            listener.gameStepChanged(stepName, delegateName, player, round, displayName);
        }
    }

    @Override
    public GameData getData() {
        return this.m_data;
    }

    @Override
    public Vault getVault() {
        return this.m_vault;
    }

    @Override
    public boolean isGameOver() {
        return this.m_isGameOver;
    }

    @Override
    public IRemoteMessenger getRemoteMessenger() {
        return this.m_remoteMessenger;
    }

    @Override
    public IChannelMessenger getChannelMessenger() {
        return this.m_channelMessenger;
    }

    @Override
    public IMessenger getMessenger() {
        return this.m_messenger;
    }

    @Override
    public PlayerManager getPlayerManager() {
        return this.m_playerManager;
    }

    @Override
    public void addGameStepListener(GameStepListener listener) {
        this.m_gameStepListeners.add(listener);
    }

    @Override
    public void removeGameStepListener(GameStepListener listener) {
        this.m_gameStepListeners.remove(listener);
    }

    public static RemoteName getDisplayChannel(GameData data) {
        return new RemoteName(DISPLAY_CHANNEL, data.getGameLoader().getDisplayType());
    }

    @Override
    public void addDisplay(IDisplay display) {
        display.initialize(new DefaultDisplayBridge(this.m_data));
        this.m_channelMessenger.registerChannelSubscriber(display, AbstractGame.getDisplayChannel(this.getData()));
    }

    @Override
    public void removeDisplay(IDisplay display) {
        this.m_channelMessenger.unregisterChannelSubscriber(display, AbstractGame.getDisplayChannel(this.getData()));
    }

    public static RemoteName getSoundChannel(GameData data) {
        return new RemoteName(SOUND_CHANNEL, data.getGameLoader().getSoundType());
    }

    @Override
    public void addSoundChannel(ISound soundChannel) {
        soundChannel.initialize();
        this.m_channelMessenger.registerChannelSubscriber(soundChannel, AbstractGame.getSoundChannel(this.getData()));
    }

    @Override
    public void removeSoundChannel(ISound soundChannel) {
        this.m_channelMessenger.unregisterChannelSubscriber(soundChannel, AbstractGame.getSoundChannel(this.getData()));
    }
}

