/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework;

import games.strategy.engine.EngineVersion;
import games.strategy.engine.framework.GameRunner2;
import games.strategy.net.DesktopUtilityBrowserLauncher;
import games.strategy.util.Version;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.GetMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EngineVersionProperties {
    private final Version m_latestVersionOut;
    private final Version m_showUpdatesFrom;
    private final Map<Version, String> m_releaseNotes;
    private final String m_link;
    private final String m_linkAlt;
    private final String m_changelogLink;
    private volatile boolean m_done = false;
    private static final String s_linkToTripleA = "http://triplea.sourceforge.net/latest/latest_version.properties";

    private EngineVersionProperties(URL url) {
        this(EngineVersionProperties.getProperties(url));
    }

    private EngineVersionProperties(Properties props) {
        this.m_latestVersionOut = new Version(props.getProperty("LATEST", EngineVersion.VERSION.toStringFull(".")));
        Version showUpdatesFromTemp = new Version(props.getProperty("SHOW_FROM", EngineVersion.VERSION.toStringFull(".")));
        this.m_showUpdatesFrom = EngineVersion.VERSION.isLessThan(showUpdatesFromTemp, false) ? EngineVersion.VERSION : showUpdatesFromTemp;
        this.m_link = props.getProperty("LINK", "http://triplea.sourceforge.net/");
        this.m_linkAlt = props.getProperty("LINK_ALT", "http://sourceforge.net/projects/tripleamaps/files/TripleA/stable/");
        this.m_changelogLink = props.getProperty("CHANGELOG", "https://triplea.svn.sourceforge.net/svnroot/triplea/trunk/triplea/changelog.txt");
        this.m_releaseNotes = new HashMap<Version, String>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            if (key == null || key.length() <= 6 || !key.startsWith("NOTES_")) continue;
            Version version = new Version(key.substring(6));
            String value = (String)entry.getValue();
            if (value == null || value.trim().length() <= 0) continue;
            this.m_releaseNotes.put(version, value);
        }
        this.m_done = true;
    }

    public static EngineVersionProperties contactServerForEngineVersionProperties() {
        URL engineversionPropsURL;
        try {
            engineversionPropsURL = new URL(s_linkToTripleA);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return new EngineVersionProperties(new Properties());
        }
        return EngineVersionProperties.contactServerForEngineVersionProperties(engineversionPropsURL);
    }

    private static EngineVersionProperties contactServerForEngineVersionProperties(final URL engineversionPropsURL) {
        final AtomicReference ref = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 5; ++i) {
                    this.spawnRequest(engineversionPropsURL, ref, latch);
                    try {
                        latch.await(2L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (ref.get() != null) break;
                }
                try {
                    latch.await(15L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }

            private void spawnRequest(final URL engineversionPropsURL2, final AtomicReference<EngineVersionProperties> ref2, final CountDownLatch latch2) {
                Thread t1 = new Thread(new Runnable(){

                    public void run() {
                        ref2.set(new EngineVersionProperties(engineversionPropsURL2));
                        latch2.countDown();
                    }
                });
                t1.start();
            }
        };
        EngineVersionProperties.runInBackground(null, "Checking for Latest Version", r);
        EngineVersionProperties props = (EngineVersionProperties)ref.get();
        return props;
    }

    private static void runInBackground(Component parent, String waitMessage, Runnable r) {
        r.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getProperties(URL url) {
        Logger.getLogger("org.apache.commons.httpclient").setLevel(Level.SEVERE);
        Properties props = new Properties();
        HttpClient client = new HttpClient();
        HostConfiguration config = client.getHostConfiguration();
        config.setHost(url.getHost());
        GameRunner2.addProxy(config);
        GetMethod method = new GetMethod(url.getPath());
        method.setRequestHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)");
        try {
            client.executeMethod(method);
            String propsString = method.getResponseBodyAsString();
            props.load(new ByteArrayInputStream(propsString.getBytes()));
        }
        catch (Exception ioe) {
        }
        finally {
            method.releaseConnection();
        }
        Logger.getLogger("org.apache.commons.httpclient").setLevel(Level.INFO);
        return props;
    }

    public boolean isDone() {
        return this.m_done;
    }

    public Version getLatestVersionOut() {
        return this.m_latestVersionOut;
    }

    public Version getShowUpdatesFrom() {
        return this.m_showUpdatesFrom;
    }

    public String getLinkToDownloadLatestVersion() {
        return this.m_link;
    }

    public String getLinkAltToDownloadLatestVersion() {
        return this.m_linkAlt;
    }

    public String getChangeLogLink() {
        return this.m_changelogLink;
    }

    public Map<Version, String> getReleaseNotes() {
        return this.m_releaseNotes;
    }

    private String getOutOfDateMessage() {
        StringBuilder text = new StringBuilder("<html>");
        text.append("<h2>A new version of TripleA is out.  Please Update TripleA!</h2>");
        text.append("<br />Your current version: " + EngineVersion.VERSION);
        text.append("<br />Latest version available for download: " + this.getLatestVersionOut());
        text.append("<br /><br />Click to download: <a class=\"external\" href=\"" + this.getLinkToDownloadLatestVersion() + "\">" + this.getLinkToDownloadLatestVersion() + "</a>");
        text.append("<br />Backup Mirror: <a class=\"external\" href=\"" + this.getLinkAltToDownloadLatestVersion() + "\">" + this.getLinkAltToDownloadLatestVersion() + "</a>");
        text.append("<br /><br />Please note that installing a new version of TripleA will not remove any old copies of TripleA.<br />So be sure to either manually uninstall all older versions of TripleA, or change your shortcuts to the new TripleA.");
        text.append("<br /><br />What is new:<br />");
        text.append("</html>");
        return text.toString();
    }

    private String getOutOfDateReleaseUpdates(boolean showAll) {
        StringBuilder text = new StringBuilder("<html>");
        ArrayList<Version> versions = new ArrayList<Version>();
        versions.addAll(this.getReleaseNotes().keySet());
        Collections.sort(versions, Version.getHighestToLowestComparator(false));
        for (Version v : versions) {
            if (!showAll && !EngineVersion.VERSION.isLessThan(v, false)) continue;
            text.append("<br />" + this.getReleaseNotes().get(v) + "<br /><br />");
        }
        text.append("Link to full Change Log:<br /><a class=\"external\" href=\"" + this.getChangeLogLink() + "\">" + this.getChangeLogLink() + "</a><br />");
        text.append("</html>");
        return text.toString();
    }

    public Component getCurrentFeaturesComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        JEditorPane intro = new JEditorPane("text/html", "<html><h2>What is new in version " + EngineVersion.VERSION + "</h2><br />" + "Please visit our forum to get involved: " + "<a class=\"external\" href=\"http://triplea.sourceforge.net/mywiki/Forum\">http://triplea.sourceforge.net/mywiki/Forum</a><br /><br /></html>");
        intro.setEditable(false);
        intro.setOpaque(false);
        intro.setBorder(BorderFactory.createEmptyBorder());
        HyperlinkListener hyperlinkListener = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                    DesktopUtilityBrowserLauncher.openURL(e.getDescription());
                }
            }
        };
        intro.addHyperlinkListener(hyperlinkListener);
        panel.add((Component)intro, "North");
        StringBuilder releaseNotesBuilder = new StringBuilder("<html>");
        ArrayList<Version> versions = new ArrayList<Version>();
        versions.addAll(this.getReleaseNotes().keySet());
        Collections.sort(versions, Version.getHighestToLowestComparator(false));
        for (Version v : versions) {
            if (!this.getShowUpdatesFrom().equals(v, false) && !this.getShowUpdatesFrom().isLessThan(v, false)) continue;
            releaseNotesBuilder.append("<br />" + this.getReleaseNotes().get(v) + "<br /><br />");
        }
        releaseNotesBuilder.append("Link to full Change Log:<br /><a class=\"external\" href=\"" + this.getChangeLogLink() + "\">" + this.getChangeLogLink() + "</a><br />");
        releaseNotesBuilder.append("</html>");
        JEditorPane updates = new JEditorPane("text/html", releaseNotesBuilder.toString());
        updates.setEditable(false);
        updates.setOpaque(false);
        updates.setBorder(BorderFactory.createEmptyBorder());
        updates.addHyperlinkListener(hyperlinkListener);
        updates.setCaretPosition(0);
        JScrollPane scroll = new JScrollPane(updates);
        panel.add((Component)scroll, "Center");
        Dimension maxDimension = panel.getPreferredSize();
        maxDimension.width = Math.min(maxDimension.width, 700);
        maxDimension.height = Math.min(maxDimension.height, 480);
        panel.setMaximumSize(maxDimension);
        panel.setPreferredSize(maxDimension);
        return panel;
    }

    public Component getOutOfDateComponent(boolean showAll) {
        JPanel panel = new JPanel(new BorderLayout());
        JEditorPane intro = new JEditorPane("text/html", this.getOutOfDateMessage());
        intro.setEditable(false);
        intro.setOpaque(false);
        intro.setBorder(BorderFactory.createEmptyBorder());
        HyperlinkListener hyperlinkListener = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                    DesktopUtilityBrowserLauncher.openURL(e.getDescription());
                }
            }
        };
        intro.addHyperlinkListener(hyperlinkListener);
        panel.add((Component)intro, "North");
        JEditorPane updates = new JEditorPane("text/html", this.getOutOfDateReleaseUpdates(showAll));
        updates.setEditable(false);
        updates.setOpaque(false);
        updates.setBorder(BorderFactory.createEmptyBorder());
        updates.addHyperlinkListener(hyperlinkListener);
        updates.setCaretPosition(0);
        JScrollPane scroll = new JScrollPane(updates);
        panel.add((Component)scroll, "Center");
        Dimension maxDimension = panel.getPreferredSize();
        maxDimension.width = Math.min(maxDimension.width, 700);
        maxDimension.height = Math.min(maxDimension.height, 480);
        panel.setMaximumSize(maxDimension);
        panel.setPreferredSize(maxDimension);
        return panel;
    }

    public static void main(String[] args) throws Exception {
        URL url = new URL(s_linkToTripleA);
        EngineVersionProperties props = new EngineVersionProperties(url);
        System.out.println(props.getLatestVersionOut());
        System.out.println(props.getLinkToDownloadLatestVersion());
        System.out.println(props.getReleaseNotes());
    }
}

