/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework;

import games.strategy.engine.EngineVersion;
import games.strategy.engine.data.GameData;
import games.strategy.engine.delegate.IDelegate;
import games.strategy.engine.framework.GameRunner2;
import games.strategy.engine.framework.HeadlessGameServer;
import games.strategy.engine.framework.TripleAProcessRunner;
import games.strategy.util.Version;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class GameDataManager {
    private static final String DELEGATE_START = "<DelegateStart>";
    private static final String DELEGATE_DATA_NEXT = "<DelegateData>";
    private static final String DELEGATE_LIST_END = "<EndDelegateList>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GameData loadGame(File savedGameFile) throws IOException {
        InputStream input = null;
        try {
            String path;
            input = new BufferedInputStream(new FileInputStream(savedGameFile));
            try {
                path = savedGameFile.getCanonicalPath();
            }
            catch (IOException e) {
                path = savedGameFile.getPath();
            }
            GameData gameData = this.loadGame(input, path);
            return gameData;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public GameData loadGame(InputStream input, String path) throws IOException {
        return this.loadGame(new ObjectInputStream(new GZIPInputStream(input)), path);
    }

    public GameData loadGame(ObjectInputStream input, String savegamePath) throws IOException {
        try {
            String messageString;
            int answer;
            Version readVersion = (Version)input.readObject();
            boolean headless = HeadlessGameServer.headless();
            if (!readVersion.equals(EngineVersion.VERSION, true)) {
                block12: {
                    if (headless) {
                        System.out.println("Incompatible game save, we are: " + EngineVersion.VERSION + "  Trying to load game created with: " + readVersion);
                        return null;
                    }
                    String error = "<html>Incompatible engine versions, and no old engine found. We are: " + EngineVersion.VERSION + " . Trying to load game created with: " + readVersion + "<br>To download the latest version of TripleA, Please visit http://triplea.sourceforge.net/</html>";
                    if (savegamePath == null) {
                        throw new IOException(error);
                    }
                    try {
                        String newClassPath = TripleAProcessRunner.findOldJar(readVersion, true);
                        String messageString2 = "<html>This TripleA engine is version " + EngineVersion.VERSION.toString() + " and you are trying to open a savegame made with version " + readVersion.toString() + "<br>However, this TripleA can not open any savegame made by any engine other than engines with the same first three version numbers as it (x_x_x_x)." + "<br><br>TripleA now comes with older engines included with it, and has found the engine to run this savegame. This is a new feature and is in 'beta' stage." + "<br>It will attempt to run a new instance of TripleA using the older engine jar file, and this instance will only be able to play this savegame." + "<br><b>You may choose to either Close or Keep the current instance of TripleA!</b> (If hosting, you must close it). Please report any bugs or issues." + "<br><br>Do you wish to continue?</html>";
                        String yesClose = "Yes & Close Current";
                        String yesOpen = "Yes & Do Not Close";
                        String cancel = "Cancel";
                        Object[] options = new Object[]{"Yes & Close Current", "Yes & Do Not Close", "Cancel"};
                        JOptionPane pane = new JOptionPane(messageString2, -1, 1, null, options, "Yes & Close Current");
                        JDialog window = pane.createDialog(null, "Run old jar to open old Save Game?");
                        window.setVisible(true);
                        Object buttonPressed = pane.getValue();
                        if (buttonPressed == null || buttonPressed.equals("Cancel")) {
                            return null;
                        }
                        boolean closeCurrentInstance = buttonPressed.equals("Yes & Close Current");
                        TripleAProcessRunner.startGame(savegamePath, newClassPath, null);
                        if (!closeCurrentInstance) break block12;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        System.exit(0);
                    }
                    catch (IOException e) {
                        if (GameRunner2.areWeOldExtraJar()) {
                            throw new IOException("<html>Please run the default TripleA and try to open this game again. <br>This TripleA engine is old and kept only for backwards compatibility and can only open savegames created by engines with these first 3 version digits: " + EngineVersion.VERSION.toStringFull("_", true) + "</html>");
                        }
                        throw new IOException(error);
                    }
                }
                return null;
            }
            if (!headless && readVersion.isGreaterThan(EngineVersion.VERSION, false) && (answer = JOptionPane.showConfirmDialog(null, messageString = "<html>Your TripleA engine is OUT OF DATE.  This save was made by a newer version of TripleA.<br>However, because the first 3 version numbers are the same as your current version, we can still open the savegame.<br><br>This TripleA engine is version " + EngineVersion.VERSION.toStringFull("_") + " and you are trying to open a savegame made with version " + readVersion.toStringFull("_") + "<br><br>To download the latest version of TripleA, Please visit http://triplea.sourceforge.net/" + "<br><br>It is recommended that you upgrade to the latest version of TripleA before playing this savegame." + "<br><br>Do you wish to continue and open this save with your current 'old' version?</html>", "Open Newer Save Game?", 0)) != 0) {
                return null;
            }
            GameData data = (GameData)input.readObject();
            this.updateDataToBeCompatibleWithNewEngine(readVersion, data);
            this.loadDelegates(input, data);
            data.postDeSerialize();
            return data;
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe.getMessage());
        }
    }

    private void updateDataToBeCompatibleWithNewEngine(Version originalEngineVersion, GameData data) {
    }

    private void loadDelegates(ObjectInputStream input, GameData data) throws ClassNotFoundException, IOException {
        Object endMarker = input.readObject();
        while (!endMarker.equals(DELEGATE_LIST_END)) {
            IDelegate instance;
            String name = (String)input.readObject();
            String displayName = (String)input.readObject();
            String className = (String)input.readObject();
            try {
                instance = (IDelegate)Class.forName(className).newInstance();
                instance.initialize(name, displayName);
                data.getDelegateList().addDelegate(instance);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            String next = (String)input.readObject();
            if (next.equals(DELEGATE_DATA_NEXT)) {
                instance.loadState((Serializable)input.readObject());
            }
            endMarker = input.readObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveGame(File destination, GameData data) throws IOException {
        FilterOutputStream out = null;
        try {
            FileOutputStream fileStream = new FileOutputStream(destination);
            out = new BufferedOutputStream(fileStream);
            this.saveGame(fileStream, data);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void saveGame(OutputStream sink, GameData data) throws IOException {
        this.saveGame(sink, data, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveGame(OutputStream sink, GameData data, boolean saveDelegateInfo) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(25000);
        ObjectOutputStream outStream = new ObjectOutputStream(bytes);
        outStream.writeObject(EngineVersion.VERSION);
        data.acquireReadLock();
        try {
            outStream.writeObject(data);
            if (saveDelegateInfo) {
                this.writeDelegates(data, outStream);
            } else {
                outStream.writeObject(DELEGATE_LIST_END);
            }
        }
        finally {
            data.releaseReadLock();
        }
        GZIPOutputStream zippedOut = new GZIPOutputStream(sink);
        zippedOut.write(bytes.toByteArray());
        zippedOut.flush();
        zippedOut.close();
    }

    private void writeDelegates(GameData data, ObjectOutputStream out) throws IOException {
        Iterator<IDelegate> iter = data.getDelegateList().iterator();
        while (iter.hasNext()) {
            out.writeObject(DELEGATE_START);
            IDelegate delegate = iter.next();
            out.writeObject(delegate.getName());
            out.writeObject(delegate.getDisplayName());
            out.writeObject(delegate.getClass().getName());
            out.writeObject(DELEGATE_DATA_NEXT);
            out.writeObject(delegate.saveState());
        }
        out.writeObject(DELEGATE_LIST_END);
    }
}

