/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework;

import games.strategy.common.ui.BasicGameMenuBar;
import games.strategy.debug.Console;
import games.strategy.engine.EngineVersion;
import games.strategy.engine.framework.EngineVersionProperties;
import games.strategy.engine.framework.GameRunner;
import games.strategy.engine.framework.TripleAProcessRunner;
import games.strategy.engine.framework.mapDownload.DownloadFileDescription;
import games.strategy.engine.framework.mapDownload.DownloadMapDialog;
import games.strategy.engine.framework.mapDownload.DownloadRunnable;
import games.strategy.engine.framework.mapDownload.InstallMapDialog;
import games.strategy.engine.framework.startup.ui.MainFrame;
import games.strategy.engine.framework.ui.background.BackgroundTaskRunner;
import games.strategy.engine.framework.ui.background.WaitWindow;
import games.strategy.triplea.ui.ErrorHandler;
import games.strategy.util.CountDownLatchHandler;
import games.strategy.util.EventThreadJOptionPane;
import games.strategy.util.Version;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.logging.LogManager;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.httpclient.HostConfiguration;

public class GameRunner2 {
    public static final int PORT = 3300;
    public static final String LOOK_AND_FEEL_PREF = "LookAndFeel";
    public static final String DELAYED_PARSING = "DelayedParsing";
    public static final String PROXY_CHOICE = "proxy.choice";
    public static final String HTTP_PROXYHOST = "http.proxyHost";
    public static final String HTTP_PROXYPORT = "http.proxyPort";
    public static final String OLD_EXTENSION = ".old";
    public static final String TRIPLEA_GAME_PROPERTY = "triplea.game";
    public static final String TRIPLEA_SERVER_PROPERTY = "triplea.server";
    public static final String TRIPLEA_CLIENT_PROPERTY = "triplea.client";
    public static final String TRIPLEA_HOST_PROPERTY = "triplea.host";
    public static final String TRIPLEA_PORT_PROPERTY = "triplea.port";
    public static final String TRIPLEA_NAME_PROPERTY = "triplea.name";
    public static final String TRIPLEA_SERVER_PASSWORD_PROPERTY = "triplea.server.password";
    public static final String TRIPLEA_STARTED = "triplea.started";
    public static final String LOBBY_PORT = "triplea.lobby.port";
    public static final String LOBBY_HOST = "triplea.lobby.host";
    public static final String LOBBY_GAME_COMMENTS = "triplea.lobby.game.comments";
    public static final String LOBBY_GAME_HOSTED_BY = "triplea.lobby.game.hostedBy";
    public static final String LOBBY_GAME_SUPPORT_EMAIL = "triplea.lobby.game.supportEmail";
    public static final String TRIPLEA_ENGINE_VERSION_BIN = "triplea.engine.version.bin";
    public static final String PROXY_HOST = "proxy.host";
    public static final String PROXY_PORT = "proxy.port";
    public static final String TRIPLEA_DO_NOT_CHECK_FOR_UPDATES = "triplea.doNotCheckForUpdates";
    public static final String TRIPLEA_MEMORY_SET = "triplea.memory.set";
    private static final String TRIPLEA_FIRST_TIME_THIS_VERSION_PROPERTY = "triplea.firstTimeThisVersion" + EngineVersion.VERSION.toString();
    private static final String TRIPLEA_LAST_CHECK_FOR_ENGINE_UPDATE = "triplea.lastCheckForEngineUpdate";
    private static final String TRIPLEA_LAST_CHECK_FOR_MAP_UPDATES = "triplea.lastCheckForMapUpdates";
    public static final String TRIPLEA_MEMORY_ONLINE_ONLY = "triplea.memory.onlineOnly";
    public static final String TRIPLEA_MEMORY_XMX = "triplea.memory.Xmx";
    public static final String TRIPLEA_MEMORY_USE_DEFAULT = "triplea.memory.useDefault";
    public static final String SYSTEM_INI = "system.ini";
    private static WaitWindow s_waitWindow;
    private static CountDownLatch s_countDownLatch;

    public static String[] getProperties() {
        return new String[]{TRIPLEA_GAME_PROPERTY, TRIPLEA_SERVER_PROPERTY, TRIPLEA_CLIENT_PROPERTY, TRIPLEA_HOST_PROPERTY, TRIPLEA_PORT_PROPERTY, TRIPLEA_NAME_PROPERTY, TRIPLEA_SERVER_PASSWORD_PROPERTY, TRIPLEA_STARTED, LOBBY_PORT, LOBBY_HOST, LOBBY_GAME_COMMENTS, LOBBY_GAME_HOSTED_BY, TRIPLEA_ENGINE_VERSION_BIN, PROXY_HOST, PROXY_PORT, TRIPLEA_DO_NOT_CHECK_FOR_UPDATES, TRIPLEA_MEMORY_SET};
    }

    private static void usage() {
        System.out.println("Arguments\n   triplea.game=<FILE_NAME>\n   triplea.server=true\n   triplea.client=true\n   triplea.host=<HOST_IP>\n   triplea.port=<PORT>\n   triplea.name=<PLAYER_NAME>\n   triplea.lobby.port=<LOBBY_PORT>\n   triplea.lobby.host=<LOBBY_HOST>\n   triplea.lobby.game.comments=<LOBBY_GAME_COMMENTS>\n   triplea.lobby.game.hostedBy=<LOBBY_GAME_HOSTED_BY>\n   proxy.host=<Proxy_Host>\n   proxy.port=<Proxy_Port>\n   triplea.memory.set=true/false <did you set the xmx manually?>\n\nif there is only one argument, and it does not start with triplea.game, the argument will be \ntaken as the name of the file to load.\n\nExample\n   to start a game using the given file:\n\n   triplea /home/sgb/games/test.xml\n\n   or\n\n   triplea triplea.game=/home/sgb/games/test.xml\n\n   to connect to a remote host:\n\n   triplea triplea.client=true triplea.host=127.0.0.0 triplea.port=3300 triplea.name=Paul\n\n   to start a server with the given game\n\n   triplea triplea.game=/home/sgb/games/test.xml triplea.server=true triplea.port=3300 triplea.name=Allan\n   to start a server, you can optionally password protect the game using triplea.server.password=foo");
    }

    public static void main(String[] args) {
        GameRunner2.setupLogging();
        Console.getConsole().displayStandardError();
        Console.getConsole().displayStandardOutput();
        System.setProperty("sun.awt.exception.handler", ErrorHandler.class.getName());
        System.setProperty("triplea.engine.version", EngineVersion.VERSION.toString());
        GameRunner2.handleCommandLineArgs(args);
        GameRunner2.checkForMemoryXMX();
        GameRunner2.setupLookAndFeel();
        s_countDownLatch = new CountDownLatch(1);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    s_waitWindow = new WaitWindow("TripleA is starting...");
                    s_waitWindow.setVisible(true);
                    s_waitWindow.showWait();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        GameRunner2.setupProxies();
        GameRunner2.showMainFrame();
        GameRunner2.checkForUpdates();
    }

    private static void showMainFrame() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainFrame frame = new MainFrame();
                frame.start();
                frame.requestFocus();
                frame.toFront();
                if (s_waitWindow != null) {
                    s_waitWindow.doneWait();
                }
                if (s_countDownLatch != null) {
                    s_countDownLatch.countDown();
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void handleCommandLineArgs(String[] args) {
        String[] properties = GameRunner2.getProperties();
        if (args.length == 1) {
            boolean startsWithPropertyKey = false;
            for (String prop : properties) {
                if (!args[0].startsWith(prop)) continue;
                startsWithPropertyKey = true;
                break;
            }
            if (!startsWithPropertyKey) {
                args[0] = "triplea.game=" + args[0];
            }
        }
        boolean usagePrinted = false;
        for (int argIndex = 0; argIndex < args.length; ++argIndex) {
            boolean found = false;
            String arg = args[argIndex];
            int indexOf = arg.indexOf(61);
            if (indexOf > 0) {
                arg = arg.substring(0, indexOf);
                for (int propIndex = 0; propIndex < properties.length; ++propIndex) {
                    if (!arg.equals(properties[propIndex])) continue;
                    String value = GameRunner2.getValue(args[argIndex]);
                    System.getProperties().setProperty(properties[propIndex], value);
                    System.out.println(properties[propIndex] + ":" + value);
                    found = true;
                    break;
                }
            }
            if (found) continue;
            System.out.println("Unrecogized:" + args[argIndex]);
            if (usagePrinted) continue;
            usagePrinted = true;
            GameRunner2.usage();
        }
        String version = System.getProperty(TRIPLEA_ENGINE_VERSION_BIN);
        if (version != null && version.length() > 0) {
            try {
                Version testVersion = new Version(version);
                System.out.println("triplea.engine.version.bin:" + version);
                if (EngineVersion.VERSION.equals(testVersion, false)) return;
                System.out.println("Current Engine version in use: " + EngineVersion.VERSION.toString());
                return;
            }
            catch (Exception e) {
                System.getProperties().setProperty(TRIPLEA_ENGINE_VERSION_BIN, EngineVersion.VERSION.toString());
                System.out.println("triplea.engine.version.bin:" + EngineVersion.VERSION.toString());
                return;
            }
        } else {
            System.getProperties().setProperty(TRIPLEA_ENGINE_VERSION_BIN, EngineVersion.VERSION.toString());
            System.out.println("triplea.engine.version.bin:" + EngineVersion.VERSION.toString());
        }
    }

    private static String getValue(String arg) {
        int index = arg.indexOf(61);
        if (index == -1) {
            return "";
        }
        return arg.substring(index + 1);
    }

    public static void setupLookAndFeel() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    block4: {
                        try {
                            UIManager.setLookAndFeel(GameRunner2.getDefaultLookAndFeel());
                        }
                        catch (Throwable t) {
                            if (GameRunner.isMac()) break block4;
                            try {
                                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
            });
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
        }
    }

    public static void setupLogging() {
        try {
            LogManager.getLogManager().readConfiguration(ClassLoader.getSystemResourceAsStream("logging.properties"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getDefaultLookAndFeel() {
        Preferences pref = Preferences.userNodeForPackage(GameRunner2.class);
        String defaultLookAndFeel = "org.jvnet.substance.skin.SubstanceRavenGraphiteLookAndFeel";
        if (GameRunner.isMac()) {
            defaultLookAndFeel = UIManager.getSystemLookAndFeelClassName();
        }
        String userDefault = pref.get(LOOK_AND_FEEL_PREF, defaultLookAndFeel);
        List<String> availableSkins = BasicGameMenuBar.getLookAndFeelAvailableList();
        if (!availableSkins.contains(userDefault)) {
            if (!availableSkins.contains(defaultLookAndFeel)) {
                return UIManager.getSystemLookAndFeelClassName();
            }
            GameRunner2.setDefaultLookAndFeel(defaultLookAndFeel);
            return defaultLookAndFeel;
        }
        return userDefault;
    }

    public static void setDefaultLookAndFeel(String lookAndFeelClassName) {
        Preferences pref = Preferences.userNodeForPackage(GameRunner2.class);
        pref.put(LOOK_AND_FEEL_PREF, lookAndFeelClassName);
        try {
            pref.sync();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    private static void checkForMemoryXMX() {
        String memSetString = System.getProperty(TRIPLEA_MEMORY_SET, "false");
        boolean memSet = Boolean.parseBoolean(memSetString);
        if (memSet) {
            return;
        }
        Properties systemIni = GameRunner2.getSystemIni();
        if (GameRunner2.useDefaultMaxMemory(systemIni)) {
            return;
        }
        if (GameRunner2.getUseMaxMemorySettingOnlyForOnlineJoinOrHost(systemIni)) {
            return;
        }
        long xmx = GameRunner2.getMaxMemoryFromSystemIniFileInMB(systemIni);
        if (xmx <= 0L) {
            return;
        }
        int mb = 0x100000;
        long currentMaxMemory = Runtime.getRuntime().maxMemory();
        System.out.println("Current max memory: " + currentMaxMemory + ";  and new xmx should be: " + (xmx *= 0x100000L));
        long diff = Math.abs(currentMaxMemory - xmx);
        if ((double)diff <= (double)xmx * 0.2) {
            return;
        }
        if (s_waitWindow != null) {
            s_waitWindow.doneWait();
        }
        if (s_countDownLatch != null) {
            s_countDownLatch.countDown();
        }
        TripleAProcessRunner.startNewTripleA(xmx);
        System.exit(0);
    }

    public static boolean useDefaultMaxMemory(Properties systemIni) {
        String useDefaultMaxMemoryString = systemIni.getProperty(TRIPLEA_MEMORY_USE_DEFAULT, "true");
        boolean useDefaultMaxMemory = Boolean.parseBoolean(useDefaultMaxMemoryString);
        return useDefaultMaxMemory;
    }

    public static long getMaxMemoryInBytes() {
        Properties systemIni = GameRunner2.getSystemIni();
        String useDefaultMaxMemoryString = systemIni.getProperty(TRIPLEA_MEMORY_USE_DEFAULT, "true");
        boolean useDefaultMaxMemory = Boolean.parseBoolean(useDefaultMaxMemoryString);
        String maxMemoryString = systemIni.getProperty(TRIPLEA_MEMORY_XMX, "").trim();
        long max = Runtime.getRuntime().maxMemory();
        if (!useDefaultMaxMemory && maxMemoryString.length() > 0) {
            try {
                int maxMemorySet = Integer.parseInt(maxMemoryString);
                max = 0x100000L * (long)maxMemorySet;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return max;
    }

    public static int getMaxMemoryFromSystemIniFileInMB(Properties systemIni) {
        String maxMemoryString = systemIni.getProperty(TRIPLEA_MEMORY_XMX, "").trim();
        int maxMemorySet = -1;
        if (maxMemoryString.length() > 0) {
            try {
                maxMemorySet = Integer.parseInt(maxMemoryString);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return maxMemorySet;
    }

    public static Properties setMaxMemoryInMB(int maxMemoryInMB) {
        System.out.println("Setting max memory for TripleA to: " + maxMemoryInMB + "m");
        Properties prop = new Properties();
        prop.put(TRIPLEA_MEMORY_USE_DEFAULT, "false");
        prop.put(TRIPLEA_MEMORY_XMX, "" + maxMemoryInMB);
        return prop;
    }

    public static void clearMaxMemory() {
        Properties prop = new Properties();
        prop.put(TRIPLEA_MEMORY_USE_DEFAULT, "true");
        prop.put(TRIPLEA_MEMORY_ONLINE_ONLY, "true");
        prop.put(TRIPLEA_MEMORY_XMX, "");
        GameRunner2.writeSystemIni(prop, false);
    }

    public static void setUseMaxMemorySettingOnlyForOnlineJoinOrHost(boolean useForOnlineOnly, Properties prop) {
        prop.put(TRIPLEA_MEMORY_ONLINE_ONLY, "" + useForOnlineOnly);
    }

    public static boolean getUseMaxMemorySettingOnlyForOnlineJoinOrHost(Properties systemIni) {
        String forOnlineOnlyString = systemIni.getProperty(TRIPLEA_MEMORY_ONLINE_ONLY, "true");
        boolean forOnlineOnly = Boolean.parseBoolean(forOnlineOnlyString);
        return forOnlineOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getSystemIni() {
        Properties rVal = new Properties();
        File systemIni = new File(GameRunner2.getRootFolder(), SYSTEM_INI);
        if (systemIni != null && systemIni.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(systemIni);
                rVal.load(fis);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return rVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeSystemIni(Properties properties, boolean clearOldAndOverwrite) {
        Properties toWrite;
        if (clearOldAndOverwrite) {
            toWrite = properties;
        } else {
            toWrite = GameRunner2.getSystemIni();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                toWrite.put(entry.getKey(), entry.getValue());
            }
        }
        FileOutputStream fos = null;
        try {
            File systemIni = new File(GameRunner2.getRootFolder(), SYSTEM_INI);
            fos = new FileOutputStream(systemIni);
            toWrite.store(fos, SYSTEM_INI);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static void setupProxies() {
        Preferences pref;
        ProxyChoice choice;
        String proxyHostArgument = System.getProperty(PROXY_HOST);
        String proxyPortArgument = System.getProperty(PROXY_PORT);
        if (proxyHostArgument == null) {
            proxyHostArgument = System.getProperty(HTTP_PROXYHOST);
        }
        if (proxyPortArgument == null) {
            proxyPortArgument = System.getProperty(HTTP_PROXYPORT);
        }
        String proxyHost = null;
        if (proxyHostArgument != null && proxyHostArgument.trim().length() > 0) {
            proxyHost = proxyHostArgument;
        }
        String proxyPort = null;
        if (proxyPortArgument != null && proxyPortArgument.trim().length() > 0) {
            try {
                Integer.parseInt(proxyPortArgument);
                proxyPort = proxyPortArgument;
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        }
        if (proxyHost != null || proxyPort != null) {
            GameRunner2.setProxy(proxyHost, proxyPort, ProxyChoice.USE_USER_PREFERENCES);
        }
        if ((choice = ProxyChoice.valueOf((pref = Preferences.userNodeForPackage(GameRunner2.class)).get(PROXY_CHOICE, ProxyChoice.NONE.toString()))) == ProxyChoice.USE_SYSTEM_SETTINGS) {
            GameRunner2.setToUseSystemProxies();
        } else if (choice == ProxyChoice.USE_USER_PREFERENCES) {
            String host = pref.get(PROXY_HOST, "");
            String port = pref.get(PROXY_PORT, "");
            if (host.trim().length() > 0) {
                System.setProperty(HTTP_PROXYHOST, host);
            }
            if (port.trim().length() > 0) {
                System.setProperty(HTTP_PROXYPORT, port);
            }
        }
    }

    public static void setProxy(String proxyHost, String proxyPort, ProxyChoice proxyChoice) {
        ProxyChoice choice;
        Preferences pref = Preferences.userNodeForPackage(GameRunner2.class);
        if (proxyChoice != null) {
            choice = proxyChoice;
            pref.put(PROXY_CHOICE, proxyChoice.toString());
        } else {
            choice = ProxyChoice.valueOf(pref.get(PROXY_CHOICE, ProxyChoice.NONE.toString()));
        }
        if (proxyHost != null && proxyHost.trim().length() > 0) {
            pref.put(PROXY_HOST, proxyHost);
            if (choice == ProxyChoice.USE_USER_PREFERENCES) {
                System.setProperty(HTTP_PROXYHOST, proxyHost);
            }
        }
        if (proxyPort != null && proxyPort.trim().length() > 0) {
            try {
                Integer.parseInt(proxyPort);
                pref.put(PROXY_PORT, proxyPort);
                if (choice == ProxyChoice.USE_USER_PREFERENCES) {
                    System.setProperty(HTTP_PROXYPORT, proxyPort);
                }
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        }
        if (choice == ProxyChoice.NONE) {
            System.clearProperty(HTTP_PROXYHOST);
            System.clearProperty(HTTP_PROXYPORT);
        } else if (choice == ProxyChoice.USE_SYSTEM_SETTINGS) {
            GameRunner2.setToUseSystemProxies();
        }
        if (proxyHost != null || proxyPort != null || proxyChoice != null) {
            try {
                pref.flush();
                pref.sync();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setToUseSystemProxies() {
        String JAVA_NET_USESYSTEMPROXIES = "java.net.useSystemProxies";
        System.setProperty("java.net.useSystemProxies", "true");
        List<Proxy> proxyList = null;
        try {
            ProxySelector def = ProxySelector.getDefault();
            if (def != null) {
                proxyList = def.select(new URI("http://sourceforge.net/"));
                ProxySelector.setDefault(null);
                if (proxyList != null && !proxyList.isEmpty()) {
                    Proxy proxy = proxyList.get(0);
                    InetSocketAddress address = (InetSocketAddress)proxy.address();
                    if (address != null) {
                        String host = address.getHostName();
                        int port = address.getPort();
                        System.setProperty(HTTP_PROXYHOST, host);
                        System.setProperty(HTTP_PROXYPORT, Integer.toString(port));
                        System.setProperty(PROXY_HOST, host);
                        System.setProperty(PROXY_PORT, Integer.toString(port));
                    } else {
                        System.clearProperty(HTTP_PROXYHOST);
                        System.clearProperty(HTTP_PROXYPORT);
                        System.clearProperty(PROXY_HOST);
                        System.clearProperty(PROXY_PORT);
                    }
                }
            } else {
                String host = System.getProperty(PROXY_HOST);
                String port = System.getProperty(PROXY_PORT);
                if (host == null) {
                    System.clearProperty(HTTP_PROXYHOST);
                } else {
                    System.setProperty(HTTP_PROXYHOST, host);
                }
                if (port == null) {
                    System.clearProperty(HTTP_PROXYPORT);
                } else {
                    try {
                        Integer.parseInt(port);
                        System.setProperty(HTTP_PROXYPORT, port);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            System.setProperty("java.net.useSystemProxies", "false");
        }
    }

    public static void addProxy(HostConfiguration config) {
        String host = System.getProperty(HTTP_PROXYHOST);
        String port = System.getProperty(HTTP_PROXYPORT, "-1");
        if (host != null && host.trim().length() > 0) {
            config.setProxy(host, Integer.valueOf(port));
        }
    }

    public static boolean getDelayedParsing() {
        Preferences pref = Preferences.userNodeForPackage(GameRunner2.class);
        return pref.getBoolean(DELAYED_PARSING, true);
    }

    public static void setDelayedParsing(boolean delayedParsing) {
        Preferences pref = Preferences.userNodeForPackage(GameRunner2.class);
        pref.putBoolean(DELAYED_PARSING, delayedParsing);
        try {
            pref.sync();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public static void checkForUpdates() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                if (GameRunner2.areWeOldExtraJar()) {
                    return;
                }
                String fileName = System.getProperty(GameRunner2.TRIPLEA_GAME_PROPERTY, "");
                if (fileName.trim().length() > 0) {
                    return;
                }
                if (System.getProperty(GameRunner2.TRIPLEA_SERVER_PROPERTY, "false").equalsIgnoreCase("true")) {
                    return;
                }
                if (System.getProperty(GameRunner2.TRIPLEA_CLIENT_PROPERTY, "false").equalsIgnoreCase("true")) {
                    return;
                }
                if (System.getProperty(GameRunner2.TRIPLEA_DO_NOT_CHECK_FOR_UPDATES, "false").equalsIgnoreCase("true")) {
                    return;
                }
                if (s_countDownLatch != null) {
                    try {
                        s_countDownLatch.await();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                boolean busy = false;
                busy = GameRunner2.checkForLatestEngineVersionOut();
                if (!busy) {
                    busy = GameRunner2.checkForUpdatedMaps();
                }
            }
        }, "Checking Latest TripleA Engine Version");
        t.start();
    }

    private static boolean checkForLatestEngineVersionOut() {
        block9: {
            try {
                String[] yearDay;
                Preferences pref = Preferences.userNodeForPackage(GameRunner2.class);
                boolean firstTimeThisVersion = pref.getBoolean(TRIPLEA_FIRST_TIME_THIS_VERSION_PROPERTY, true);
                Calendar calendar = Calendar.getInstance();
                int year = calendar.get(1);
                int day = calendar.get(6);
                String lastCheckTime = pref.get(TRIPLEA_LAST_CHECK_FOR_ENGINE_UPDATE, "");
                if (!firstTimeThisVersion && lastCheckTime != null && lastCheckTime.trim().length() > 0 && Integer.parseInt((yearDay = lastCheckTime.split(":"))[0]) >= year && Integer.parseInt(yearDay[1]) + 1 >= day) {
                    return false;
                }
                pref.put(TRIPLEA_LAST_CHECK_FOR_ENGINE_UPDATE, year + ":" + day);
                try {
                    pref.sync();
                }
                catch (BackingStoreException e) {
                    // empty catch block
                }
                final EngineVersionProperties latestEngineOut = EngineVersionProperties.contactServerForEngineVersionProperties();
                if (latestEngineOut == null) {
                    return false;
                }
                if (EngineVersion.VERSION.isLessThan(latestEngineOut.getLatestVersionOut(), false)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            EventThreadJOptionPane.showMessageDialog(null, (Object)latestEngineOut.getOutOfDateComponent(false), "Please Update TripleA", 1, false, new CountDownLatchHandler(true));
                        }
                    });
                    return true;
                }
                if (!firstTimeThisVersion || !latestEngineOut.getReleaseNotes().containsKey(EngineVersion.VERSION)) break block9;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        EventThreadJOptionPane.showMessageDialog(null, (Object)latestEngineOut.getCurrentFeaturesComponent(), "What is New?", 1, false, new CountDownLatchHandler(true));
                    }
                });
                pref.putBoolean(TRIPLEA_FIRST_TIME_THIS_VERSION_PROPERTY, false);
                try {
                    pref.flush();
                }
                catch (BackingStoreException ex) {
                    // empty catch block
                }
                return true;
            }
            catch (Exception e) {
                System.out.println("Error while checking for engine updates: " + e.getMessage());
            }
        }
        return false;
    }

    private static boolean checkForUpdatedMaps() {
        try {
            String[] yearMonth;
            Preferences pref = Preferences.userNodeForPackage(GameRunner2.class);
            Calendar calendar = Calendar.getInstance();
            int year = calendar.get(1);
            int month = calendar.get(2);
            String lastCheckTime = pref.get(TRIPLEA_LAST_CHECK_FOR_MAP_UPDATES, "");
            if (lastCheckTime != null && lastCheckTime.trim().length() > 0 && Integer.parseInt((yearMonth = lastCheckTime.split(":"))[0]) >= year && Integer.parseInt(yearMonth[1]) >= month) {
                return false;
            }
            pref.put(TRIPLEA_LAST_CHECK_FOR_MAP_UPDATES, year + ":" + month);
            try {
                pref.sync();
            }
            catch (BackingStoreException e) {
                // empty catch block
            }
            Vector<String> sites = DownloadMapDialog.getStoredDownloadSites();
            if (sites == null || sites.isEmpty()) {
                return false;
            }
            String selectedUrl = sites.get(0);
            if (selectedUrl == null || selectedUrl.trim().length() == 0) {
                return false;
            }
            DownloadRunnable download = new DownloadRunnable(selectedUrl, true);
            BackgroundTaskRunner.runInBackground(null, "Checking for out-of-date Maps.", download, new CountDownLatchHandler(true));
            if (download.getError() != null) {
                return false;
            }
            List<DownloadFileDescription> downloads = download.getDownloads();
            if (downloads == null || downloads.isEmpty()) {
                return false;
            }
            ArrayList<String> outOfDateMaps = new ArrayList<String>();
            InstallMapDialog.populateOutOfDateMapsListing(outOfDateMaps, downloads);
            if (!outOfDateMaps.isEmpty()) {
                final StringBuilder text = new StringBuilder("<html>Some of the maps you have are out of date, and newer versions of those maps exist.<br>You should update (re-download) the following maps:<br><ul>");
                for (String map : outOfDateMaps) {
                    text.append("<li> " + map + "</li>");
                }
                text.append("</ul><br><br>You can update them by clicking on the 'Download Maps' button on the start screen of TripleA.</html>");
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        EventThreadJOptionPane.showMessageDialog(null, (Object)text, "Update Your Maps", 1, false, new CountDownLatchHandler(true));
                    }
                });
                return true;
            }
        }
        catch (Exception e) {
            System.out.println("Error while checking for map updates: " + e.getMessage());
        }
        return false;
    }

    public static boolean areWeOldExtraJar() {
        URL url = GameRunner2.class.getResource("GameRunner2.class");
        String fileName = url.getFile();
        try {
            fileName = URLDecoder.decode(fileName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String tripleaJarNameWithEngineVersion = GameRunner2.getTripleaJarWithEngineVersionStringPath();
        if (fileName.indexOf(tripleaJarNameWithEngineVersion) != -1) {
            String path;
            String subString = fileName.substring("file:/".length() - (GameRunner.isWindows() ? 0 : 1), fileName.indexOf(tripleaJarNameWithEngineVersion) - 1);
            File f = new File(subString);
            if (!f.exists()) {
                throw new IllegalStateException("File not found:" + f);
            }
            try {
                path = f.getCanonicalPath();
            }
            catch (IOException e) {
                path = f.getPath();
            }
            return path.indexOf("old") != -1;
        }
        return false;
    }

    private static String getTripleaJarWithEngineVersionStringPath() {
        return "triplea_" + EngineVersion.VERSION.toStringFull("_") + ".jar!";
    }

    public static Image getGameIcon(Window frame) {
        Image img = null;
        try {
            img = frame.getToolkit().getImage(GameRunner2.class.getResource("ta_icon.png"));
        }
        catch (Exception ex) {
            System.out.println("icon not loaded");
        }
        MediaTracker tracker = new MediaTracker(frame);
        tracker.addImage(img, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        return img;
    }

    public static File getUserRootFolder() {
        File userHome = new File(System.getProperties().getProperty("user.home"));
        File rootDir = GameRunner.isMac() ? new File(new File(userHome, "Documents"), "triplea") : new File(userHome, "triplea");
        return rootDir;
    }

    public static File getUserMapsFolder() {
        File f = new File(GameRunner2.getUserRootFolder(), "maps");
        if (!f.exists()) {
            try {
                f.mkdirs();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        return f;
    }

    public static File getRootFolder() {
        URL url = GameRunner2.class.getResource("GameRunner2.class");
        int moveUpCount = GameRunner2.class.getName().split("\\.").length + 1;
        String fileName = url.getFile();
        try {
            fileName = URLDecoder.decode(fileName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String tripleaJarName = "triplea.jar!";
        String tripleaJarNameWithEngineVersion = GameRunner2.getTripleaJarWithEngineVersionStringPath();
        if (fileName.indexOf("triplea.jar!") != -1) {
            String subString = fileName.substring("file:/".length() - (GameRunner.isWindows() ? 0 : 1), fileName.indexOf("triplea.jar!") - 1);
            File f = new File(subString).getParentFile();
            if (!f.exists()) {
                throw new IllegalStateException("File not found:" + f);
            }
            return f;
        }
        if (fileName.indexOf(tripleaJarNameWithEngineVersion) != -1) {
            String subString = fileName.substring("file:/".length() - (GameRunner.isWindows() ? 0 : 1), fileName.indexOf(tripleaJarNameWithEngineVersion) - 1);
            File f = new File(subString).getParentFile();
            if (!f.exists()) {
                throw new IllegalStateException("File not found:" + f);
            }
            return f;
        }
        File f = new File(fileName);
        for (int i = 0; i < moveUpCount; ++i) {
            f = f.getParentFile();
        }
        if (!f.exists()) {
            System.err.println("Could not find root folder, does  not exist:" + f);
            return new File(System.getProperties().getProperty("user.dir"));
        }
        return f;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProxyChoice {
        NONE,
        USE_SYSTEM_SETTINGS,
        USE_USER_PREFERENCES;

    }
}

