/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework;

import games.strategy.engine.chat.Chat;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.properties.GameProperties;
import games.strategy.engine.framework.AvailableGames;
import games.strategy.engine.framework.HeadlessGameServerConsole;
import games.strategy.engine.framework.HeadlessServerMainPanel;
import games.strategy.engine.framework.HeadlessServerSetup;
import games.strategy.engine.framework.HeadlessServerSetupPanelModel;
import games.strategy.engine.framework.ServerGame;
import games.strategy.engine.framework.startup.launcher.ILauncher;
import games.strategy.engine.framework.startup.mc.GameSelectorModel;
import games.strategy.engine.framework.startup.mc.ServerModel;
import games.strategy.engine.framework.startup.mc.SetupPanelModel;
import games.strategy.engine.framework.startup.ui.ClientSetupPanel;
import games.strategy.engine.framework.startup.ui.ISetupPanel;
import games.strategy.engine.framework.startup.ui.ServerSetupPanel;
import games.strategy.sound.ClipPlayer;
import games.strategy.triplea.ui.ErrorHandler;
import games.strategy.triplea.util.LoggingPrintStream;
import games.strategy.util.Util;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeadlessGameServer {
    public static final String TRIPLEA_GAME_HOST_UI_PROPERTY = "triplea.game.host.ui";
    public static final String TRIPLEA_HEADLESS = "triplea.headless";
    public static final String TRIPLEA_GAME_HOST_CONSOLE_PROPERTY = "triplea.game.host.console";
    static final Logger s_logger = Logger.getLogger(HeadlessGameServer.class.getName());
    static HeadlessGameServerConsole s_console = null;
    private static HeadlessGameServer s_instance = null;
    private final AvailableGames m_availableGames;
    private final GameSelectorModel m_gameSelectorModel;
    private SetupPanelModel m_setupPanelModel = null;
    private HeadlessServerMainPanel m_mainPanel = null;
    private final boolean m_useUI;
    private final ScheduledExecutorService m_lobbyWatcherResetupThread = Executors.newScheduledThreadPool(1);
    private ServerGame m_iGame = null;
    private boolean m_shutDown = false;

    public static String[] getProperties() {
        return new String[]{"triplea.game", TRIPLEA_GAME_HOST_CONSOLE_PROPERTY, TRIPLEA_GAME_HOST_UI_PROPERTY, "triplea.server", "triplea.port", "triplea.name", "triplea.lobby.host", "triplea.lobby.port", "triplea.lobby.game.comments", "triplea.lobby.game.hostedBy", "triplea.lobby.game.supportEmail"};
    }

    private static void usage() {
        System.out.println("Arguments\n   triplea.game=<FILE_NAME>\n   triplea.game.host.console=<true/false>\n   triplea.game.host.ui=<true/false>\n   triplea.server=true\n   triplea.port=<PORT>\n   triplea.name=<PLAYER_NAME>\n   triplea.lobby.host=<LOBBY_HOST>\n   triplea.lobby.port=<LOBBY_PORT>\n   triplea.lobby.game.comments=<LOBBY_GAME_COMMENTS>\n   triplea.lobby.game.hostedBy=<LOBBY_GAME_HOSTED_BY>\n   triplea.server.password=<password>\n\n   If there is only one argument, and it does not start with a prefix, the argument will be \n   taken as the name of the file to load.\n\n   Examples:\n   To start a game using the given file:\n\n   triplea /home/sgb/games/test.xml\n\n   or\n\n   triplea triplea.game=/home/sgb/games/test.xml\n\n   To start a server with the given game\n\n   triplea triplea.game=/home/sgb/games/test.xml triplea.port=3300 triplea.name=Allan");
    }

    public static synchronized HeadlessGameServer getInstance() {
        return s_instance;
    }

    public static synchronized boolean getUseGameServerUI() {
        return Boolean.parseBoolean(System.getProperty(TRIPLEA_GAME_HOST_UI_PROPERTY, "false"));
    }

    public static synchronized boolean headless() {
        if (HeadlessGameServer.getInstance() != null) {
            return true;
        }
        return Boolean.parseBoolean(System.getProperty(TRIPLEA_HEADLESS, "false"));
    }

    public Set<String> getAvailableGames() {
        return new HashSet<String>(this.m_availableGames.getGameNames());
    }

    public synchronized void setGameMapTo(String gameName) {
        if (this.m_setupPanelModel.getPanel() != null && this.m_iGame == null) {
            if (!this.m_availableGames.getGameNames().contains(gameName)) {
                return;
            }
            this.m_gameSelectorModel.load(this.m_availableGames.getGameData(gameName), this.m_availableGames.getGameFilePath(gameName));
        }
    }

    public synchronized void loadGameSave(File file) {
        if (this.m_setupPanelModel.getPanel() != null && this.m_iGame == null) {
            if (file == null || !file.exists()) {
                return;
            }
            this.m_gameSelectorModel.load(file, null);
        }
    }

    public synchronized void loadGameSave(InputStream input, String fileName) {
        if (this.m_setupPanelModel.getPanel() != null && this.m_iGame == null) {
            if (input == null || fileName == null) {
                return;
            }
            GameData data = this.m_gameSelectorModel.getGameData(input, fileName);
            if (data == null) {
                System.out.println("Loading GameData failed for: " + fileName);
                return;
            }
            String mapNameProperty = data.getProperties().get("mapName", "");
            if (!this.m_availableGames.getAvailableMapFolderOrZipNames().contains(mapNameProperty)) {
                System.out.println("Game mapName not in available games listing: " + mapNameProperty);
                return;
            }
            this.m_gameSelectorModel.load(data, fileName);
        }
    }

    public synchronized void loadGameOptions(byte[] bytes) {
        if (this.m_setupPanelModel.getPanel() != null && this.m_iGame == null) {
            if (bytes == null || bytes.length == 0) {
                return;
            }
            GameData data = this.m_gameSelectorModel.getGameData();
            if (data == null) {
                return;
            }
            GameProperties props = data.getProperties();
            if (props == null) {
                return;
            }
            GameProperties.applyByteMapToChangeProperties(bytes, props);
        }
    }

    public synchronized void loadGameSave(ObjectInputStream input, String fileName) {
        if (this.m_setupPanelModel.getPanel() != null && this.m_iGame == null) {
            if (input == null || fileName == null) {
                return;
            }
            GameData data = this.m_gameSelectorModel.getGameData(input, fileName);
            if (data == null) {
                System.out.println("Loading GameData failed for: " + fileName);
                return;
            }
            String mapNameProperty = data.getProperties().get("mapName", "");
            if (!this.m_availableGames.getAvailableMapFolderOrZipNames().contains(mapNameProperty)) {
                System.out.println("Game mapName not in available games listing: " + mapNameProperty);
                return;
            }
            this.m_gameSelectorModel.load(data, fileName);
        }
    }

    public static synchronized void setServerGame(ServerGame serverGame) {
        HeadlessGameServer instance = HeadlessGameServer.getInstance();
        if (instance != null) {
            instance.m_iGame = serverGame;
            if (serverGame != null) {
                System.out.println("Game starting up: " + instance.m_iGame.isGameSequenceRunning() + ", GameOver: " + instance.m_iGame.isGameOver() + ", Players: " + instance.m_iGame.getPlayerManager().toString());
            }
        }
    }

    public static synchronized void log(String stdout) {
        HeadlessGameServer instance = HeadlessGameServer.getInstance();
        if (instance != null) {
            System.out.println(stdout);
        }
    }

    ServerGame getIGame() {
        return this.m_iGame;
    }

    public boolean isShutDown() {
        return this.m_shutDown;
    }

    public HeadlessGameServer(boolean useUI) {
        if (s_instance != null) {
            throw new IllegalStateException("Instance already exists");
        }
        s_instance = this;
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                System.out.println("Running ShutdownHook.");
                HeadlessGameServer.this.shutdown();
            }
        }));
        this.m_useUI = useUI;
        this.m_availableGames = new AvailableGames();
        this.m_gameSelectorModel = new GameSelectorModel();
        String fileName = System.getProperty("triplea.game", "");
        if (fileName.length() > 0) {
            File file = new File(fileName);
            this.m_gameSelectorModel.load(file, null);
        }
        if (this.m_useUI) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    System.out.println("Starting UI");
                    JFrame frame = new JFrame("TripleA Headless Game Server UI Main Frame");
                    frame.setDefaultCloseOperation(3);
                    frame.setPreferredSize(new Dimension(700, 630));
                    frame.setSize(new Dimension(700, 630));
                    frame.setLocationRelativeTo(null);
                    HeadlessGameServer.this.m_setupPanelModel = new HeadlessServerSetupPanelModel(HeadlessGameServer.this.m_gameSelectorModel, frame);
                    HeadlessGameServer.this.m_setupPanelModel.showSelectType();
                    HeadlessGameServer.this.m_mainPanel = new HeadlessServerMainPanel(HeadlessGameServer.this.m_setupPanelModel, HeadlessGameServer.this.m_availableGames);
                    frame.getContentPane().add(HeadlessGameServer.this.m_mainPanel);
                    frame.pack();
                    frame.setVisible(true);
                    frame.toFront();
                    System.out.println("Waiting for users to connect.");
                }
            });
        } else {
            Runnable r = new Runnable(){

                public void run() {
                    System.out.println("Headless Start");
                    HeadlessGameServer.this.m_setupPanelModel = new HeadlessServerSetupPanelModel(HeadlessGameServer.this.m_gameSelectorModel, null);
                    HeadlessGameServer.this.m_setupPanelModel.showSelectType();
                    System.out.println("Waiting for users to connect.");
                    HeadlessGameServer.this.waitForUsersHeadless();
                }
            };
            Thread t = new Thread(r, "Initialize Headless Server Setup Model");
            t.start();
        }
        this.m_lobbyWatcherResetupThread.scheduleAtFixedRate(new Runnable(){

            public void run() {
                HeadlessGameServer.restartLobbyWatcher(HeadlessGameServer.this.m_setupPanelModel, HeadlessGameServer.this.m_iGame);
            }
        }, 21600L, 21600L, TimeUnit.SECONDS);
        s_logger.info("Game Server initialized");
    }

    private static synchronized void restartLobbyWatcher(SetupPanelModel setupPanelModel, ServerGame iGame) {
        try {
            ISetupPanel setup = setupPanelModel.getPanel();
            if (setup == null) {
                return;
            }
            if (iGame != null) {
                return;
            }
            if (setup.canGameStart()) {
                return;
            }
            if (setup instanceof ServerSetupPanel) {
                ((ServerSetupPanel)setup).repostLobbyWatcher(iGame);
            } else if (setup instanceof HeadlessServerSetup) {
                ((HeadlessServerSetup)setup).repostLobbyWatcher(iGame);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void resetLobbyHostOldExtensionProperties() {
        for (String property : HeadlessGameServer.getProperties()) {
            String oldValue;
            if (!"triplea.lobby.host".equals(property) && !"triplea.lobby.port".equals(property) && !"triplea.lobby.game.hostedBy".equals(property) || (oldValue = System.getProperty(property + ".old")) == null) continue;
            System.setProperty(property, oldValue);
        }
    }

    public synchronized void shutdown() {
        this.m_shutDown = true;
        try {
            if (this.m_lobbyWatcherResetupThread != null) {
                this.m_lobbyWatcherResetupThread.shutdown();
                Thread.sleep(250L);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.m_iGame != null) {
                this.m_iGame.stopGame();
                Thread.sleep(500L);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.m_setupPanelModel != null) {
                ISetupPanel setup = this.m_setupPanelModel.getPanel();
                if (setup != null && setup instanceof ServerSetupPanel) {
                    ((ServerSetupPanel)setup).shutDown();
                } else if (setup != null && setup instanceof HeadlessServerSetup) {
                    ((HeadlessServerSetup)setup).shutDown();
                }
                Thread.sleep(250L);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.m_gameSelectorModel != null && this.m_gameSelectorModel.getGameData() != null) {
                this.m_gameSelectorModel.getGameData().clearAllListeners();
                Thread.sleep(250L);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.m_mainPanel != null) {
                this.m_mainPanel.setVisible(false);
                Frame frame = JOptionPane.getFrameForComponent(this.m_mainPanel);
                this.m_mainPanel.removeAll();
                frame.setVisible(false);
                frame.removeAll();
                frame.dispose();
                this.m_mainPanel = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        s_instance = null;
        this.m_setupPanelModel = null;
        this.m_mainPanel = null;
        this.m_iGame = null;
        System.out.println("Shutdown Script Finished.");
    }

    public void waitForUsersHeadless() {
        HeadlessGameServer.setServerGame(null);
        if (this.m_useUI) {
            return;
        }
        Runnable r = new Runnable(){

            public void run() {
                while (!HeadlessGameServer.this.m_shutDown) {
                    try {
                        Thread.sleep(8000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (HeadlessGameServer.this.m_setupPanelModel == null || HeadlessGameServer.this.m_setupPanelModel.getPanel() == null || !HeadlessGameServer.this.m_setupPanelModel.getPanel().canGameStart()) continue;
                    boolean started = HeadlessGameServer.startHeadlessGame(HeadlessGameServer.this.m_setupPanelModel);
                    if (started) break;
                    System.out.println("Error in launcher, going back to waiting.");
                }
            }
        };
        Thread t = new Thread(r, "Headless Server Waiting For Users To Connect And Start");
        t.start();
    }

    private static synchronized boolean startHeadlessGame(SetupPanelModel setupPanelModel) {
        try {
            if (setupPanelModel != null && setupPanelModel.getPanel() != null && setupPanelModel.getPanel().canGameStart()) {
                ErrorHandler.setGameOver(false);
                System.out.println("Starting Game: " + setupPanelModel.getGameSelectorModel().getGameData().getGameName() + ", Round: " + setupPanelModel.getGameSelectorModel().getGameData().getSequence().getRound());
                setupPanelModel.getPanel().preStartGame();
                ILauncher launcher = setupPanelModel.getPanel().getLauncher();
                if (launcher != null) {
                    launcher.launch(null);
                }
                setupPanelModel.getPanel().postStartGame();
                return launcher != null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void waitForUsersHeadlessInstance() {
        HeadlessGameServer server = HeadlessGameServer.getInstance();
        if (server == null) {
            System.err.println("Couldn't find instance.");
            System.exit(-1);
        } else {
            System.out.println("Waiting for users to connect.");
            server.waitForUsersHeadless();
        }
    }

    SetupPanelModel getSetupPanelModel() {
        return this.m_setupPanelModel;
    }

    ServerModel getServerModel() {
        if (this.m_setupPanelModel == null) {
            return null;
        }
        ISetupPanel setup = this.m_setupPanelModel.getPanel();
        if (setup != null && setup instanceof ServerSetupPanel) {
            return ((ServerSetupPanel)setup).getModel();
        }
        if (setup != null && setup instanceof HeadlessServerSetup) {
            return ((HeadlessServerSetup)setup).getModel();
        }
        return null;
    }

    public Chat getChat() {
        ISetupPanel model = this.m_setupPanelModel.getPanel();
        if (model instanceof ServerSetupPanel) {
            return model.getChatPanel().getChat();
        }
        if (model instanceof ClientSetupPanel) {
            return model.getChatPanel().getChat();
        }
        if (model instanceof HeadlessServerSetup) {
            return model.getChatPanel().getChat();
        }
        return null;
    }

    public static void main(String[] args) {
        HeadlessGameServer.handleCommandLineArgs(args);
        InputStream in = System.in;
        PrintStream out = System.out;
        HeadlessGameServer.setupLogging();
        boolean startUI = HeadlessGameServer.getUseGameServerUI();
        if (!startUI) {
            ClipPlayer.setBeSilentInPreferencesWithoutAffectingCurrent(true);
        }
        HeadlessGameServer server = null;
        try {
            server = new HeadlessGameServer(startUI);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (Boolean.parseBoolean(System.getProperty(TRIPLEA_GAME_HOST_CONSOLE_PROPERTY, "false"))) {
            HeadlessGameServer.startConsole(server, in, out);
        }
    }

    private static void startConsole(HeadlessGameServer server, InputStream in, PrintStream out) {
        System.out.println("Starting console.");
        s_console = new HeadlessGameServerConsole(server, in, out);
        s_console.start();
    }

    public static void setupLogging() {
        try {
            LogManager.getLogManager().readConfiguration(ClassLoader.getSystemResourceAsStream("headless-game-server-logging.properties"));
            Logger.getAnonymousLogger().info("Redirecting std out");
            System.setErr(new LoggingPrintStream("ERROR", Level.SEVERE));
            System.setOut(new LoggingPrintStream("OUT", Level.INFO));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void handleCommandLineArgs(String[] args) {
        System.getProperties().setProperty(TRIPLEA_HEADLESS, "true");
        String[] properties = HeadlessGameServer.getProperties();
        if (args.length == 1) {
            boolean startsWithPropertyKey = false;
            for (String prop : properties) {
                if (!args[0].startsWith(prop)) continue;
                startsWithPropertyKey = true;
                break;
            }
            if (!startsWithPropertyKey) {
                args[0] = "triplea.game=" + args[0];
            }
        }
        boolean printUsage = false;
        for (int argIndex = 0; argIndex < args.length; ++argIndex) {
            boolean found = false;
            String arg = args[argIndex];
            int indexOf = arg.indexOf(61);
            if (indexOf > 0) {
                arg = arg.substring(0, indexOf);
                for (int propIndex = 0; propIndex < properties.length; ++propIndex) {
                    if (!arg.equals(properties[propIndex])) continue;
                    String value = HeadlessGameServer.getValue(args[argIndex]);
                    System.getProperties().setProperty(properties[propIndex], value);
                    System.out.println(properties[propIndex] + ":" + value);
                    found = true;
                    break;
                }
            }
            if (found) continue;
            System.out.println("Unrecogized argument: " + args[argIndex]);
            printUsage = true;
        }
        String playerName = System.getProperty("triplea.name", "");
        String hostName = System.getProperty("triplea.lobby.game.hostedBy", "");
        String comments = System.getProperty("triplea.lobby.game.comments", "");
        String email = System.getProperty("triplea.lobby.game.supportEmail", "");
        if (!(playerName.length() >= 7 && hostName.length() >= 7 && hostName.equals(playerName) && playerName.startsWith("Bot") && hostName.startsWith("Bot"))) {
            System.out.println("Invalide argument: triplea.name and triplea.lobby.game.hostedBy must start with \"Bot\" and be at least 7 characters long and be the same.");
            printUsage = true;
        }
        if (comments.indexOf("automated_host") == -1) {
            System.out.println("Invalide argument: triplea.lobby.game.comments must contain the string \"automated_host\".");
            printUsage = true;
        }
        if (email.length() < 3 || !Util.isMailValid(email)) {
            System.out.println("Invalide argument: triplea.lobby.game.supportEmail must contain a valid email address.");
            printUsage = true;
        }
        if (printUsage) {
            HeadlessGameServer.usage();
            System.exit(1);
        }
    }

    private static String getValue(String arg) {
        int index = arg.indexOf(61);
        if (index == -1) {
            return "";
        }
        return arg.substring(index + 1);
    }
}

