/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework;

import games.strategy.debug.Console;
import games.strategy.engine.chat.Chat;
import games.strategy.engine.chat.HeadlessChat;
import games.strategy.engine.chat.IChatPanel;
import games.strategy.engine.framework.HeadlessGameServer;
import games.strategy.engine.framework.ServerGame;
import games.strategy.engine.framework.ui.SaveGameFileChooser;
import games.strategy.net.INode;
import games.strategy.net.IServerMessenger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Date;
import java.util.Set;

class HeadlessGameServerConsole {
    private final HeadlessGameServer server;
    private final PrintStream out;
    private final BufferedReader in;
    private final String startDate = new Date().toGMTString();
    private boolean m_shutDown = false;
    private boolean m_chatMode = false;

    public HeadlessGameServerConsole(HeadlessGameServer server, InputStream in, PrintStream out) {
        this.out = out;
        this.in = new BufferedReader(new InputStreamReader(in));
        this.server = server;
    }

    public void start() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                HeadlessGameServerConsole.this.printEvalLoop();
            }
        }, "Headless console eval print loop");
        t.setDaemon(true);
        t.start();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                HeadlessGameServerConsole.this.out.println("Shutting Down.   See log file.");
            }
        }));
    }

    private void printEvalLoop() {
        this.out.println();
        while (!this.m_shutDown) {
            this.out.print(">>>>");
            this.out.flush();
            try {
                String command = this.in.readLine();
                this.process(command.trim());
            }
            catch (Throwable t) {
                t.printStackTrace();
                t.printStackTrace(this.out);
            }
        }
    }

    private void process(String command) {
        if (command.equals("")) {
            return;
        }
        String noun = command.split("\\s")[0];
        if (noun.equalsIgnoreCase("help")) {
            this.showHelp();
        } else if (noun.equalsIgnoreCase("status")) {
            this.showStatus();
        } else if (noun.equalsIgnoreCase("save")) {
            this.save(command);
        } else if (noun.equalsIgnoreCase("stop")) {
            this.stop();
        } else if (noun.equalsIgnoreCase("quit")) {
            this.quit();
        } else if (noun.equalsIgnoreCase("connections")) {
            this.showConnections();
        } else if (noun.equalsIgnoreCase("send")) {
            this.send(command);
        } else if (noun.equalsIgnoreCase("chatlog")) {
            this.chatlog();
        } else if (noun.equalsIgnoreCase("chatmode")) {
            this.chatmode();
        } else if (noun.equalsIgnoreCase("ban")) {
            this.ban(command);
        } else if (noun.equalsIgnoreCase("memory")) {
            this.memory();
        } else if (noun.equalsIgnoreCase("threads")) {
            this.threads();
        } else {
            this.out.println("Unrecognized command:" + command);
            this.showHelp();
        }
    }

    private void send(String command) {
        if (this.server == null || command == null) {
            return;
        }
        Chat chat = this.server.getChat();
        if (chat == null) {
            return;
        }
        try {
            String message;
            if (command.length() > 5) {
                message = command.substring(5, command.length());
            } else {
                this.out.println("Input chat message: ");
                message = this.in.readLine();
            }
            chat.sendMessage(message, false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void chatlog() {
        if (this.server == null) {
            return;
        }
        IChatPanel chat = this.server.getServerModel().getChatPanel();
        if (chat == null) {
            return;
        }
        this.out.println();
        this.out.println(chat.getAllText());
        this.out.println();
    }

    private void chatmode() {
        if (this.server == null) {
            return;
        }
        IChatPanel chat = this.server.getServerModel().getChatPanel();
        if (chat == null || !(chat instanceof HeadlessChat)) {
            return;
        }
        this.m_chatMode = !this.m_chatMode;
        this.out.println("chatmode is now " + (this.m_chatMode ? "on" : "off"));
        HeadlessChat headlessChat = (HeadlessChat)chat;
        headlessChat.setPrintStream(this.m_chatMode ? this.out : null);
    }

    private void threads() {
        this.out.println(Console.getThreadDumps());
    }

    private void memory() {
        this.out.println(Console.getMemory());
    }

    public void println(String string) {
        this.out.println(string);
    }

    private void ban(String command) {
        if (this.server == null || this.server.getServerModel() == null) {
            return;
        }
        IServerMessenger messenger = this.server.getServerModel().getMessenger();
        if (messenger == null) {
            return;
        }
        Set<INode> nodes = this.server.getServerModel().getMessenger().getNodes();
        if (nodes == null) {
            return;
        }
        try {
            String name;
            if (command.length() > 4) {
                name = command.substring(4, command.length());
            } else {
                this.out.println("Input player name to mini-ban: ");
                name = this.in.readLine();
            }
            if (name == null || name.length() < 1) {
                this.out.println("Invalid name");
                return;
            }
            for (INode node : nodes) {
                if (!node.getName().equals(name)) continue;
                String realName = node.getName().split(" ")[0];
                try {
                    messenger.NotifyUsernameMiniBanningOfPlayer(realName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    messenger.NotifyIPMiniBanningOfPlayer(node.getAddress().getHostAddress());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    messenger.NotifyMacMiniBanningOfPlayer(messenger.GetPlayerMac(node.getName()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                messenger.removeConnection(node);
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void save(String command) {
        ServerGame game = this.server.getIGame();
        if (game == null) {
            this.out.println("No Game Currently Running");
            return;
        }
        try {
            String saveName;
            if (command.length() > 5) {
                saveName = command.substring(5, command.length());
            } else {
                this.out.println("Input savegame filename: ");
                saveName = this.in.readLine();
            }
            if (saveName == null || saveName.length() < 2) {
                this.out.println("Invalid save name");
                return;
            }
            if (!saveName.endsWith(".tsvg")) {
                saveName = saveName + ".tsvg";
            }
            SaveGameFileChooser.ensureDefaultDirExists();
            File f = new File(SaveGameFileChooser.DEFAULT_DIRECTORY, saveName);
            try {
                game.saveGame(f);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void stop() {
        block5: {
            ServerGame game = this.server.getIGame();
            if (game == null) {
                this.out.println("No Game Currently Running");
                return;
            }
            this.out.println("Are you sure? (y/f/n) [f = yes + force stop]");
            try {
                String readin = this.in.readLine();
                boolean stop = readin.toLowerCase().startsWith("y");
                boolean forceStop = readin.toLowerCase().startsWith("f");
                if (!stop && !forceStop) break block5;
                SaveGameFileChooser.ensureDefaultDirExists();
                File f = new File(SaveGameFileChooser.DEFAULT_DIRECTORY, SaveGameFileChooser.getAutoSaveFileName());
                try {
                    game.saveGame(f);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                game.stopGame(forceStop);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void quit() {
        this.out.println("Are you sure? (y/n)");
        try {
            if (this.in.readLine().toLowerCase().startsWith("y")) {
                this.m_shutDown = true;
                System.exit(0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void showConnections() {
        if (this.server != null && this.server.getServerModel() != null && this.server.getServerModel().getMessenger() != null) {
            StringBuilder sb = new StringBuilder("Connected: " + this.server.getServerModel().getMessenger().isConnected() + "\n" + "Nodes: \n");
            Set<INode> nodes = this.server.getServerModel().getMessenger().getNodes();
            if (nodes == null) {
                sb.append("  null\n");
            } else {
                for (INode node : nodes) {
                    sb.append("  " + node + "\n");
                }
            }
            this.out.println(sb.toString());
        }
    }

    private void showStatus() {
        String message = "Server Start Date: " + this.startDate;
        if (this.server != null) {
            ServerGame game = this.server.getIGame();
            message = game != null ? message + "\nIs currently running: " + game.isGameSequenceRunning() + "\nIs GameOver: " + game.isGameOver() + "\nGame: " + game.getData().getGameName() + "\nRound: " + game.getData().getSequence().getRound() + "\nPlayers: " + game.getPlayerManager().toString() : message + "\nCurrently Waiting To Start A Game";
        }
        this.out.println(message);
    }

    private void showHelp() {
        this.out.println("Available commands:\n  help - show this message\n  status - show status information\n  connections - show all connected players\n  ban - ban player\n  send - sends a chat message\n  chatmode - toggles the showing of chat messages as they come in\n  chatlog - shows the chat log\n  memory - show memory usage\n  threads - get thread dumps\n  save - saves game to filename\n  stop - saves then stops current game and goes back to waiting\n  quit - quit\n");
    }
}

