/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework;

import games.strategy.engine.chat.ChatPanel;
import games.strategy.engine.framework.AvailableGames;
import games.strategy.engine.framework.HeadlessGameSelectorPanel;
import games.strategy.engine.framework.startup.launcher.ILauncher;
import games.strategy.engine.framework.startup.mc.GameSelectorModel;
import games.strategy.engine.framework.startup.mc.SetupPanelModel;
import games.strategy.engine.framework.startup.ui.ISetupPanel;
import games.strategy.engine.framework.startup.ui.MetaSetupPanel;
import games.strategy.engine.framework.startup.ui.SetupPanel;
import games.strategy.triplea.ui.ErrorHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

class HeadlessServerMainPanel
extends JPanel
implements Observer {
    private static final long serialVersionUID = 1932202117432783020L;
    private JScrollPane m_gameSetupPanelScroll;
    private HeadlessGameSelectorPanel m_gameSelectorPanel;
    private JButton m_playButton;
    private JButton m_quitButton;
    private final GameSelectorModel m_gameSelectorModel;
    private ISetupPanel m_gameSetupPanel;
    private JPanel m_gameSetupPanelHolder;
    private JPanel m_chatPanelHolder;
    private final SetupPanelModel m_gameTypePanelModel;
    private final JPanel m_mainPanel = new JPanel();
    private JSplitPane m_chatSplit;
    private static final Dimension m_initialSize = new Dimension(685, 620);
    private boolean m_isChatShowing;

    public HeadlessServerMainPanel(SetupPanelModel typePanelModel, AvailableGames availableGames) {
        this.m_gameTypePanelModel = typePanelModel;
        this.m_gameSelectorModel = typePanelModel.getGameSelectorModel();
        this.createComponents(availableGames);
        this.layoutComponents();
        this.setupListeners();
        this.setWidgetActivation();
        if (typePanelModel.getPanel() != null) {
            this.setGameSetupPanel(typePanelModel.getPanel());
        }
    }

    JButton getDefaultButton() {
        return this.m_playButton;
    }

    private void createComponents(AvailableGames availableGames) {
        this.m_playButton = new JButton("Play");
        this.m_quitButton = new JButton("Quit");
        this.m_gameSelectorPanel = new HeadlessGameSelectorPanel(this.m_gameSelectorModel, availableGames);
        this.m_gameSelectorPanel.setBorder(new EtchedBorder());
        this.m_gameSetupPanelHolder = new JPanel();
        this.m_gameSetupPanelHolder.setLayout(new BorderLayout());
        this.m_gameSetupPanelScroll = new JScrollPane(this.m_gameSetupPanelHolder);
        this.m_gameSetupPanelScroll.setBorder(BorderFactory.createEmptyBorder());
        this.m_chatPanelHolder = new JPanel();
        this.m_chatPanelHolder.setLayout(new BorderLayout());
        this.m_chatSplit = new JSplitPane();
        this.m_chatSplit.setOrientation(0);
        this.m_chatSplit.setResizeWeight(0.8);
        this.m_chatSplit.setOneTouchExpandable(false);
        this.m_chatSplit.setDividerSize(5);
    }

    private void layoutComponents() {
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setBorder(new EtchedBorder());
        buttonsPanel.setLayout(new FlowLayout(1));
        buttonsPanel.add(this.m_playButton);
        buttonsPanel.add(this.m_quitButton);
        this.setLayout(new BorderLayout());
        this.m_mainPanel.setLayout(new GridBagLayout());
        this.m_mainPanel.setBorder(BorderFactory.createEmptyBorder());
        this.m_gameSetupPanelHolder.setLayout(new BorderLayout());
        this.m_mainPanel.add((Component)this.m_gameSelectorPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.m_mainPanel.add((Component)this.m_gameSetupPanelScroll, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addChat();
        this.add((Component)buttonsPanel, "South");
        this.setPreferredSize(m_initialSize);
    }

    private void addChat() {
        ChatPanel chat;
        this.remove(this.m_mainPanel);
        this.remove(this.m_chatSplit);
        this.m_chatPanelHolder.removeAll();
        if (this.m_gameTypePanelModel != null && this.m_gameTypePanelModel.getPanel() != null && this.m_gameTypePanelModel.getPanel().getChatPanel() != null && this.m_gameTypePanelModel.getPanel().getChatPanel() instanceof ChatPanel) {
            chat = (ChatPanel)this.m_gameTypePanelModel.getPanel().getChatPanel();
            this.m_chatPanelHolder = new JPanel();
            this.m_chatPanelHolder.setLayout(new BorderLayout());
            this.m_chatPanelHolder.add((Component)chat, "Center");
            this.m_chatSplit.setTopComponent(this.m_mainPanel);
            this.m_chatSplit.setBottomComponent(this.m_chatPanelHolder);
            this.add((Component)this.m_chatSplit, "Center");
            this.m_chatPanelHolder.setPreferredSize(new Dimension(this.m_chatPanelHolder.getPreferredSize().width, 62));
        } else {
            chat = null;
            this.add((Component)this.m_mainPanel, "Center");
        }
        this.m_isChatShowing = chat != null;
    }

    public void setGameSetupPanel(ISetupPanel panel) {
        boolean panelHasChat;
        SetupPanel setupPanel = null;
        if (SetupPanel.class.isAssignableFrom(panel.getClass())) {
            setupPanel = (SetupPanel)panel;
        }
        if (this.m_gameSetupPanel != null) {
            this.m_gameSetupPanel.removeObserver(this);
            if (setupPanel != null) {
                this.m_gameSetupPanelHolder.remove(setupPanel);
            }
        }
        this.m_gameSetupPanel = panel;
        this.m_gameSetupPanelHolder.removeAll();
        if (setupPanel != null) {
            this.m_gameSetupPanelHolder.add((Component)setupPanel, "Center");
        }
        panel.addObserver(this);
        this.setWidgetActivation();
        if (!(panel instanceof MetaSetupPanel)) {
            JPanel cancelPanel = new JPanel();
            cancelPanel.setBorder(new EmptyBorder(10, 0, 10, 10));
            cancelPanel.setLayout(new FlowLayout(2));
            this.createUserActionMenu(cancelPanel);
            this.m_gameSetupPanelHolder.add((Component)cancelPanel, "South");
        }
        boolean bl = panelHasChat = this.m_gameTypePanelModel.getPanel().getChatPanel() != null;
        if (panelHasChat != this.m_isChatShowing) {
            this.addChat();
        }
        this.invalidate();
        this.revalidate();
    }

    private void createUserActionMenu(JPanel cancelPanel) {
        if (this.m_gameSetupPanel.getUserActions() == null) {
            return;
        }
        final JButton button = new JButton("Network...");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JPopupMenu menu = new JPopupMenu();
                List<Action> actions = HeadlessServerMainPanel.this.m_gameSetupPanel.getUserActions();
                if (actions != null && !actions.isEmpty()) {
                    for (Action a : actions) {
                        menu.add(a);
                    }
                }
                menu.show(button, 0, button.getHeight());
            }
        });
        cancelPanel.add(button);
    }

    private void setupListeners() {
        this.m_gameTypePanelModel.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                HeadlessServerMainPanel.this.setGameSetupPanel(HeadlessServerMainPanel.this.m_gameTypePanelModel.getPanel());
            }
        });
        this.m_playButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HeadlessServerMainPanel.this.play();
            }
        });
        this.m_quitButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                try {
                    HeadlessServerMainPanel.this.m_gameSetupPanel.shutDown();
                }
                finally {
                    System.exit(0);
                }
            }
        });
        this.m_gameSelectorModel.addObserver(this);
    }

    private void play() {
        ErrorHandler.setGameOver(false);
        System.out.println("Starting Game: " + this.m_gameSelectorModel.getGameData().getGameName() + ", Round: " + this.m_gameSelectorModel.getGameData().getSequence().getRound());
        this.m_gameSetupPanel.preStartGame();
        ILauncher launcher = this.m_gameTypePanelModel.getPanel().getLauncher();
        if (launcher != null) {
            launcher.launch(this);
        }
        this.m_gameSetupPanel.postStartGame();
    }

    private void setWidgetActivation() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    HeadlessServerMainPanel.this.setWidgetActivation();
                }
            });
            return;
        }
        this.m_gameTypePanelModel.setWidgetActivation();
        if (this.m_gameSetupPanel != null) {
            this.m_playButton.setEnabled(this.m_gameSetupPanel.canGameStart());
        } else {
            this.m_playButton.setEnabled(false);
        }
    }

    public void update(Observable o, Object arg) {
        this.setWidgetActivation();
    }
}

