/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework;

import games.strategy.common.player.AbstractHumanPlayer;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.gamePlayer.IGamePlayer;
import java.util.Collections;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalPlayers {
    protected final Set<IGamePlayer> m_localPlayers;

    public LocalPlayers(Set<IGamePlayer> localPlayers) {
        this.m_localPlayers = localPlayers;
    }

    public Set<IGamePlayer> getLocalPlayers() {
        return Collections.unmodifiableSet(this.m_localPlayers);
    }

    public boolean playing(PlayerID id) {
        if (id == null) {
            return false;
        }
        for (IGamePlayer gamePlayer : this.m_localPlayers) {
            if (!gamePlayer.getPlayerID().equals(id) || !AbstractHumanPlayer.class.isAssignableFrom(gamePlayer.getClass())) continue;
            return true;
        }
        return false;
    }
}

