/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework;

import games.strategy.engine.framework.GameRunner;
import games.strategy.engine.framework.GameRunner2;
import games.strategy.util.Version;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessRunnerUtil {
    public static void populateBasicJavaArgs(List<String> commands) {
        ProcessRunnerUtil.populateBasicJavaArgs(commands, System.getProperty("java.class.path"));
    }

    public static void populateBasicJavaArgs(List<String> commands, long maxMemory) {
        ProcessRunnerUtil.populateBasicJavaArgs(commands, System.getProperty("java.class.path"), maxMemory);
    }

    public static void populateBasicJavaArgs(List<String> commands, String newClasspath) {
        long maxMemory = GameRunner2.getMaxMemoryInBytes();
        System.out.println("Setting memory for new triplea process to: " + maxMemory / 0x100000L + "m");
        ProcessRunnerUtil.populateBasicJavaArgs(commands, newClasspath, maxMemory);
    }

    public static void populateBasicJavaArgs(List<String> commands, String classpath, long maxMemory) {
        String version;
        String[] preservedSystemProperties;
        String javaCommand = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        commands.add(javaCommand);
        commands.add("-classpath");
        if (classpath != null && classpath.length() > 0) {
            commands.add(classpath);
        } else {
            commands.add(System.getProperty("java.class.path"));
        }
        commands.add("-Xmx" + maxMemory);
        for (String key : preservedSystemProperties = new String[]{"sun.java2d.noddraw"}) {
            String value;
            if (System.getProperties().getProperty(key) == null || !(value = System.getProperties().getProperty(key)).matches("[a-zA-Z0-9.]+")) continue;
            commands.add("-D" + key + "=" + value);
        }
        if (GameRunner.isMac()) {
            commands.add("-Dapple.laf.useScreenMenuBar=true");
            commands.add("-Xdock:name=\"TripleA\"");
            File icons = new File(GameRunner2.getRootFolder(), "icons/triplea_icon.png");
            if (!icons.exists()) {
                throw new IllegalStateException("Icon file not found");
            }
            commands.add("-Xdock:icon=" + icons.getAbsolutePath() + "");
        }
        if ((version = System.getProperty("triplea.engine.version.bin")) != null && version.length() > 0) {
            try {
                Version testVersion = new Version(version);
                commands.add("-Dtriplea.engine.version.bin=" + testVersion.toString());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        commands.add("-Dtriplea.memory.set=" + Boolean.TRUE.toString());
    }

    public static void exec(List<String> commands) {
        ProcessBuilder builder = new ProcessBuilder(commands);
        builder.redirectErrorStream(true);
        try {
            Process p = builder.start();
            final InputStream s = p.getInputStream();
            Thread t = new Thread(new Runnable(){

                public void run() {
                    try {
                        while (s.read() >= 0) {
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }, "Process ouput gobbler");
            t.setDaemon(true);
            t.start();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void main(String[] args) {
        int mb = 0x100000;
        Runtime runtime = Runtime.getRuntime();
        System.out.println("Heap utilization statistics [MB]");
        System.out.println("Used Memory:" + (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L);
        System.out.println("Free Memory:" + runtime.freeMemory() / 0x100000L);
        System.out.println("Total Memory:" + runtime.totalMemory() / 0x100000L);
        System.out.println("Max Memory:" + runtime.maxMemory() / 0x100000L);
        ArrayList<String> commands = new ArrayList<String>();
        ProcessRunnerUtil.populateBasicJavaArgs(commands);
        String javaClass = "util.image.MapCreator";
        commands.add("util.image.MapCreator");
        System.out.println("Testing ProcessRunnerUtil");
        System.out.println(commands);
        final CountDownLatch latch = new CountDownLatch(1);
        ProcessBuilder builder = new ProcessBuilder(commands);
        builder.redirectErrorStream(true);
        Thread t = null;
        try {
            Process p = builder.start();
            final InputStream s = p.getInputStream();
            t = new Thread(new Runnable(){

                public void run() {
                    System.out.println("Gobbling intput/output");
                    try {
                        int read;
                        do {
                            read = s.read();
                            System.out.println(read);
                        } while (read >= 0);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    System.out.println("Finished Gobbling");
                    latch.countDown();
                }
            }, "Process ouput gobbler");
            t.setDaemon(true);
            t.start();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("Finished");
    }
}

