/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework;

import games.strategy.engine.EngineVersion;
import games.strategy.engine.framework.GameRunner2;
import games.strategy.engine.framework.ProcessRunnerUtil;
import games.strategy.engine.lobby.server.GameDescription;
import games.strategy.net.Messengers;
import games.strategy.util.Version;
import java.awt.Container;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JOptionPane;

public class TripleAProcessRunner {
    public static void startNewTripleA(Long maxMemory) {
        TripleAProcessRunner.startGame(System.getProperty("triplea.game"), null, maxMemory);
    }

    public static void startGame(String savegamePath, String classpath, Long maxMemory) {
        ArrayList<String> commands = new ArrayList<String>();
        if (maxMemory != null && maxMemory > 0x2000000L) {
            ProcessRunnerUtil.populateBasicJavaArgs(commands, classpath, maxMemory);
        } else {
            ProcessRunnerUtil.populateBasicJavaArgs(commands, classpath);
        }
        if (savegamePath != null && savegamePath.length() > 0) {
            commands.add("-Dtriplea.game=" + savegamePath);
        }
        for (String property : GameRunner2.getProperties()) {
            String oldValue;
            if ("triplea.game".equals(property) || "triplea.engine.version.bin".equals(property)) continue;
            String value = System.getProperty(property);
            if (value != null) {
                commands.add("-D" + property + "=" + value);
                continue;
            }
            if (!"triplea.lobby.host".equals(property) && !"triplea.lobby.port".equals(property) && !"triplea.lobby.game.hostedBy".equals(property) || (oldValue = System.getProperty(property + ".old")) == null) continue;
            commands.add("-D" + property + "=" + oldValue);
        }
        String javaClass = "games.strategy.engine.framework.GameRunner";
        commands.add("games.strategy.engine.framework.GameRunner");
        ProcessRunnerUtil.exec(commands);
    }

    public static void hostGame(int port, String playerName, String comments, String password, Messengers messengers) {
        String fileName;
        ArrayList<String> commands = new ArrayList<String>();
        ProcessRunnerUtil.populateBasicJavaArgs(commands);
        commands.add("-Dtriplea.server=true");
        commands.add("-Dtriplea.port=" + port);
        commands.add("-Dtriplea.name=" + playerName);
        commands.add("-Dtriplea.lobby.host=" + messengers.getMessenger().getRemoteServerSocketAddress().getAddress().getHostAddress());
        commands.add("-Dtriplea.lobby.port=" + messengers.getMessenger().getRemoteServerSocketAddress().getPort());
        commands.add("-Dtriplea.lobby.game.comments=" + comments);
        commands.add("-Dtriplea.lobby.game.hostedBy=" + messengers.getMessenger().getLocalNode().getName());
        if (password != null && password.length() > 0) {
            commands.add("-Dtriplea.server.password=" + password);
        }
        if ((fileName = System.getProperty("triplea.game", "")).length() > 0) {
            commands.add("-Dtriplea.game=" + fileName);
        }
        String javaClass = "games.strategy.engine.framework.GameRunner";
        commands.add("games.strategy.engine.framework.GameRunner");
        ProcessRunnerUtil.exec(commands);
    }

    public static void joinGame(GameDescription description, Messengers messengers, Container parent) {
        GameDescription.GameStatus status = description.getStatus();
        if (GameDescription.GameStatus.LAUNCHING.equals((Object)status)) {
            return;
        }
        Version engineVersionOfGameToJoin = new Version(description.getEngineVersion());
        String newClassPath = null;
        if (!EngineVersion.VERSION.equals(engineVersionOfGameToJoin)) {
            try {
                newClassPath = TripleAProcessRunner.findOldJar(engineVersionOfGameToJoin, false);
            }
            catch (Exception e) {
                if (GameRunner2.areWeOldExtraJar()) {
                    JOptionPane.showMessageDialog(parent, "<html>Please run the default TripleA and try joining the online lobby for it instead. <br>This TripleA engine is old and kept only for backwards compatibility and can only play with people using the exact same version as this one. <br><br>Host is using a different engine than you, and can not find correct engine: " + engineVersionOfGameToJoin.toStringFull("_") + "</html>", "Correct TripleA Engine Not Found", 2);
                } else {
                    JOptionPane.showMessageDialog(parent, "Host is using a different engine than you, and can not find correct engine: " + engineVersionOfGameToJoin.toStringFull("_"), "Correct TripleA Engine Not Found", 2);
                }
                return;
            }
            String messageString = "<html>This TripleA engine is version " + EngineVersion.VERSION.toString() + " and you are trying to join a game made with version " + engineVersionOfGameToJoin.toString() + "<br>However, this TripleA can only play with engines that are the exact same version as itself (x_x_x_x)." + "<br><br>TripleA now comes with older engines included with it, and has found the engine used by the host. This is a new feature and is in 'beta' stage." + "<br>It will attempt to run a new instance of TripleA using the older engine jar file, and this instance will join the host's game." + "<br>Your current instance will not be closed. Please report any bugs or issues." + "<br><br>Do you wish to continue?</html>";
            int answer = JOptionPane.showConfirmDialog(null, messageString, "Run old jar to join hosted game?", 0);
            if (answer != 0) {
                return;
            }
        }
        TripleAProcessRunner.joinGame(description.getPort(), description.getHostedBy().getAddress().getHostAddress(), newClassPath, messengers);
    }

    public static void joinGame(int port, String hostAddressIP, String newClassPath, Messengers messengers) {
        ArrayList<String> commands = new ArrayList<String>();
        ProcessRunnerUtil.populateBasicJavaArgs(commands, newClassPath);
        commands.add("-Dtriplea.client=true");
        commands.add("-Dtriplea.port=" + port);
        commands.add("-Dtriplea.host=" + hostAddressIP);
        commands.add("-Dtriplea.name=" + messengers.getMessenger().getLocalNode().getName());
        String javaClass = "games.strategy.engine.framework.GameRunner";
        commands.add("games.strategy.engine.framework.GameRunner");
        ProcessRunnerUtil.exec(commands);
    }

    public static String findOldJar(Version oldVersionNeeded, boolean ignoreMicro) throws IOException {
        String version;
        if (EngineVersion.VERSION.equals(oldVersionNeeded, ignoreMicro)) {
            return System.getProperty("java.class.path");
        }
        if (GameRunner2.areWeOldExtraJar() && (version = System.getProperty("triplea.engine.version.bin")) != null && version.length() > 0) {
            Version defaultVersion = null;
            try {
                defaultVersion = new Version(version);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (defaultVersion != null && defaultVersion.equals(oldVersionNeeded, ignoreMicro)) {
                String jarName = "triplea.jar";
                File binFolder = new File(GameRunner2.getRootFolder(), "bin/");
                if (!binFolder.exists()) {
                    binFolder = new File(GameRunner2.getRootFolder(), "Java/");
                }
                if (binFolder.exists()) {
                    File[] files = binFolder.listFiles();
                    if (files == null) {
                        throw new IOException("Can not find 'bin' engine jars folder");
                    }
                    File ourBinJar = null;
                    for (File f : Arrays.asList(files)) {
                        String jarPath;
                        if (!f.exists() || (jarPath = f.getCanonicalPath()).indexOf("triplea.jar") == -1) continue;
                        ourBinJar = f;
                        break;
                    }
                    if (ourBinJar == null) {
                        throw new IOException("Can not find 'bin' engine jar for version: " + oldVersionNeeded.toStringFull("_"));
                    }
                    String newClassPath = ourBinJar.getCanonicalPath();
                    if (newClassPath == null || newClassPath.length() <= 0) {
                        throw new IOException("Can not find 'bin' engine jar for version: " + oldVersionNeeded.toStringFull("_"));
                    }
                    return newClassPath;
                }
                System.err.println("Can not find 'bin' or 'Java' folder, where main triplea.jar should be.");
            }
        }
        String jarName = "triplea_" + oldVersionNeeded.toStringFull("_", ignoreMicro);
        File oldJarsFolder = new File(GameRunner2.getRootFolder(), "old/");
        if (!oldJarsFolder.exists()) {
            throw new IOException("Can not find 'old' engine jars folder");
        }
        File[] files = oldJarsFolder.listFiles();
        if (files == null) {
            throw new IOException("Can not find 'old' engine jars folder");
        }
        File ourOldJar = null;
        for (File f : Arrays.asList(files)) {
            String name;
            if (!f.exists() || (name = f.getName()).indexOf(jarName) == -1 || name.indexOf(".jar") == -1) continue;
            ourOldJar = f;
            break;
        }
        if (ourOldJar == null) {
            throw new IOException("Can not find 'old' engine jar for version: " + oldVersionNeeded.toStringFull("_"));
        }
        String newClassPath = ourOldJar.getCanonicalPath();
        if (newClassPath == null || newClassPath.length() <= 0) {
            throw new IOException("Can not find 'old' engine jar for version: " + oldVersionNeeded.toStringFull("_"));
        }
        return newClassPath;
    }
}

