/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.mapDownload;

import games.strategy.engine.framework.mapDownload.DownloadFileDescription;
import games.strategy.util.Version;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadFileParser {
    public List<DownloadFileDescription> parse(InputStream is, final String hostedUrl) {
        final ArrayList<DownloadFileDescription> rVal = new ArrayList<DownloadFileDescription>();
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(new InputSource(is), new DefaultHandler(){
                private StringBuilder content = new StringBuilder();
                private String url;
                private String description;
                private String mapName;
                private Version version;

                public void characters(char[] ch, int start, int length) throws SAXException {
                    this.content.append(ch, start, length);
                }

                public void endElement(String uri, String localName, String qName) throws SAXException {
                    String elementName = qName;
                    if (elementName.equals("description")) {
                        this.description = this.content.toString().trim();
                    } else if (elementName.equals("url")) {
                        this.url = this.content.toString().trim();
                    } else if (elementName.equals("mapName")) {
                        this.mapName = this.content.toString().trim();
                    } else if (elementName.equals("version")) {
                        this.version = new Version(this.content.toString().trim());
                    } else if (elementName.equals("game")) {
                        rVal.add(new DownloadFileDescription(this.url, this.description, this.mapName, this.version, hostedUrl));
                        this.version = null;
                    } else if (!elementName.equals("games")) {
                        throw new IllegalStateException("unexpected tag:" + elementName);
                    }
                    this.content = new StringBuilder();
                }
            });
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (SAXParseException e) {
            throw new IllegalStateException("Could not parse xml error at line:" + e.getLineNumber() + " column:" + e.getColumnNumber() + " error:" + e.getMessage());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.validate(rVal);
        return rVal;
    }

    private void validate(List<DownloadFileDescription> downloads) {
        HashSet<String> urls = new HashSet<String>();
        HashSet<String> names = new HashSet<String>();
        for (DownloadFileDescription d : downloads) {
            if (this.isEmpty(d.getUrl())) {
                throw new IllegalStateException("Missing game url");
            }
            if (d.isDummyUrl()) continue;
            if (this.isEmpty(d.getDescription())) {
                throw new IllegalStateException("Missing game description");
            }
            if (this.isEmpty(d.getMapName())) {
                throw new IllegalStateException("Missing map name");
            }
            if (!names.add(d.getMapName())) {
                throw new IllegalStateException("duplicate mapName:" + d.getMapName());
            }
            if (!urls.add(d.getUrl())) {
                throw new IllegalStateException("duplicate url:" + d.getUrl());
            }
            try {
                URL url = new URL(d.getUrl());
                if (url.getProtocol().toLowerCase(Locale.ENGLISH).startsWith("http")) continue;
                throw new IllegalStateException("Url must start with http:" + url);
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }
}

