/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.mapDownload;

import games.strategy.engine.EngineVersion;
import games.strategy.engine.framework.mapDownload.DownloadFileDescription;
import games.strategy.util.Version;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;

class DownloadFileProperties {
    private static final String VERSION = "map.version";
    private final Properties props = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DownloadFileProperties loadForZip(File zipFile) {
        if (!DownloadFileProperties.fromZip(zipFile).exists()) {
            return new DownloadFileProperties();
        }
        DownloadFileProperties rVal = new DownloadFileProperties();
        try {
            FileInputStream fis = new FileInputStream(DownloadFileProperties.fromZip(zipFile));
            try {
                rVal.props.load(fis);
            }
            finally {
                fis.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
        return rVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveForZip(File zipFile, DownloadFileProperties props) {
        try {
            FileOutputStream fos = new FileOutputStream(DownloadFileProperties.fromZip(zipFile));
            try {
                props.props.store(fos, null);
            }
            finally {
                fos.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
    }

    private static File fromZip(File zipFile) {
        return new File(zipFile.getParent(), zipFile.getName() + ".properties");
    }

    public Version getVersion() {
        if (!this.props.containsKey(VERSION)) {
            return null;
        }
        return new Version(this.props.getProperty(VERSION));
    }

    private void setVersion(Version v) {
        if (v != null) {
            this.props.put(VERSION, v.toString());
        }
    }

    public void setFrom(DownloadFileDescription selected) {
        this.setVersion(selected.getVersion());
        this.props.setProperty("map.url", selected.getUrl());
        this.props.setProperty("download.time", new Date().toString());
        this.props.setProperty("download.hostedBy", selected.getHostedUrl());
        this.props.setProperty("engine.version", EngineVersion.VERSION.toString());
    }
}

