/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.mapDownload;

import games.strategy.engine.framework.GameRunner2;
import games.strategy.engine.framework.mapDownload.DownloadFileDescription;
import games.strategy.engine.framework.mapDownload.DownloadFileProperties;
import games.strategy.engine.framework.mapDownload.DownloadRunnable;
import games.strategy.engine.framework.startup.mc.GameSelectorModel;
import games.strategy.engine.framework.ui.background.BackgroundTaskRunner;
import games.strategy.ui.Util;
import games.strategy.util.CountDownLatchHandler;
import games.strategy.util.EventThreadJOptionPane;
import games.strategy.util.Version;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallMapDialog
extends JDialog {
    private static final long serialVersionUID = -1542210716764178580L;
    private static final String DOWNLOAD_URL_PREFIX = "Location: ";
    private static final String MAP_VERSION_PREFIX = "New Version: ";
    private JButton m_installButton;
    private JButton m_cancelButton;
    private JLabel m_intro;
    private final List<DownloadFileDescription> m_games;
    private JList m_gamesList;
    private JEditorPane m_descriptionPane;
    private JLabel m_urlLabel;
    private JLabel m_mapVersion;
    private final List<String> m_outOfDateMaps = new ArrayList<String>();

    private InstallMapDialog(Frame owner, List<DownloadFileDescription> games) {
        super(owner, "Select game to install", true);
        this.m_games = games;
        this.createComponents();
        this.layoutCoponents();
        this.setupListeners();
        this.setWidgetActivation();
        this.informUserOfOutOfDateMaps(owner);
    }

    private void informUserOfOutOfDateMaps(Frame owner) {
        if (!this.m_outOfDateMaps.isEmpty()) {
            StringBuilder text = new StringBuilder("<html>Some of the maps you have are out of date, and newer versions of those maps exist.<br>You should update (re-download) the following maps:<br><ul>");
            for (String map : this.m_outOfDateMaps) {
                text.append("<li> " + map + "</li>");
            }
            text.append("</ul></html>");
            JOptionPane.showMessageDialog(owner, text, "Update Your Maps", 1);
        }
    }

    public static void populateOutOfDateMapsListing(Collection<String> listingToBeAddedTo, Collection<DownloadFileDescription> gamesDownloadFileDescriptions) {
        if (listingToBeAddedTo == null) {
            return;
        }
        listingToBeAddedTo.clear();
        for (DownloadFileDescription d : gamesDownloadFileDescriptions) {
            if (d == null || d.isDummyUrl()) continue;
            File installed = new File(GameRunner2.getUserMapsFolder(), d.getMapName() + ".zip");
            if (installed == null || !installed.exists()) {
                installed = new File(GameSelectorModel.DEFAULT_MAP_DIRECTORY, d.getMapName() + ".zip");
            }
            if (installed == null || !installed.exists() || d.getVersion() == null || !d.getVersion().isGreaterThan(InstallMapDialog.getVersion(installed), true)) continue;
            listingToBeAddedTo.add(d.getMapName());
        }
    }

    private void createComponents() {
        this.m_installButton = new JButton("Install Games");
        this.m_cancelButton = new JButton("Cancel");
        this.m_intro = new JLabel("<html>Click on any number of maps on the left side, then click 'Install' at the bottom to download them. <br />Hold down CTRL to select more than one. <br />Red and Bold means your map is out of date. Italics means your map is up-to-date. </html>");
        this.m_intro.setHorizontalAlignment(0);
        Vector<String> gameNames = new Vector<String>();
        final LinkedHashMap<String, DownloadFileDescription> gameMap = new LinkedHashMap<String, DownloadFileDescription>();
        this.m_outOfDateMaps.clear();
        for (DownloadFileDescription d : this.m_games) {
            gameMap.put(d.getMapName(), d);
            gameNames.add(d.getMapName());
            if (d == null || d.isDummyUrl()) continue;
            File installed = new File(GameRunner2.getUserMapsFolder(), d.getMapName() + ".zip");
            if (installed == null || !installed.exists()) {
                installed = new File(GameSelectorModel.DEFAULT_MAP_DIRECTORY, d.getMapName() + ".zip");
            }
            if (installed == null || !installed.exists() || d.getVersion() == null || !d.getVersion().isGreaterThan(InstallMapDialog.getVersion(installed), true)) continue;
            this.m_outOfDateMaps.add(d.getMapName());
        }
        this.m_gamesList = new JList(gameNames);
        this.m_gamesList.setSelectedIndex(0);
        final ListCellRenderer oldRenderer = this.m_gamesList.getCellRenderer();
        this.m_gamesList.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String mapName = (String)value;
                if (mapName.trim().length() == 0) {
                    mapName = " ";
                } else {
                    DownloadFileDescription description = (DownloadFileDescription)gameMap.get(mapName);
                    if (!description.isDummyUrl()) {
                        File installed = new File(GameRunner2.getUserMapsFolder(), mapName + ".zip");
                        if (installed == null || !installed.exists()) {
                            installed = new File(GameSelectorModel.DEFAULT_MAP_DIRECTORY, mapName + ".zip");
                        }
                        if (installed != null && installed.exists()) {
                            mapName = description.getVersion() != null && description.getVersion().isGreaterThan(InstallMapDialog.getVersion(installed), true) ? "<html><b><font color=\"red\">" + mapName + "</font></b></html>" : "<html><i>" + mapName + "</i></html>";
                        }
                    }
                }
                return oldRenderer.getListCellRendererComponent(list, mapName, index, isSelected, cellHasFocus);
            }
        });
        this.m_descriptionPane = new JEditorPane();
        this.m_descriptionPane.setEditable(false);
        this.m_descriptionPane.setContentType("text/html");
        this.m_descriptionPane.setBackground(new JLabel().getBackground());
        this.m_urlLabel = new JLabel(DOWNLOAD_URL_PREFIX);
        this.m_mapVersion = new JLabel(MAP_VERSION_PREFIX);
    }

    private void layoutCoponents() {
        this.setLayout(new BorderLayout());
        JPanel buttonsPanel = new JPanel();
        this.add((Component)this.m_intro, "North");
        this.add((Component)buttonsPanel, "South");
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        buttonsPanel.add(Box.createGlue());
        buttonsPanel.add(this.m_cancelButton);
        buttonsPanel.add(this.m_installButton);
        buttonsPanel.add(Box.createGlue());
        buttonsPanel.setBorder(new EmptyBorder(20, 20, 20, 20));
        JScrollPane descriptionScroll = new JScrollPane();
        descriptionScroll.setViewportView(this.m_descriptionPane);
        descriptionScroll.setBorder(null);
        descriptionScroll.getViewport().setBorder(null);
        JScrollPane gamesScroll = new JScrollPane();
        gamesScroll.setViewportView(this.m_gamesList);
        gamesScroll.setBorder(null);
        gamesScroll.getViewport().setBorder(null);
        JPanel main = new JPanel();
        main.setBorder(new EmptyBorder(30, 30, 30, 30));
        main.setLayout(new BorderLayout());
        main.add((Component)gamesScroll, "West");
        main.add((Component)descriptionScroll, "Center");
        JPanel extraPanel = new JPanel();
        extraPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        extraPanel.setLayout(new BorderLayout());
        extraPanel.add((Component)this.m_urlLabel, "North");
        extraPanel.add((Component)this.m_mapVersion, "South");
        main.add((Component)extraPanel, "South");
        this.add((Component)main, "Center");
    }

    private void setupListeners() {
        this.m_cancelButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -2437255215905705911L;

            public void actionPerformed(ActionEvent e) {
                InstallMapDialog.this.setVisible(false);
            }
        });
        this.m_installButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -2202445889252381183L;

            public void actionPerformed(ActionEvent event) {
                boolean installed = false;
                List selected = InstallMapDialog.this.getSelected();
                ArrayList<DownloadFileDescription> toDownload = new ArrayList<DownloadFileDescription>();
                for (DownloadFileDescription map : selected) {
                    if (map.isDummyUrl()) continue;
                    File destination = new File(GameRunner2.getUserMapsFolder(), map.getMapName() + ".zip");
                    if (destination.exists()) {
                        String msg = "<html>Replace map: " + map.getMapName() + " ?" + "<br>You have version " + InstallMapDialog.getVersionString(InstallMapDialog.getVersion(destination)) + " installed, replace with version " + InstallMapDialog.getVersionString(map.getVersion()) + "?</html>";
                        if (!InstallMapDialog.this.replaceOldQuestion(msg)) continue;
                        toDownload.add(map);
                        continue;
                    }
                    toDownload.add(map);
                }
                int i = 1;
                for (DownloadFileDescription map : toDownload) {
                    if (map.isDummyUrl()) continue;
                    InstallMapDialog.this.install(map, i++, toDownload.size());
                    installed = true;
                }
                if (installed) {
                    EventThreadJOptionPane.showMessageDialog(InstallMapDialog.this.getRootPane(), (Object)((toDownload.size() > 1 ? "Maps" : "Map") + " successfully installed, please restart TripleA before playing"), new CountDownLatchHandler(true));
                    InstallMapDialog.this.setVisible(false);
                }
            }
        });
        this.m_gamesList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                InstallMapDialog.this.setWidgetActivation();
            }
        });
    }

    private boolean replaceOldQuestion(String message) {
        int rVal = EventThreadJOptionPane.showConfirmDialog(this, message, "Overwrite?", 0, new CountDownLatchHandler(true));
        return rVal == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void install(DownloadFileDescription selected, int count, int total) {
        File destination = new File(GameRunner2.getUserMapsFolder(), selected.getMapName() + ".zip");
        if (!destination.exists() || !destination.delete()) {
            // empty if block
        }
        File tempFile = new File(System.getProperty("java.io.tmpdir"), "tadownload:" + UUID.randomUUID().toString());
        tempFile.deleteOnExit();
        DownloadRunnable download = new DownloadRunnable(selected.getUrl());
        String message = "Downloading" + (total > 1 ? " (" + count + " of " + total + "): " : ": ") + selected.getMapName();
        BackgroundTaskRunner.runInBackground(this.getRootPane(), message, download);
        if (download.getError() != null) {
            Util.notifyError(this, download.getError());
            return;
        }
        FileOutputStream sink = null;
        try {
            this.validateZip(download);
            sink = new FileOutputStream(tempFile);
            sink.write(download.getContents());
            sink.getFD().sync();
            DownloadFileProperties props = new DownloadFileProperties();
            props.setFrom(selected);
            DownloadFileProperties.saveForZip(destination, props);
        }
        catch (IOException e) {
            Util.notifyError(this, "Could not create write to temp file:" + e.getMessage());
            return;
        }
        finally {
            if (sink != null) {
                try {
                    sink.close();
                }
                catch (IOException e) {}
            }
        }
        try {
            ZipInputStream zis = new ZipInputStream(new FileInputStream(tempFile));
            try {
                while (zis.getNextEntry() != null) {
                    zis.read(new byte[128]);
                }
            }
            finally {
                zis.close();
            }
        }
        catch (IOException e) {
            Util.notifyError(this, "Invalid zip file:" + e.getMessage());
            return;
        }
        if (!tempFile.renameTo(destination)) {
            try {
                FileInputStream source = new FileInputStream(tempFile);
                try {
                    FileOutputStream destSink = new FileOutputStream(destination);
                    try {
                        InstallMapDialog.copy(destSink, source);
                        destSink.getFD().sync();
                    }
                    finally {
                        destSink.close();
                    }
                }
                finally {
                    source.close();
                    tempFile.delete();
                }
            }
            catch (IOException e) {
                Util.notifyError(this, e.getMessage());
                return;
            }
        }
    }

    private void validateZip(DownloadRunnable download) throws IOException {
        try {
            ZipEntry ze;
            ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(download.getContents()));
            while ((ze = zis.getNextEntry()) != null) {
                ze.getSize();
                zis.read(new byte[512]);
            }
        }
        catch (Exception e) {
            throw new IOException("zip file could not be opened, it may have been corrupted during the download, please try again");
        }
    }

    public static void copy(OutputStream sink, InputStream is) throws IOException {
        int read;
        byte[] b = new byte[8192];
        while ((read = is.read(b)) != -1) {
            sink.write(b, 0, read);
        }
    }

    private void setWidgetActivation() {
        if (this.m_gamesList.isSelectionEmpty()) {
            this.m_installButton.setEnabled(false);
            this.m_descriptionPane.setText("");
            this.m_urlLabel.setText(DOWNLOAD_URL_PREFIX);
            this.m_mapVersion.setText(MAP_VERSION_PREFIX);
        } else {
            for (DownloadFileDescription map : this.getSelected()) {
                this.m_installButton.setEnabled(!map.isDummyUrl());
                this.m_descriptionPane.setText(map.getDescription());
                if (map.isDummyUrl()) continue;
                this.m_urlLabel.setText(DOWNLOAD_URL_PREFIX + map.getUrl());
                String currentVersion = "";
                File destination = new File(GameRunner2.getUserMapsFolder(), map.getMapName() + ".zip");
                if (destination.exists()) {
                    currentVersion = "   (installed version: " + InstallMapDialog.getVersionString(InstallMapDialog.getVersion(destination)) + ")";
                }
                this.m_mapVersion.setText(MAP_VERSION_PREFIX + InstallMapDialog.getVersionString(map.getVersion()) + currentVersion);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        InstallMapDialog.this.m_descriptionPane.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
                    }
                });
                break;
            }
        }
    }

    private List<DownloadFileDescription> getSelected() {
        ArrayList<DownloadFileDescription> selected = new ArrayList<DownloadFileDescription>();
        for (DownloadFileDescription d : this.m_games) {
            List<Object> values = Arrays.asList(this.m_gamesList.getSelectedValues());
            if (!values.contains(d.getMapName())) continue;
            selected.add(d);
        }
        return selected;
    }

    public static void installGames(Component parent, List<DownloadFileDescription> games) {
        Frame parentFrame = JOptionPane.getFrameForComponent(parent);
        InstallMapDialog dia = new InstallMapDialog(parentFrame, games);
        dia.setSize(800, 620);
        dia.setLocationRelativeTo(parentFrame);
        dia.setVisible(true);
    }

    private static String getVersionString(Version v) {
        if (v == null) {
            return "Unknown";
        }
        return v.toString();
    }

    private static Version getVersion(File zipFile) {
        DownloadFileProperties props = DownloadFileProperties.loadForZip(zipFile);
        return props.getVersion();
    }
}

