/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.networkMaintenance;

import games.strategy.engine.data.properties.GameProperties;
import games.strategy.engine.data.properties.IEditableProperty;
import games.strategy.engine.data.properties.PropertiesUI;
import games.strategy.engine.framework.startup.mc.IServerStartupRemote;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class ChangeGameOptionsClientAction
extends AbstractAction {
    private static final long serialVersionUID = -6419002646689952824L;
    private final Component m_parent;
    private final IServerStartupRemote m_serverRemote;

    public ChangeGameOptionsClientAction(Component parent, IServerStartupRemote serverRemote) {
        super("Edit Game Options...");
        this.m_parent = JOptionPane.getFrameForComponent(parent);
        this.m_serverRemote = serverRemote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        byte[] oldBytes = this.m_serverRemote.getGameOptions();
        if (oldBytes == null || oldBytes.length == 0) {
            return;
        }
        try {
            List<IEditableProperty> properties = GameProperties.streamToIEditablePropertiesList(oldBytes);
            PropertiesUI pui = new PropertiesUI(properties, true);
            JScrollPane scroll = new JScrollPane(pui);
            scroll.setBorder(null);
            scroll.getViewport().setBorder(null);
            JOptionPane pane = new JOptionPane(scroll, -1);
            String ok = "OK";
            String cancel = "Cancel";
            pane.setOptions(new Object[]{"OK", "Cancel"});
            JDialog window = pane.createDialog(JOptionPane.getFrameForComponent(this.m_parent), "Game Options");
            window.setVisible(true);
            Object buttonPressed = pane.getValue();
            if (buttonPressed == null || buttonPressed.equals("Cancel")) {
                return;
            }
            ByteArrayOutputStream sink = new ByteArrayOutputStream(1000);
            byte[] newBytes = null;
            try {
                GameProperties.toOutputStream(sink, properties);
                newBytes = sink.toByteArray();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            finally {
                try {
                    sink.close();
                }
                catch (IOException e2) {}
            }
            if (newBytes != null) {
                this.m_serverRemote.changeToGameOptions(newBytes);
            }
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
            return;
        }
        catch (ClassCastException e1) {
            e1.printStackTrace();
            return;
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return;
        }
    }
}

