/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.networkMaintenance;

import games.strategy.common.ui.InGameLobbyWatcherWrapper;
import games.strategy.engine.framework.startup.login.ClientLoginValidator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class SetPasswordAction
extends AbstractAction {
    private static final long serialVersionUID = -7767288210554177480L;
    private final ClientLoginValidator m_validator;
    private final Component m_parent;
    private final InGameLobbyWatcherWrapper m_lobbyWatcher;

    public SetPasswordAction(Component parent, InGameLobbyWatcherWrapper watcher, ClientLoginValidator validator) {
        super("Set Game Password...");
        this.m_validator = validator;
        this.m_parent = parent;
        this.m_lobbyWatcher = watcher;
    }

    public void actionPerformed(ActionEvent e) {
        boolean passworded;
        JLabel label = new JLabel("Enter Password, (Leave blank for no password).");
        JPasswordField passwordField = new JPasswordField();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)label, "North");
        panel.add((Component)passwordField, "Center");
        int rVal = JOptionPane.showOptionDialog(JOptionPane.getFrameForComponent(this.m_parent), panel, "Enter Password", 2, -1, null, null, null);
        if (rVal != 0) {
            return;
        }
        String password = new String(passwordField.getPassword());
        if (password.trim().length() > 0) {
            this.m_validator.setGamePassword(password);
            passworded = true;
        } else {
            this.m_validator.setGamePassword(null);
            passworded = false;
        }
        if (this.m_lobbyWatcher != null && this.m_lobbyWatcher.isActive()) {
            this.m_lobbyWatcher.setPassworded(passworded);
        }
    }
}

