/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.launcher;

import games.strategy.engine.data.GameData;
import games.strategy.engine.framework.startup.launcher.ILauncher;
import games.strategy.engine.framework.startup.mc.GameSelectorModel;
import games.strategy.engine.framework.ui.NewGameChooser;
import games.strategy.engine.framework.ui.background.WaitWindow;
import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public abstract class AbstractLauncher
implements ILauncher {
    protected final GameData m_gameData;
    protected final GameSelectorModel m_gameSelectorModel;
    protected final WaitWindow m_gameLoadingWindow;
    protected final boolean m_headless;

    protected AbstractLauncher(GameSelectorModel gameSelectorModel) {
        this(gameSelectorModel, false);
    }

    protected AbstractLauncher(GameSelectorModel gameSelectorModel, boolean headless) {
        this.m_headless = headless;
        this.m_gameLoadingWindow = this.m_headless ? null : new WaitWindow("Loading game, please wait.");
        this.m_gameSelectorModel = gameSelectorModel;
        this.m_gameData = gameSelectorModel.getGameData();
    }

    public void launch(final Component parent) {
        if (!this.m_headless && !SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Wrong thread");
        }
        Runnable r = new Runnable(){

            public void run() {
                NewGameChooser.clearNewGameChooserModel();
                AbstractLauncher.this.launchInNewThread(parent);
            }
        };
        Thread t = new Thread(r, "Triplea start thread");
        if (!this.m_headless && this.m_gameLoadingWindow != null) {
            this.m_gameLoadingWindow.setLocationRelativeTo(JOptionPane.getFrameForComponent(parent));
            this.m_gameLoadingWindow.setVisible(true);
            this.m_gameLoadingWindow.showWait();
        }
        if (parent != null) {
            JOptionPane.getFrameForComponent(parent).setVisible(false);
        }
        t.start();
    }

    protected abstract void launchInNewThread(Component var1);
}

