/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.mc;

import games.strategy.engine.chat.Chat;
import games.strategy.engine.chat.ChatController;
import games.strategy.engine.chat.ChatPanel;
import games.strategy.engine.chat.HeadlessChat;
import games.strategy.engine.chat.IChatPanel;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.properties.GameProperties;
import games.strategy.engine.data.properties.IEditableProperty;
import games.strategy.engine.framework.GameDataManager;
import games.strategy.engine.framework.GameObjectStreamFactory;
import games.strategy.engine.framework.HeadlessGameServer;
import games.strategy.engine.framework.message.PlayerListing;
import games.strategy.engine.framework.startup.launcher.ILauncher;
import games.strategy.engine.framework.startup.launcher.ServerLauncher;
import games.strategy.engine.framework.startup.login.ClientLoginValidator;
import games.strategy.engine.framework.startup.mc.GameSelectorModel;
import games.strategy.engine.framework.startup.mc.IClientChannel;
import games.strategy.engine.framework.startup.mc.IObserverWaitingToJoin;
import games.strategy.engine.framework.startup.mc.IRemoteModelListener;
import games.strategy.engine.framework.startup.mc.IServerStartupRemote;
import games.strategy.engine.framework.startup.mc.ServerProps;
import games.strategy.engine.framework.startup.mc.SetupPanelModel;
import games.strategy.engine.framework.startup.ui.ServerOptions;
import games.strategy.engine.framework.ui.SaveGameFileChooser;
import games.strategy.engine.lobby.server.NullModeratorController;
import games.strategy.engine.message.ChannelMessenger;
import games.strategy.engine.message.IChannelMessenger;
import games.strategy.engine.message.IRemoteMessenger;
import games.strategy.engine.message.RemoteMessenger;
import games.strategy.engine.message.RemoteName;
import games.strategy.engine.message.UnifiedMessenger;
import games.strategy.net.IConnectionChangeListener;
import games.strategy.net.IMessenger;
import games.strategy.net.IMessengerErrorListener;
import games.strategy.net.INode;
import games.strategy.net.IServerMessenger;
import games.strategy.net.ServerMessenger;
import games.strategy.util.Version;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerModel
extends Observable
implements IMessengerErrorListener,
IConnectionChangeListener {
    public static final String CHAT_NAME = "games.strategy.engine.framework.ui.ServerStartup.CHAT_NAME";
    public static final RemoteName SERVER_REMOTE_NAME = new RemoteName("games.strategy.engine.framework.ui.ServerStartup.SERVER_REMOTE", IServerStartupRemote.class);
    static final String PLAYERNAME = "PlayerName";
    private static Logger s_logger = Logger.getLogger(ServerModel.class.getName());
    private final GameObjectStreamFactory m_objectStreamFactory = new GameObjectStreamFactory(null);
    private final SetupPanelModel m_typePanelModel;
    private final boolean m_headless;
    private IServerMessenger m_serverMessenger;
    private IRemoteMessenger m_remoteMessenger;
    private IChannelMessenger m_channelMessenger;
    private GameData m_data;
    private Map<String, String> m_players = new HashMap<String, String>();
    private Map<String, Collection<String>> m_playerNamesAndAlliancesInTurnOrder = new LinkedHashMap<String, Collection<String>>();
    private IRemoteModelListener m_listener = IRemoteModelListener.NULL_LISTENER;
    private final GameSelectorModel m_gameSelectorModel;
    private Component m_ui;
    private IChatPanel m_chatPanel;
    private ChatController m_chatController;
    private final Map<String, String> m_localPlayerTypes = new HashMap<String, String>();
    private volatile ServerLauncher m_serverLauncher;
    private CountDownLatch m_removeConnectionsLatch = null;
    private final Observer m_gameSelectorObserver = new Observer(){

        public void update(Observable o, Object arg) {
            ServerModel.this.gameDataChanged();
        }
    };
    private final IServerStartupRemote m_serverStartupRemote = new IServerStartupRemote(){

        @Override
        public PlayerListing getPlayerListing() {
            return ServerModel.this.getPlayerListingInternal();
        }

        @Override
        public void takePlayer(INode who, String playerName) {
            ServerModel.this.takePlayerInternal(who, true, playerName);
        }

        @Override
        public void releasePlayer(INode who, String playerName) {
            ServerModel.this.takePlayerInternal(who, false, playerName);
        }

        @Override
        public boolean isGameStarted(INode newNode) {
            if (ServerModel.this.m_serverLauncher != null) {
                IObserverWaitingToJoin observerWaitingToJoin = (IObserverWaitingToJoin)ServerModel.this.m_remoteMessenger.getRemote(ServerModel.getObserverWaitingToStartName(newNode));
                ServerModel.this.m_serverLauncher.addObserver(observerWaitingToJoin, newNode);
                return true;
            }
            return false;
        }

        @Override
        public boolean getIsServerHeadless() {
            return HeadlessGameServer.headless();
        }

        @Override
        public byte[] getSaveGame() {
            System.out.println("Sending save game");
            ByteArrayOutputStream sink = new ByteArrayOutputStream(5000);
            byte[] bytes = null;
            try {
                new GameDataManager().saveGame(sink, ServerModel.this.m_data);
                bytes = sink.toByteArray();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalStateException(e);
            }
            finally {
                try {
                    sink.close();
                }
                catch (IOException e) {}
            }
            return bytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getGameOptions() {
            byte[] bytes = null;
            if (ServerModel.this.m_data == null || ServerModel.this.m_data.getProperties() == null || ServerModel.this.m_data.getProperties().getEditableProperties() == null || ServerModel.this.m_data.getProperties().getEditableProperties().isEmpty()) {
                return bytes;
            }
            List<IEditableProperty> currentEditableProperties = ServerModel.this.m_data.getProperties().getEditableProperties();
            ByteArrayOutputStream sink = new ByteArrayOutputStream(1000);
            try {
                GameProperties.toOutputStream(sink, currentEditableProperties);
                bytes = sink.toByteArray();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    sink.close();
                }
                catch (IOException e) {}
            }
            return bytes;
        }

        @Override
        public Set<String> getAvailableGames() {
            HeadlessGameServer headless = HeadlessGameServer.getInstance();
            if (headless == null) {
                return null;
            }
            return headless.getAvailableGames();
        }

        @Override
        public void changeServerGameTo(String gameName) {
            HeadlessGameServer headless = HeadlessGameServer.getInstance();
            if (headless == null) {
                return;
            }
            System.out.println("Changing to game map: " + gameName);
            headless.setGameMapTo(gameName);
        }

        @Override
        public void changeToLatestAutosave(SaveGameFileChooser.AUTOSAVE_TYPE typeOfAutosave) {
            File save;
            HeadlessGameServer headless = HeadlessGameServer.getInstance();
            if (headless == null) {
                return;
            }
            if (SaveGameFileChooser.AUTOSAVE_TYPE.AUTOSAVE.equals((Object)typeOfAutosave)) {
                save = new File(SaveGameFileChooser.DEFAULT_DIRECTORY, SaveGameFileChooser.getAutoSaveFileName());
            } else if (SaveGameFileChooser.AUTOSAVE_TYPE.AUTOSAVE_ODD.equals((Object)typeOfAutosave)) {
                save = new File(SaveGameFileChooser.DEFAULT_DIRECTORY, SaveGameFileChooser.getAutoSaveOddFileName());
            } else if (SaveGameFileChooser.AUTOSAVE_TYPE.AUTOSAVE_EVEN.equals((Object)typeOfAutosave)) {
                save = new File(SaveGameFileChooser.DEFAULT_DIRECTORY, SaveGameFileChooser.getAutoSaveEvenFileName());
            } else {
                return;
            }
            if (save == null || !save.exists()) {
                return;
            }
            System.out.println("Changing to autosave of type: " + typeOfAutosave.toString());
            headless.loadGameSave(save);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void changeToGameSave(byte[] bytes, String fileName) {
            HeadlessGameServer headless = HeadlessGameServer.getInstance();
            if (headless == null || bytes == null) {
                return;
            }
            System.out.println("Changing to user savegame: " + fileName);
            ByteArrayInputStream input = null;
            InputStream oinput = null;
            try {
                input = new ByteArrayInputStream(bytes);
                oinput = new BufferedInputStream(input);
                headless.loadGameSave(oinput, fileName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (oinput != null) {
                    try {
                        oinput.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        @Override
        public void changeToGameOptions(byte[] bytes) {
            HeadlessGameServer headless = HeadlessGameServer.getInstance();
            if (headless == null || bytes == null) {
                return;
            }
            System.out.println("Changing to user game options.");
            try {
                headless.loadGameOptions(bytes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public static RemoteName getObserverWaitingToStartName(INode node) {
        return new RemoteName("games.strategy.engine.framework.startup.mc.ServerModel.OBSERVER" + node.getName(), IObserverWaitingToJoin.class);
    }

    public ServerModel(GameSelectorModel gameSelectorModel, SetupPanelModel typePanelModel) {
        this(gameSelectorModel, typePanelModel, false);
    }

    public ServerModel(GameSelectorModel gameSelectorModel, SetupPanelModel typePanelModel, boolean headless) {
        this.m_gameSelectorModel = gameSelectorModel;
        this.m_typePanelModel = typePanelModel;
        this.m_gameSelectorModel.addObserver(this.m_gameSelectorObserver);
        this.m_headless = headless;
    }

    public void shutDown() {
        this.m_gameSelectorModel.deleteObserver(this.m_gameSelectorObserver);
        if (this.m_serverMessenger != null) {
            this.m_chatController.deactivate();
            this.m_serverMessenger.shutDown();
            this.m_serverMessenger.removeErrorListener(this);
            this.m_chatPanel.shutDown();
        }
    }

    public void cancel() {
        this.m_gameSelectorModel.deleteObserver(this.m_gameSelectorObserver);
        if (this.m_serverMessenger != null) {
            this.m_chatController.deactivate();
            this.m_serverMessenger.shutDown();
            this.m_serverMessenger.removeErrorListener(this);
            this.m_chatPanel.setChat(null);
        }
    }

    public void setRemoteModelListener(IRemoteModelListener listener) {
        if (listener == null) {
            listener = IRemoteModelListener.NULL_LISTENER;
        }
        this.m_listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocalPlayerType(String player, String type) {
        ServerModel serverModel = this;
        synchronized (serverModel) {
            this.m_localPlayerTypes.put(player, type);
        }
    }

    public String getLocalPlayerType(String player) {
        return this.m_localPlayerTypes.get(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gameDataChanged() {
        ServerModel serverModel = this;
        synchronized (serverModel) {
            this.m_data = this.m_gameSelectorModel.getGameData();
            if (this.m_data != null) {
                this.m_players = new HashMap<String, String>();
                this.m_playerNamesAndAlliancesInTurnOrder = new LinkedHashMap<String, Collection<String>>();
                for (String name : this.m_data.getPlayerList().getNames()) {
                    if (this.m_headless) {
                        this.m_players.put(name, null);
                    } else {
                        this.m_players.put(name, this.m_serverMessenger.getLocalNode().getName());
                    }
                    this.m_playerNamesAndAlliancesInTurnOrder.put(name, this.m_data.getAllianceTracker().getAlliancesPlayerIsIn(this.m_data.getPlayerList().getPlayerID(name)));
                }
            }
            this.m_objectStreamFactory.setData(this.m_data);
            this.m_localPlayerTypes.clear();
        }
        this.notifyChanellPlayersChanged();
        this.m_listener.playerListChanged();
    }

    private ServerProps getServerProps(Component ui) {
        if (System.getProperties().getProperty("triplea.server", "false").equals("true") && System.getProperties().getProperty("triplea.started", "").equals("")) {
            ServerProps props = new ServerProps();
            props.setName(System.getProperty("triplea.name"));
            props.setPort(Integer.parseInt(System.getProperty("triplea.port")));
            if (System.getProperty("triplea.server.password") != null) {
                props.setPassword(System.getProperty("triplea.server.password"));
            }
            System.setProperty("triplea.started", "true");
            return props;
        }
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        String playername = prefs.get(PLAYERNAME, System.getProperty("user.name"));
        ServerOptions options = new ServerOptions(ui, playername, 3300, false);
        options.setLocationRelativeTo(ui);
        options.setVisible(true);
        options.dispose();
        if (!options.getOKPressed()) {
            return null;
        }
        String name = options.getName();
        s_logger.log(Level.FINE, "Server playing as:" + name);
        prefs.put(PLAYERNAME, name);
        int port = options.getPort();
        if (port >= 65536 || port == 0) {
            if (this.m_headless) {
                System.out.println("Invalid Port: " + port);
            } else {
                JOptionPane.showMessageDialog(ui, "Invalid Port: " + port, "Error", 0);
            }
            return null;
        }
        ServerProps props = new ServerProps();
        props.setName(options.getName());
        props.setPort(options.getPort());
        props.setPassword(options.getPassword());
        return props;
    }

    public boolean createServerMessenger(Component ui) {
        this.m_ui = ui = ui == null ? null : JOptionPane.getFrameForComponent(ui);
        ServerProps props = this.getServerProps(ui);
        if (props == null) {
            return false;
        }
        try {
            this.m_serverMessenger = new ServerMessenger(props.getName(), props.getPort(), this.m_objectStreamFactory);
            ClientLoginValidator clientLoginValidator = new ClientLoginValidator(this.m_serverMessenger);
            clientLoginValidator.setGamePassword(props.getPassword());
            this.m_serverMessenger.setLoginValidator(clientLoginValidator);
            this.m_serverMessenger.addErrorListener(this);
            this.m_serverMessenger.addConnectionChangeListener(this);
            UnifiedMessenger unifiedMessenger = new UnifiedMessenger(this.m_serverMessenger);
            this.m_remoteMessenger = new RemoteMessenger(unifiedMessenger);
            this.m_remoteMessenger.registerRemote(this.m_serverStartupRemote, SERVER_REMOTE_NAME);
            this.m_channelMessenger = new ChannelMessenger(unifiedMessenger);
            NullModeratorController moderatorController = new NullModeratorController(this.m_serverMessenger);
            moderatorController.register(this.m_remoteMessenger);
            this.m_chatController = new ChatController(CHAT_NAME, this.m_serverMessenger, this.m_remoteMessenger, this.m_channelMessenger, moderatorController);
            this.m_chatPanel = ui == null && this.m_headless ? new HeadlessChat(this.m_serverMessenger, this.m_channelMessenger, this.m_remoteMessenger, CHAT_NAME, Chat.CHAT_SOUND_PROFILE.GAME_CHATROOM) : new ChatPanel(this.m_serverMessenger, this.m_channelMessenger, this.m_remoteMessenger, CHAT_NAME, Chat.CHAT_SOUND_PROFILE.GAME_CHATROOM);
            this.m_serverMessenger.setAcceptNewConnections(true);
            this.gameDataChanged();
            return true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.out);
            if (this.m_headless) {
                System.out.println("Unable to create server socket:" + ioe.getMessage());
            } else {
                JOptionPane.showMessageDialog(ui, "Unable to create server socket:" + ioe.getMessage(), "Error", 0);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlayerListing getPlayerListingInternal() {
        ServerModel serverModel = this;
        synchronized (serverModel) {
            if (this.m_data == null) {
                return new PlayerListing(new HashMap<String, String>(), new Version(0, 0), this.m_gameSelectorModel.getGameName(), this.m_gameSelectorModel.getGameRound(), new LinkedHashMap<String, Collection<String>>());
            }
            return new PlayerListing(new HashMap<String, String>(this.m_players), this.m_data.getGameVersion(), this.m_data.getGameName(), this.m_data.getSequence().getRound() + "", this.m_playerNamesAndAlliancesInTurnOrder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void takePlayerInternal(INode from, boolean take, String playerName) {
        ServerModel serverModel = this;
        synchronized (serverModel) {
            if (!this.m_players.containsKey(playerName)) {
                return;
            }
            if (take) {
                this.m_players.put(playerName, from.getName());
            } else {
                this.m_players.put(playerName, null);
            }
        }
        this.notifyChanellPlayersChanged();
        this.m_listener.playersTakenChanged();
    }

    private void notifyChanellPlayersChanged() {
        IClientChannel channel = (IClientChannel)this.m_channelMessenger.getChannelBroadcastor(IClientChannel.CHANNEL_NAME);
        channel.playerListingChanged(this.getPlayerListingInternal());
    }

    public void takePlayer(String playerName) {
        this.takePlayerInternal(this.m_serverMessenger.getLocalNode(), true, playerName);
    }

    public void releasePlayer(String playerName) {
        this.takePlayerInternal(this.m_serverMessenger.getLocalNode(), false, playerName);
    }

    public IServerMessenger getMessenger() {
        return this.m_serverMessenger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getPlayers() {
        ServerModel serverModel = this;
        synchronized (serverModel) {
            return new HashMap<String, String>(this.m_players);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Collection<String>> getPlayerNamesAndAlliancesInTurnOrderLinkedHashMap() {
        ServerModel serverModel = this;
        synchronized (serverModel) {
            return new LinkedHashMap<String, Collection<String>>(this.m_playerNamesAndAlliancesInTurnOrder);
        }
    }

    @Override
    public void messengerInvalid(IMessenger messenger, Exception reason) {
        if (this.m_headless) {
            System.out.println("Connection Lost");
            if (this.m_typePanelModel != null) {
                this.m_typePanelModel.showSelectType();
            }
        } else {
            JOptionPane.showMessageDialog(this.m_ui, "Connection lost", "Error", 0);
            this.m_typePanelModel.showSelectType();
        }
    }

    @Override
    public void connectionAdded(INode to) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionRemoved(INode node) {
        if (this.m_removeConnectionsLatch != null) {
            try {
                this.m_removeConnectionsLatch.await(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this.m_serverLauncher != null) {
            this.m_serverLauncher.connectionLost(node);
            return;
        }
        ArrayList<String> free = new ArrayList<String>();
        ServerModel serverModel = this;
        synchronized (serverModel) {
            for (String player : this.m_players.keySet()) {
                String playedBy = this.m_players.get(player);
                if (playedBy == null || !playedBy.equals(node.getName())) continue;
                free.add(player);
            }
        }
        for (String player : free) {
            this.takePlayerInternal(node, false, player);
        }
    }

    public IChatPanel getChatPanel() {
        return this.m_chatPanel;
    }

    public void disallowRemoveConnections() {
        while (this.m_removeConnectionsLatch != null && this.m_removeConnectionsLatch.getCount() > 0L) {
            this.m_removeConnectionsLatch.countDown();
        }
        this.m_removeConnectionsLatch = new CountDownLatch(1);
    }

    public void allowRemoveConnections() {
        while (this.m_removeConnectionsLatch != null && this.m_removeConnectionsLatch.getCount() > 0L) {
            this.m_removeConnectionsLatch.countDown();
        }
        this.m_removeConnectionsLatch = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILauncher getLauncher() {
        ServerModel serverModel = this;
        synchronized (serverModel) {
            this.disallowRemoveConnections();
            int clientCount = this.m_serverMessenger.getNodes().size() - 1;
            HashMap<String, String> localPlayerMappings = new HashMap<String, String>();
            HashMap<String, INode> remotePlayers = new HashMap<String, INode>();
            String defaultLocalType = this.m_data.getGameLoader().getServerPlayerTypes()[0];
            block3: for (String player : this.m_players.keySet()) {
                String playedBy = this.m_players.get(player);
                if (playedBy == null) {
                    return null;
                }
                if (playedBy.equals(this.m_serverMessenger.getLocalNode().getName())) {
                    String type = defaultLocalType;
                    if (this.m_localPlayerTypes.containsKey(player)) {
                        type = this.m_localPlayerTypes.get(player);
                    }
                    localPlayerMappings.put(player, type);
                    continue;
                }
                Set<INode> nodes = this.m_serverMessenger.getNodes();
                for (INode node : nodes) {
                    if (!node.getName().equals(playedBy)) continue;
                    remotePlayers.put(player, node);
                    continue block3;
                }
            }
            ServerLauncher launcher = new ServerLauncher(clientCount, this.m_remoteMessenger, this.m_channelMessenger, this.m_serverMessenger, this.m_gameSelectorModel, localPlayerMappings, remotePlayers, this, this.m_headless);
            return launcher;
        }
    }

    public void newGame() {
        this.m_serverMessenger.setAcceptNewConnections(true);
        IClientChannel channel = (IClientChannel)this.m_channelMessenger.getChannelBroadcastor(IClientChannel.CHANNEL_NAME);
        this.notifyChanellPlayersChanged();
        channel.gameReset();
    }

    public void setServerLauncher(ServerLauncher launcher) {
        this.m_serverLauncher = launcher;
    }
}

