/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.ui;

import games.strategy.engine.chat.IChatPanel;
import games.strategy.engine.framework.startup.mc.ClientModel;
import games.strategy.engine.framework.startup.mc.IRemoteModelListener;
import games.strategy.engine.framework.startup.ui.SetupPanel;
import games.strategy.engine.framework.ui.SaveGameFileChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientSetupPanel
extends SetupPanel {
    private static final long serialVersionUID = 6942605803526295372L;
    private final Insets BUTTON_INSETS = new Insets(0, 0, 0, 0);
    private final ClientModel m_model;
    private List<PlayerRow> m_playerRows = Collections.emptyList();
    private final IRemoteModelListener m_listener = new IRemoteModelListener(){

        public void playersTakenChanged() {
        }

        public void playerListChanged() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ClientSetupPanel.this.internalPlayersChanged();
                }
            });
        }
    };

    public ClientSetupPanel(ClientModel model) {
        this.m_model = model;
        this.createComponents();
        this.layoutComponents();
        this.setupListeners();
        this.setWidgetActivation();
    }

    private void internalPlayersChanged() {
        Map<String, String> m_players = this.m_model.getPlayerMapping();
        Map<String, Collection<String>> m_playerNamesAndAlliancesInTurnOrder = this.m_model.getPlayerNamesAndAlliancesInTurnOrderLinkedHashMap();
        this.m_playerRows = new ArrayList<PlayerRow>();
        Set<String> playerNames = m_playerNamesAndAlliancesInTurnOrder.keySet();
        for (String name : playerNames) {
            PlayerRow playerRow = new PlayerRow(name, m_playerNamesAndAlliancesInTurnOrder.get(name), "Client");
            this.m_playerRows.add(playerRow);
            playerRow.setPlayerName(m_players.get(name));
        }
        this.layoutComponents();
    }

    private void createComponents() {
    }

    private void layoutComponents() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        JPanel info = new JPanel();
        info.setLayout(new BoxLayout(info, 1));
        info.add(new JLabel(" "));
        this.add((Component)info, "North");
        JPanel players = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        players.setLayout(layout);
        Insets spacing = new Insets(3, 23, 0, 0);
        Insets lastSpacing = new Insets(3, 23, 0, 23);
        GridBagConstraints nameConstraints = new GridBagConstraints();
        nameConstraints.anchor = 17;
        nameConstraints.gridx = 0;
        nameConstraints.insets = spacing;
        GridBagConstraints playerConstraints = new GridBagConstraints();
        playerConstraints.anchor = 17;
        playerConstraints.gridx = 2;
        playerConstraints.insets = spacing;
        GridBagConstraints playConstraints = new GridBagConstraints();
        playConstraints.anchor = 17;
        playConstraints.gridx = 3;
        playConstraints.insets = spacing;
        GridBagConstraints allianceConstraints = new GridBagConstraints();
        allianceConstraints.anchor = 17;
        allianceConstraints.gridx = 4;
        allianceConstraints.insets = lastSpacing;
        JLabel nameLabel = new JLabel("Name");
        nameLabel.setForeground(Color.black);
        layout.setConstraints(nameLabel, nameConstraints);
        players.add(nameLabel);
        JLabel playerLabel = new JLabel("Played By");
        playerLabel.setForeground(Color.black);
        layout.setConstraints(playerLabel, playerConstraints);
        players.add(playerLabel);
        JLabel playedByLabel = new JLabel("                    ");
        layout.setConstraints(playedByLabel, playConstraints);
        players.add(playedByLabel);
        JLabel allianceLabel = new JLabel("Alliance");
        allianceLabel.setForeground(Color.black);
        layout.setConstraints(allianceLabel, allianceConstraints);
        players.add(allianceLabel);
        for (PlayerRow row : this.m_playerRows) {
            layout.setConstraints(row.getName(), nameConstraints);
            players.add(row.getName());
            layout.setConstraints(row.getPlayer(), playerConstraints);
            players.add(row.getPlayer());
            layout.setConstraints(row.getPlayerComponent(), playConstraints);
            players.add(row.getPlayerComponent());
            layout.setConstraints(row.getAlliance(), allianceConstraints);
            players.add(row.getAlliance());
        }
        this.add((Component)players, "Center");
        this.validate();
    }

    private void setupListeners() {
        this.m_model.setRemoteModelListener(this.m_listener);
    }

    @Override
    public void setWidgetActivation() {
    }

    @Override
    public void shutDown() {
        this.m_model.shutDown();
    }

    @Override
    public void cancel() {
        this.m_model.cancel();
    }

    @Override
    public boolean canGameStart() {
        return false;
    }

    @Override
    public IChatPanel getChatPanel() {
        return this.m_model.getChatPanel();
    }

    @Override
    public List<Action> getUserActions() {
        if (this.m_model == null) {
            return null;
        }
        boolean isServerHeadless = this.m_model.getIsServerHeadlessCached();
        if (!isServerHeadless) {
            return null;
        }
        ArrayList<Action> rVal = new ArrayList<Action>();
        rVal.add(this.m_model.getHostBotSetMapClientAction(this));
        rVal.add(this.m_model.getHostBotChangeGameOptionsClientAction(this));
        rVal.add(this.m_model.getHostBotChangeGameToSaveGameClientAction(this));
        rVal.add(this.m_model.getHostBotChangeToAutosaveClientAction(this, SaveGameFileChooser.AUTOSAVE_TYPE.AUTOSAVE));
        rVal.add(this.m_model.getHostBotChangeToAutosaveClientAction(this, SaveGameFileChooser.AUTOSAVE_TYPE.AUTOSAVE_ODD));
        rVal.add(this.m_model.getHostBotChangeToAutosaveClientAction(this, SaveGameFileChooser.AUTOSAVE_TYPE.AUTOSAVE_EVEN));
        rVal.add(this.m_model.getHostBotGetGameSaveClientAction(this));
        return rVal;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PlayerRow {
        private final JLabel m_playerNameLabel;
        private final JLabel m_playerLabel;
        private JComponent m_playerComponent;
        private final String m_localPlayerType;
        private JLabel m_alliance;
        private final Action m_takeAction = new AbstractAction("Play"){
            private static final long serialVersionUID = 9086754428763609790L;

            public void actionPerformed(ActionEvent e) {
                ClientSetupPanel.this.m_model.takePlayer(PlayerRow.this.m_playerNameLabel.getText());
            }
        };
        private final Action m_dontTakeAction = new AbstractAction("Dont Play"){
            private static final long serialVersionUID = 8735891444454338978L;

            public void actionPerformed(ActionEvent e) {
                ClientSetupPanel.this.m_model.releasePlayer(PlayerRow.this.m_playerNameLabel.getText());
            }
        };

        PlayerRow(String playerName, Collection<String> playerAlliances, String localPlayerType) {
            this.m_playerNameLabel = new JLabel(playerName);
            this.m_playerLabel = new JLabel("");
            this.m_playerComponent = new JLabel("");
            this.m_localPlayerType = localPlayerType;
            this.m_alliance = playerAlliances.contains(playerName) ? new JLabel() : new JLabel(playerAlliances.toString());
        }

        public JLabel getName() {
            return this.m_playerNameLabel;
        }

        public JLabel getPlayer() {
            return this.m_playerLabel;
        }

        public String getPlayerName() {
            return this.m_playerNameLabel.getText();
        }

        public JLabel getAlliance() {
            return this.m_alliance;
        }

        public void setPlayerName(String playerName) {
            if (playerName == null) {
                this.m_playerLabel.setText("-");
                JButton button = new JButton(this.m_takeAction);
                button.setMargin(ClientSetupPanel.this.BUTTON_INSETS);
                this.m_playerComponent = button;
            } else {
                this.m_playerLabel.setText(playerName);
                if (playerName.equals(ClientSetupPanel.this.m_model.getMessenger().getLocalNode().getName())) {
                    JButton button = new JButton(this.m_dontTakeAction);
                    button.setMargin(ClientSetupPanel.this.BUTTON_INSETS);
                    this.m_playerComponent = button;
                } else {
                    this.m_playerComponent = new JLabel("");
                }
            }
        }

        public boolean isPlaying() {
            return this.m_playerLabel.getText().equals(ClientSetupPanel.this.m_model.getMessenger().getLocalNode().getName());
        }

        public JComponent getPlayerComponent() {
            return this.m_playerComponent;
        }

        public String getLocalType() {
            return this.m_localPlayerType;
        }
    }
}

