/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.ui;

import games.strategy.debug.Console;
import games.strategy.engine.framework.GameRunner2;
import games.strategy.engine.framework.ProcessRunnerUtil;
import games.strategy.engine.framework.TripleAProcessRunner;
import games.strategy.net.DesktopUtilityBrowserLauncher;
import games.strategy.sound.SoundOptions;
import games.strategy.sound.SoundPath;
import games.strategy.triplea.ui.TripleaMenu;
import games.strategy.ui.IntTextField;
import games.strategy.util.CountDownLatchHandler;
import games.strategy.util.EventThreadJOptionPane;
import games.strategy.util.Triple;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class EnginePreferences
extends JDialog {
    private static final long serialVersionUID = 5071190543005064757L;
    private final Frame m_parentFrame;
    private JButton m_okButton;
    private JButton m_lookAndFeel;
    private JButton m_gameParser;
    private JButton m_setupProxies;
    private JButton m_setMaxMemory;
    private JButton m_console;
    private JButton m_mapCreator;
    private JButton m_userFolder;
    private JButton m_programFolder;
    private JButton m_readme;

    private EnginePreferences(Frame parentFrame) {
        super(parentFrame, "Edit TripleA Engine Preferences", true);
        this.m_parentFrame = parentFrame;
        this.createComponents();
        this.layoutCoponents();
        this.setupListeners();
        this.setWidgetActivation();
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                EnginePreferences.this.m_okButton.requestFocus();
            }
        });
    }

    private void createComponents() {
        this.m_okButton = new JButton("OK");
        this.m_lookAndFeel = new JButton("Set Look And Feel");
        this.m_gameParser = new JButton("Enable/Disable Delayed Parsing of Game XML's");
        this.m_setupProxies = new JButton("Setup Network and Proxy Settings");
        this.m_setMaxMemory = new JButton("Set Max Memory Usage");
        this.m_mapCreator = new JButton("Run the Map Creator");
        this.m_console = new JButton("Show Console");
        this.m_userFolder = new JButton("Open User Maps and Savegames Folder");
        this.m_programFolder = new JButton("Open Installed Program Folder");
        this.m_readme = new JButton("Open Readme / User Manual");
    }

    private void layoutCoponents() {
        this.setLayout(new BorderLayout());
        JPanel buttonsPanel = new JPanel();
        this.add((Component)buttonsPanel, "Center");
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 1));
        buttonsPanel.add(Box.createGlue());
        buttonsPanel.add(new JLabel("Change Engine Properties: "));
        buttonsPanel.add(new JLabel(" "));
        SoundOptions.addGlobalSoundSwitchCheckbox(buttonsPanel);
        buttonsPanel.add(new JLabel(" "));
        SoundOptions.addToPanel(buttonsPanel, SoundPath.SoundType.TRIPLEA);
        buttonsPanel.add(new JLabel(" "));
        buttonsPanel.add(this.m_lookAndFeel);
        buttonsPanel.add(new JLabel(" "));
        buttonsPanel.add(this.m_gameParser);
        buttonsPanel.add(new JLabel(" "));
        buttonsPanel.add(this.m_setupProxies);
        buttonsPanel.add(new JLabel(" "));
        buttonsPanel.add(this.m_setMaxMemory);
        buttonsPanel.add(new JLabel(" "));
        buttonsPanel.add(this.m_mapCreator);
        buttonsPanel.add(new JLabel(" "));
        buttonsPanel.add(this.m_console);
        buttonsPanel.add(new JLabel(" "));
        buttonsPanel.add(this.m_userFolder);
        buttonsPanel.add(new JLabel(" "));
        buttonsPanel.add(this.m_programFolder);
        buttonsPanel.add(new JLabel(" "));
        buttonsPanel.add(this.m_readme);
        buttonsPanel.add(new JLabel(" "));
        buttonsPanel.add(Box.createGlue());
        buttonsPanel.setBorder(new EmptyBorder(20, 20, 20, 20));
        JPanel main = new JPanel();
        main.setBorder(new EmptyBorder(30, 30, 30, 30));
        main.setLayout(new BoxLayout(main, 0));
        main.add(this.m_okButton);
        this.add((Component)main, "South");
    }

    private void setupListeners() {
        this.m_okButton.addActionListener(new AbstractAction("OK"){
            private static final long serialVersionUID = 8014389179875584858L;

            public void actionPerformed(ActionEvent e) {
                EnginePreferences.this.setVisible(false);
            }
        });
        this.m_lookAndFeel.addActionListener(new AbstractAction("Set Look And Feel"){
            private static final long serialVersionUID = -6524988343523615143L;

            public void actionPerformed(ActionEvent event) {
                Triple<JList, Map<String, String>, String> lookAndFeel = TripleaMenu.getLookAndFeelList();
                JList list = (JList)lookAndFeel.getFirst();
                String currentKey = lookAndFeel.getThird();
                Map lookAndFeels = (Map)lookAndFeel.getSecond();
                if (JOptionPane.showConfirmDialog(EnginePreferences.this.m_parentFrame, list) == 0) {
                    String selectedValue = (String)list.getSelectedValue();
                    if (selectedValue == null) {
                        return;
                    }
                    if (selectedValue.equals(currentKey)) {
                        return;
                    }
                    GameRunner2.setDefaultLookAndFeel((String)lookAndFeels.get(selectedValue));
                    EventThreadJOptionPane.showMessageDialog(EnginePreferences.this.m_parentFrame, "The look and feel will update when you restart TripleA", new CountDownLatchHandler(true));
                }
            }
        });
        this.m_gameParser.addActionListener(new AbstractAction("Enable/Disable Delayed Parsing of Game XML's"){
            private static final long serialVersionUID = -6223524865968800051L;

            public void actionPerformed(ActionEvent e) {
                boolean delay;
                boolean current = GameRunner2.getDelayedParsing();
                Object[] options = new Object[]{"Parse Selected", "Parse All", "Cancel"};
                int answer = JOptionPane.showOptionDialog(EnginePreferences.this.m_parentFrame, new JLabel("<html>Delay Parsing of Game Data from XML until game is selected?<br><br>'" + options[1] + "' means each map is fully parsed as TripleA starts (useful for testing to make sure all your maps are valid)." + "<br><br>Your current setting is: '" + (current ? options[0].toString() : options[1].toString()) + "'</html>"), "Select Parsing Method", 1, 3, null, options, options[2]);
                if (answer == 2) {
                    return;
                }
                boolean bl = delay = answer == 0;
                if (delay == current) {
                    return;
                }
                GameRunner2.setDelayedParsing(delay);
                EventThreadJOptionPane.showMessageDialog(EnginePreferences.this.m_parentFrame, "Please restart TripleA to avoid any potential errors", new CountDownLatchHandler(true));
            }
        });
        this.m_setupProxies.addActionListener(new AbstractAction("Setup Network and Proxy Settings"){
            private static final long serialVersionUID = 1673056396542959597L;

            public void actionPerformed(ActionEvent e) {
                Preferences pref = Preferences.userNodeForPackage(GameRunner2.class);
                GameRunner2.ProxyChoice proxyChoice = GameRunner2.ProxyChoice.valueOf(pref.get("proxy.choice", GameRunner2.ProxyChoice.NONE.toString()));
                String proxyHost = pref.get("proxy.host", "");
                JTextField hostText = new JTextField(proxyHost);
                String proxyPort = pref.get("proxy.port", "");
                JTextField portText = new JTextField(proxyPort);
                JRadioButton noneButton = new JRadioButton("None", proxyChoice == GameRunner2.ProxyChoice.NONE);
                JRadioButton systemButton = new JRadioButton("Use System Settings", proxyChoice == GameRunner2.ProxyChoice.USE_SYSTEM_SETTINGS);
                JRadioButton userButton = new JRadioButton("Use These User Settings:", proxyChoice == GameRunner2.ProxyChoice.USE_USER_PREFERENCES);
                ButtonGroup bgroup = new ButtonGroup();
                bgroup.add(noneButton);
                bgroup.add(systemButton);
                bgroup.add(userButton);
                JPanel radioPanel = new JPanel();
                radioPanel.setLayout(new BoxLayout(radioPanel, 1));
                radioPanel.add(new JLabel("Configure TripleA's Network and Proxy Settings: "));
                radioPanel.add(new JLabel("(This only effects Play-By-Forum games, dice servers, and map downloads.)"));
                radioPanel.add(noneButton);
                radioPanel.add(systemButton);
                radioPanel.add(userButton);
                radioPanel.add(new JLabel("Proxy Host: "));
                radioPanel.add(hostText);
                radioPanel.add(new JLabel("Proxy Port: "));
                radioPanel.add(portText);
                Object[] options = new Object[]{"Accept", "Cancel"};
                int answer = JOptionPane.showOptionDialog(EnginePreferences.this.m_parentFrame, radioPanel, "Network Settings", 2, 3, null, options, options[1]);
                if (answer != 0) {
                    return;
                }
                GameRunner2.ProxyChoice newChoice = systemButton.isSelected() ? GameRunner2.ProxyChoice.USE_SYSTEM_SETTINGS : (userButton.isSelected() ? GameRunner2.ProxyChoice.USE_USER_PREFERENCES : GameRunner2.ProxyChoice.NONE);
                GameRunner2.setProxy(hostText.getText(), portText.getText(), newChoice);
            }
        });
        this.m_setMaxMemory.addActionListener(new AbstractAction("Set Max Memory Usage"){
            private static final long serialVersionUID = 1262782782917758914L;

            public void actionPerformed(ActionEvent e) {
                final AtomicBoolean tested = new AtomicBoolean();
                tested.set(false);
                Properties systemIni = GameRunner2.getSystemIni();
                int currentSetting = GameRunner2.getMaxMemoryFromSystemIniFileInMB(systemIni);
                boolean useDefault = GameRunner2.useDefaultMaxMemory(systemIni) || currentSetting <= 0;
                int currentMaxMemoryInMB = (int)(GameRunner2.getMaxMemoryInBytes() / 0x100000L);
                final IntTextField newMaxMemory = new IntTextField(0, 3072, currentMaxMemoryInMB, 5);
                JRadioButton noneButton = new JRadioButton("Use Default", useDefault);
                JRadioButton userButton = new JRadioButton("Use These User Settings:", !useDefault);
                ButtonGroup bgroup = new ButtonGroup();
                bgroup.add(noneButton);
                bgroup.add(userButton);
                boolean onlineOnlyOriginalSetting = GameRunner2.getUseMaxMemorySettingOnlyForOnlineJoinOrHost(systemIni);
                JCheckBox onlyOnlineCheckBox = new JCheckBox("Only use these user memory settings for online games (join/host). [Default = On]");
                onlyOnlineCheckBox.setSelected(onlineOnlyOriginalSetting);
                onlyOnlineCheckBox.setToolTipText("<html>If checked, only joining and hosting from online lobby will be affected by these settings.<br />If unchecked, TripleA will automatically restart itself with the new memory setting every time you start TripleA.</html>");
                JButton test = new JButton("Test User Settings");
                test.addActionListener(new AbstractAction("Test User Settings"){
                    private static final long serialVersionUID = -4398183978989504112L;

                    public void actionPerformed(ActionEvent e) {
                        tested.set(true);
                        System.out.println("Testing TripleA launch with max memory of: " + newMaxMemory.getValue() + "m");
                        TripleAProcessRunner.startNewTripleA((long)newMaxMemory.getValue() * 1024L * 1024L + 0x4000000L);
                    }
                });
                JPanel radioPanel = new JPanel();
                radioPanel.setLayout(new BoxLayout(radioPanel, 1));
                radioPanel.add(new JLabel("<html>Configure TripleA's Maxmimum Memory Usage Settings: <br />(TripleA will only use 80-90% of this, the rest is used by Java VM)</html>"));
                radioPanel.add(new JLabel(" "));
                radioPanel.add(new JLabel("<html><b>WARNING: You could permanently stop TripleA from working if you mess with this! </b></html>"));
                radioPanel.add(new JLabel("<html><em><p>By default TripleA uses a bit less than 1gb of RAM memory, <br />and this is because on some computers Java can fail when greater than 1gb (1024mb). <br />The symptoms of this failing are: TripleA not starting, not being able to 'Join' or 'Host' <br />in the online lobby, and not being able to start the map creator. <br />For whatever max you set, Java requires you to have approximately double that much <br />free memory available, not being used by your operating system or other programs you are running. <br />Otherwise, TripleA will fail to start, and/or fail to join/host games online. <br />If you do mess this up, you can always run TripleA by command line with a different setting: <br />java -Xmx512m -classpath triplea.jar games.strategy.engine.framework.GameRunner triplea.memory.set=true<br />Or you can delete or change the 'system.ini' file located where TripleA was installed. </p><br /><p>In order to make sure you do not mess this up, click the 'Test' button and make sure that <br />a new TripleA process is able to run with your new max memory setting. <br />If one does not run, you had better lower the setting or just use the default. </p></em></html>"));
                radioPanel.add(new JLabel(" "));
                radioPanel.add(onlyOnlineCheckBox);
                radioPanel.add(new JLabel(" "));
                radioPanel.add(noneButton);
                radioPanel.add(userButton);
                radioPanel.add(new JLabel("Maximum Memory (in MB): "));
                radioPanel.add(newMaxMemory);
                radioPanel.add(new JLabel(" "));
                radioPanel.add(new JLabel("<html>After clicking the 'Test' button, a new TripleA should launch. <br />If nothing launches, there is something wrong and you probably set the maximum too high. <br />You MUST test user settings before you use them! Otherwise the engine will discard changes. <br />TripleA has no way of knowing if this fails or succeeds, and there will not be an error message of any kind. </html>"));
                radioPanel.add(test);
                radioPanel.add(new JLabel(" "));
                Object[] options = new Object[]{"Accept", "Cancel"};
                int answer = JOptionPane.showOptionDialog(EnginePreferences.this.m_parentFrame, radioPanel, "Max Memory Settings", 2, 3, null, options, options[1]);
                if (answer != 0) {
                    return;
                }
                if (noneButton.isSelected()) {
                    GameRunner2.clearMaxMemory();
                } else if (userButton.isSelected()) {
                    boolean setMaxMemory;
                    boolean setOnlineOnly = onlineOnlyOriginalSetting != onlyOnlineCheckBox.isSelected();
                    boolean bl = setMaxMemory = newMaxMemory.getValue() > 64 && tested.get();
                    if (setOnlineOnly || setMaxMemory) {
                        Properties prop = setMaxMemory ? GameRunner2.setMaxMemoryInMB(newMaxMemory.getValue()) : new Properties();
                        GameRunner2.setUseMaxMemorySettingOnlyForOnlineJoinOrHost(onlyOnlineCheckBox.isSelected(), prop);
                        GameRunner2.writeSystemIni(prop, false);
                    }
                }
            }
        });
        this.m_mapCreator.addActionListener(new AbstractAction("Run the Map Creator"){
            private static final long serialVersionUID = -3588932790184974286L;

            public void actionPerformed(ActionEvent e) {
                ArrayList<String> commands = new ArrayList<String>();
                ProcessRunnerUtil.populateBasicJavaArgs(commands);
                String javaClass = "util.image.MapCreator";
                commands.add("util.image.MapCreator");
                ProcessRunnerUtil.exec(commands);
            }
        });
        this.m_console.addActionListener(new AbstractAction("Show Console"){
            private static final long serialVersionUID = 5333381081739176723L;

            public void actionPerformed(ActionEvent e) {
                Console.getConsole().setVisible(true);
                EnginePreferences.this.reportMemoryUsageToConsole();
            }
        });
        this.m_userFolder.addActionListener(new AbstractAction("Open User Maps and Savegames Folder"){
            private static final long serialVersionUID = -3882256687728469915L;

            public void actionPerformed(ActionEvent e) {
                try {
                    DesktopUtilityBrowserLauncher.openFile(GameRunner2.getUserRootFolder());
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.m_programFolder.addActionListener(new AbstractAction("Open Installed Program Folder"){
            private static final long serialVersionUID = 3621594954694705711L;

            public void actionPerformed(ActionEvent e) {
                try {
                    DesktopUtilityBrowserLauncher.openFile(GameRunner2.getRootFolder());
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.m_readme.addActionListener(new AbstractAction("Open Readme / User Manual"){
            private static final long serialVersionUID = 7125025575496119585L;

            public void actionPerformed(ActionEvent e) {
                try {
                    DesktopUtilityBrowserLauncher.openFile(new File(GameRunner2.getRootFolder(), "readme.html"));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    private void reportMemoryUsageToConsole() {
        int mb = 0x100000;
        Runtime runtime = Runtime.getRuntime();
        System.out.println("Heap utilization statistics [MB]");
        System.out.println("Used Memory: " + (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L);
        System.out.println("Free Memory: " + runtime.freeMemory() / 0x100000L);
        System.out.println("Total Memory: " + runtime.totalMemory() / 0x100000L);
        System.out.println("Max Memory: " + runtime.maxMemory() / 0x100000L);
        int currentMaxSetting = GameRunner2.getMaxMemoryFromSystemIniFileInMB(GameRunner2.getSystemIni());
        if (currentMaxSetting > 0) {
            System.out.println("Max Memory user setting within 20% of: " + currentMaxSetting);
        }
    }

    private void setWidgetActivation() {
    }

    public static void showEnginePreferences(JComponent parent) {
        Frame parentFrame = JOptionPane.getFrameForComponent(parent);
        EnginePreferences enginePrefs = new EnginePreferences(parentFrame);
        enginePrefs.pack();
        enginePrefs.setLocationRelativeTo(parentFrame);
        enginePrefs.setVisible(true);
    }

    public static void main(String[] args) {
        EnginePreferences.showEnginePreferences(null);
    }
}

