/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameParseException;
import games.strategy.engine.data.properties.IEditableProperty;
import games.strategy.engine.data.properties.PropertiesUI;
import games.strategy.engine.framework.GameRunner;
import games.strategy.engine.framework.GameRunner2;
import games.strategy.engine.framework.startup.mc.ClientModel;
import games.strategy.engine.framework.startup.mc.GameSelectorModel;
import games.strategy.engine.framework.startup.ui.FileBackedGamePropertiesCache;
import games.strategy.engine.framework.startup.ui.IGamePropertiesCache;
import games.strategy.engine.framework.startup.ui.MainFrame;
import games.strategy.engine.framework.ui.NewGameChooser;
import games.strategy.engine.framework.ui.NewGameChooserEntry;
import games.strategy.engine.framework.ui.SaveGameFileChooser;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class GameSelectorPanel
extends JPanel
implements Observer {
    private static final long serialVersionUID = -4598107601238030020L;
    private JLabel m_nameText;
    private JLabel m_versionText;
    private JLabel m_fileNameLabel;
    private JLabel m_fileNameText;
    private JLabel m_nameLabel;
    private JLabel m_versionLabel;
    private JLabel m_roundLabel;
    private JLabel m_roundText;
    private JButton m_loadSavedGame;
    private JButton m_loadNewGame;
    private JButton m_gameOptions;
    private final GameSelectorModel m_model;
    private final IGamePropertiesCache m_gamePropertiesCache = new FileBackedGamePropertiesCache();
    private final Map<String, Object> m_originalPropertiesMap = new HashMap<String, Object>();

    public GameSelectorPanel(GameSelectorModel model) {
        this.m_model = model;
        this.m_model.addObserver(this);
        GameData data = model.getGameData();
        if (data != null) {
            this.setOriginalPropertiesMap(data);
            this.m_gamePropertiesCache.loadCachedGamePropertiesInto(data);
        }
        this.createComponents();
        this.layoutComponents();
        this.setupListeners();
        this.setWidgetActivation();
        this.updateGameData();
    }

    private void updateGameData() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GameSelectorPanel.this.updateGameData();
                }
            });
            return;
        }
        this.m_nameText.setText(this.m_model.getGameName());
        this.m_versionText.setText(this.m_model.getGameVersion());
        this.m_roundText.setText(this.m_model.getGameRound());
        String fileName = this.m_model.getFileName();
        if (fileName != null && fileName.length() > 1) {
            try {
                fileName = URLDecoder.decode(fileName, "UTF-8");
            }
            catch (IllegalArgumentException e) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        this.m_fileNameText.setText(this.getLimitedFileNameText(fileName));
        this.m_fileNameText.setToolTipText(fileName);
    }

    private String getLimitedFileNameText(String fileName) {
        int maxLength = 25;
        if (fileName.length() <= 25) {
            return fileName;
        }
        int cuttoff = 18;
        if (fileName.indexOf("games") > 0) {
            cuttoff = Math.min(18, fileName.indexOf("games"));
        }
        int length = fileName.length();
        return fileName.substring(0, cuttoff) + "..." + fileName.substring(length - (25 - cuttoff) - 2, length);
    }

    private void createComponents() {
        this.m_nameLabel = new JLabel("Game Name:");
        this.m_versionLabel = new JLabel("Game Version:");
        this.m_roundLabel = new JLabel("Game Round:");
        this.m_fileNameLabel = new JLabel("File Name:");
        this.m_nameText = new JLabel();
        this.m_versionText = new JLabel();
        this.m_roundText = new JLabel();
        this.m_fileNameText = new JLabel();
        this.m_loadNewGame = new JButton("Choose Game...");
        this.m_loadNewGame.setToolTipText("<html>Select a game from all the maps/games that come with TripleA, <br>and the ones you have downloaded.</html>");
        this.m_loadSavedGame = new JButton("Load Saved Game...");
        this.m_loadSavedGame.setToolTipText("Load a previously saved game, or an autosave.");
        this.m_gameOptions = new JButton("Game Options...");
        this.m_gameOptions.setToolTipText("<html>Set options for the currently selected game, <br>such as enabling/disabling Low Luck, or Technology, etc.</html>");
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 3, 5), 0, 0));
        this.add((Component)this.m_nameText, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 3, 0), 0, 0));
        this.add((Component)this.m_versionLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 3, 5), 0, 0));
        this.add((Component)this.m_versionText, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.m_roundLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 3, 5), 0, 0));
        this.add((Component)this.m_roundText, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this.m_fileNameLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 10, 3, 5), 0, 0));
        this.add((Component)this.m_fileNameText, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 3, 5), 0, 0));
        this.add((Component)this.m_loadNewGame, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 17, 0, new Insets(25, 10, 10, 10), 0, 0));
        this.add((Component)this.m_loadSavedGame, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 10), 0, 0));
        this.add((Component)this.m_gameOptions, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 17, 0, new Insets(25, 10, 10, 10), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(0, 8, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void setupListeners() {
        this.m_loadNewGame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientModel clientModelForHostBots;
                if (GameSelectorPanel.this.canSelectLocalGameData()) {
                    GameSelectorPanel.this.selectGameFile(false);
                } else if (GameSelectorPanel.this.canChangeHostBotGameData() && (clientModelForHostBots = GameSelectorPanel.this.m_model.getClientModelForHostBots()) != null) {
                    clientModelForHostBots.getHostBotSetMapClientAction(GameSelectorPanel.this).actionPerformed(e);
                }
            }
        });
        this.m_loadSavedGame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientModel clientModelForHostBots;
                if (GameSelectorPanel.this.canSelectLocalGameData()) {
                    GameSelectorPanel.this.selectGameFile(true);
                } else if (GameSelectorPanel.this.canChangeHostBotGameData() && (clientModelForHostBots = GameSelectorPanel.this.m_model.getClientModelForHostBots()) != null) {
                    JPopupMenu menu = new JPopupMenu();
                    menu.add(clientModelForHostBots.getHostBotChangeGameToSaveGameClientAction(GameSelectorPanel.this));
                    menu.add(clientModelForHostBots.getHostBotChangeToAutosaveClientAction(GameSelectorPanel.this, SaveGameFileChooser.AUTOSAVE_TYPE.AUTOSAVE));
                    menu.add(clientModelForHostBots.getHostBotChangeToAutosaveClientAction(GameSelectorPanel.this, SaveGameFileChooser.AUTOSAVE_TYPE.AUTOSAVE_ODD));
                    menu.add(clientModelForHostBots.getHostBotChangeToAutosaveClientAction(GameSelectorPanel.this, SaveGameFileChooser.AUTOSAVE_TYPE.AUTOSAVE_EVEN));
                    menu.add(clientModelForHostBots.getHostBotGetGameSaveClientAction(GameSelectorPanel.this));
                    Point point = GameSelectorPanel.this.m_loadSavedGame.getLocation();
                    menu.show(GameSelectorPanel.this, point.x + GameSelectorPanel.this.m_loadSavedGame.getWidth(), point.y);
                }
            }
        });
        this.m_gameOptions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientModel clientModelForHostBots;
                if (GameSelectorPanel.this.canSelectLocalGameData()) {
                    GameSelectorPanel.this.selectGameOptions();
                } else if (GameSelectorPanel.this.canChangeHostBotGameData() && (clientModelForHostBots = GameSelectorPanel.this.m_model.getClientModelForHostBots()) != null) {
                    clientModelForHostBots.getHostBotChangeGameOptionsClientAction(GameSelectorPanel.this).actionPerformed(e);
                }
            }
        });
    }

    private void setOriginalPropertiesMap(GameData data) {
        this.m_originalPropertiesMap.clear();
        if (data != null) {
            for (IEditableProperty property : data.getProperties().getEditableProperties()) {
                this.m_originalPropertiesMap.put(property.getName(), property.getValue());
            }
        }
    }

    private void selectGameOptions() {
        HashMap<String, Object> currentPropertiesMap = new HashMap<String, Object>();
        for (IEditableProperty property : this.m_model.getGameData().getProperties().getEditableProperties()) {
            currentPropertiesMap.put(property.getName(), property.getValue());
        }
        PropertiesUI panel = new PropertiesUI(this.m_model.getGameData().getProperties(), true);
        JScrollPane scroll = new JScrollPane(panel);
        scroll.setBorder(null);
        scroll.getViewport().setBorder(null);
        JOptionPane pane = new JOptionPane(scroll, -1);
        String ok = "OK";
        String cancel = "Cancel";
        String makeDefault = "Make Default";
        String reset = "Reset";
        pane.setOptions(new Object[]{"OK", "Make Default", "Reset", "Cancel"});
        JDialog window = pane.createDialog(JOptionPane.getFrameForComponent(this), "Game Options");
        window.setVisible(true);
        Object buttonPressed = pane.getValue();
        if (buttonPressed == null || buttonPressed.equals("Cancel")) {
            for (IEditableProperty property : this.m_model.getGameData().getProperties().getEditableProperties()) {
                property.setValue(currentPropertiesMap.get(property.getName()));
            }
        } else if (buttonPressed.equals("Reset")) {
            if (!this.m_originalPropertiesMap.isEmpty()) {
                for (IEditableProperty property : this.m_model.getGameData().getProperties().getEditableProperties()) {
                    property.setValue(this.m_originalPropertiesMap.get(property.getName()));
                }
                this.selectGameOptions();
                return;
            }
        } else if (buttonPressed.equals("Make Default")) {
            this.m_gamePropertiesCache.cacheGameProperties(this.m_model.getGameData());
        }
    }

    private void setWidgetActivation() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GameSelectorPanel.this.setWidgetActivation();
                }
            });
            return;
        }
        boolean canSelectGameData = this.canSelectLocalGameData();
        boolean canChangeHostBotGameData = this.canChangeHostBotGameData();
        this.m_loadSavedGame.setEnabled(canSelectGameData || canChangeHostBotGameData);
        this.m_loadNewGame.setEnabled(canSelectGameData || canChangeHostBotGameData);
        if (canChangeHostBotGameData || canSelectGameData && this.m_model.getGameData() != null && this.m_model.getGameData().getProperties().getEditableProperties().size() > 0) {
            this.m_gameOptions.setEnabled(true);
        } else {
            this.m_gameOptions.setEnabled(false);
        }
        if (GameRunner2.areWeOldExtraJar()) {
            this.m_loadNewGame.setEnabled(false);
            this.m_loadNewGame.setToolTipText("This is disabled on older engine jars, please start new games with the latest version of TripleA.");
        }
    }

    private boolean canSelectLocalGameData() {
        return this.m_model != null && this.m_model.canSelect();
    }

    private boolean canChangeHostBotGameData() {
        return this.m_model != null && this.m_model.isHostHeadlessBot();
    }

    public void update(Observable o, Object arg) {
        this.updateGameData();
        this.setWidgetActivation();
    }

    public static File selectGameFile(Component parent) {
        if (GameRunner.isMac()) {
            FileDialog fileDialog = new FileDialog(JOptionPane.getFrameForComponent(parent));
            fileDialog.setMode(0);
            SaveGameFileChooser.ensureDefaultDirExists();
            fileDialog.setDirectory(SaveGameFileChooser.DEFAULT_DIRECTORY.getPath());
            fileDialog.setFilenameFilter(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".tsvg") || name.endsWith(".svg") || name.endsWith("tsvg.gz");
                }
            });
            fileDialog.setVisible(true);
            String fileName = fileDialog.getFile();
            String dirName = fileDialog.getDirectory();
            if (fileName == null) {
                return null;
            }
            File f = new File(dirName, fileName);
            return f;
        }
        SaveGameFileChooser fileChooser = SaveGameFileChooser.getInstance();
        int rVal = fileChooser.showOpenDialog(JOptionPane.getFrameForComponent(parent));
        if (rVal != 0) {
            return null;
        }
        return fileChooser.getSelectedFile();
    }

    private void selectGameFile(boolean saved) {
        if (saved) {
            File file = GameSelectorPanel.selectGameFile(GameRunner.isMac() ? MainFrame.getInstance() : JOptionPane.getFrameForComponent(this));
            if (file == null || !file.exists()) {
                return;
            }
            this.m_model.load(file, this);
            this.setOriginalPropertiesMap(this.m_model.getGameData());
        } else {
            NewGameChooserEntry entry = NewGameChooser.chooseGame(JOptionPane.getFrameForComponent(this), this.m_model.getGameName());
            if (entry != null) {
                if (!entry.isGameDataLoaded()) {
                    try {
                        entry.fullyParseGameData();
                    }
                    catch (GameParseException e) {
                        entry.delayParseGameData();
                        NewGameChooser.getNewGameChooserModel().removeEntry(entry);
                        return;
                    }
                }
                this.m_model.load(entry);
                this.setOriginalPropertiesMap(this.m_model.getGameData());
                this.m_gamePropertiesCache.loadCachedGamePropertiesInto(this.m_model.getGameData());
            }
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        GameSelectorModel model = new GameSelectorModel();
        model.loadDefaultGame(f);
        f.getContentPane().add(new GameSelectorPanel(model));
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
    }
}

