/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.ui;

import games.strategy.engine.EngineVersion;
import games.strategy.engine.framework.GameRunner2;
import games.strategy.engine.framework.mapDownload.DownloadMapDialog;
import games.strategy.engine.framework.startup.mc.SetupPanelModel;
import games.strategy.engine.framework.startup.ui.EnginePreferences;
import games.strategy.engine.framework.startup.ui.MainFrame;
import games.strategy.engine.framework.startup.ui.SetupPanel;
import games.strategy.engine.framework.ui.NewGameChooser;
import games.strategy.engine.framework.ui.background.BackgroundTaskRunner;
import games.strategy.engine.lobby.client.LobbyClient;
import games.strategy.engine.lobby.client.login.LobbyLogin;
import games.strategy.engine.lobby.client.login.LobbyServerProperties;
import games.strategy.engine.lobby.client.ui.LobbyFrame;
import games.strategy.net.DesktopUtilityBrowserLauncher;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaSetupPanel
extends SetupPanel {
    private static final long serialVersionUID = 3926503672972937677L;
    private static final Logger s_logger = Logger.getLogger(MetaSetupPanel.class.getName());
    private static String s_serverPropertiesName = "server_" + EngineVersion.VERSION.toString() + ".properties";
    private JButton m_startLocal;
    private JButton m_startPBEM;
    private JButton m_hostGame;
    private JButton m_connectToHostedGame;
    private JButton m_connectToLobby;
    private JButton m_enginePreferences;
    private JButton m_downloadMaps;
    private JButton m_ruleBook;
    private JButton m_donate;
    private JButton m_about;
    private final SetupPanelModel m_model;

    public MetaSetupPanel(SetupPanelModel model) {
        this.m_model = model;
        this.createComponents();
        this.layoutComponents();
        this.setupListeners();
        this.setWidgetActivation();
    }

    private void createComponents() {
        this.m_connectToLobby = new JButton("Play Online");
        Font bigButtonFont = new Font(this.m_connectToLobby.getFont().getName(), this.m_connectToLobby.getFont().getStyle(), this.m_connectToLobby.getFont().getSize() + 3);
        this.m_connectToLobby.setFont(bigButtonFont);
        this.m_connectToLobby.setToolTipText("<html>Find Games Online on the Lobby Server. <br>TripleA is MEANT to be played Online against other humans. <br>Any other way is not as fun!</html>");
        this.m_startLocal = new JButton("Start Local Game");
        this.m_startLocal.setToolTipText("<html>Start a game on this computer. <br>You can play against a friend sitting besides you (hotseat mode), <br>or against one of the AIs.</html>");
        this.m_startPBEM = new JButton("Start PBEM (Play-By-Email/Forum) Game");
        this.m_startPBEM.setToolTipText("<html>Starts a game which will be emailed back and forth between all players, <br>or be posted to an online forum or message board.</html>");
        this.m_hostGame = new JButton("Host Networked Game");
        this.m_hostGame.setToolTipText("<html>Hosts a network game, which people can connect to. <br>Anyone on a LAN will be able to connect. <br>Anyone from the internet can connect as well, but only if the host has configured port forwarding correctly.</html>");
        this.m_connectToHostedGame = new JButton("Connect to Networked Game");
        this.m_connectToHostedGame.setToolTipText("<html>Connects to someone's hosted game, <br>so long as you know their IP address.</html>");
        this.m_enginePreferences = new JButton("Engine Preferences");
        this.m_enginePreferences.setToolTipText("<html>Configure certain options related to the engine.");
        this.m_downloadMaps = new JButton("Download Maps");
        this.m_downloadMaps.setToolTipText("<html>Download new maps. Everyone should use this, <br>the best maps are online and have to be downloaded!</html>");
        this.m_ruleBook = new JButton("Rule Book");
        this.m_ruleBook.setToolTipText("<html>Download a manual of how to play <br>(it is also included in the directory TripleA was installed to).</html>");
        this.m_donate = new JButton("Donate");
        this.m_donate.setToolTipText("Help Support TripleA's development.");
        this.m_about = new JButton("About");
        this.m_about.setToolTipText("<html>See info about version number, developers, <br>official website, and a quick instruction on how to play.</html>");
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.add((Component)new JPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_connectToLobby, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.m_startLocal, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.m_startPBEM, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.m_hostGame, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.m_connectToHostedGame, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.m_enginePreferences, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.m_downloadMaps, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.m_ruleBook, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.m_donate, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.m_about, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(0, 100, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void setupListeners() {
        this.m_startLocal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MetaSetupPanel.this.m_model.showLocal();
            }
        });
        this.m_startPBEM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MetaSetupPanel.this.m_model.showPBEM();
            }
        });
        this.m_hostGame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MetaSetupPanel.this.m_model.showServer(MetaSetupPanel.this);
            }
        });
        this.m_connectToHostedGame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MetaSetupPanel.this.m_model.showClient(MetaSetupPanel.this);
            }
        });
        this.m_connectToLobby.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MetaSetupPanel.this.connectToLobby();
            }
        });
        this.m_enginePreferences.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MetaSetupPanel.this.enginePreferences();
            }
        });
        this.m_downloadMaps.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MetaSetupPanel.this.downloadMaps();
            }
        });
        this.m_ruleBook.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MetaSetupPanel.this.ruleBook();
            }
        });
        this.m_donate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    DesktopUtilityBrowserLauncher.openURL("https://sourceforge.net/donate/index.php?group_id=44492");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.m_about.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MetaSetupPanel.this.about();
            }
        });
    }

    private void downloadMaps() {
        DownloadMapDialog.downloadGames(this);
    }

    private void ruleBook() {
        try {
            DesktopUtilityBrowserLauncher.openURL("http://triplea.sourceforge.net/TripleA_RuleBook.pdf");
            DesktopUtilityBrowserLauncher.openURL("http://triplea.sourceforge.net/mywiki/Guides");
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex);
        }
    }

    private void enginePreferences() {
        EnginePreferences.showEnginePreferences(this);
    }

    private void about() {
        String text = "<h2>TripleA</h2><p><b>Engine Version:</b> " + EngineVersion.VERSION.toString() + "<br><b>Authors:</b> Sean Bridges, and many others. Current Developers: Veqryn (Chris Duncan)." + "<br>TripleA is an open-source game engine, allowing people to play many different games and maps." + "<br>For more information please visit:<br>" + "<b>Site:</b> <a hlink='http://triplea.sourceforge.net/'>http://triplea.sourceforge.net/</a><br>" + "<b>Forum:</b> <a hlink='http://triplea.sourceforge.net/mywiki/Forum'>http://triplea.sourceforge.net/mywiki/Forum</a><br>" + "<b>Ladder:</b> <a hlink='http://www.tripleawarclub.org/'>http://www.tripleawarclub.org/</a></p>" + "<p><b>Very Basic How to Play:</b>" + "<br>Though some games have special rules enforced, most games follow most of these basic guidelines.<br><ol>" + "<li>Players start their turn by choosing what they will produce.  They spend the money they gathered during their " + "<br>last turn on new units or even technology.  Units are displayed on the purchase screen as having x Cost, and " + "<br>their attack/defense/movement values.  These units will be put on the board at the end of the player's turn.</li>" + "<li>That Player then does a <em>Combat Move</em>, which means moving units to all the places they wish to attack this " + "<br>turn.  Simply click on a unit, then move your mouse to the territory you wish to attack, and then click again " + "<br>to drop it there.  You can deselect a unit by right-clicking.  You can select a path for a unit to take by holding " + "<br>down 'ctrl' and clicking on all the territories on the way to the final territory.  Pressing shift or ctrl while " + "<br>selecting a unit will select all units in that territory.</li>" + "<li>Then everyone resolves all the combat battles.  This involves rolling dice for the attacking units and the " + "<br>defending units too.  For example, a <em>Tank</em> might attack at a <em>3</em> meaning that when you roll the dice you need " + "<br>a 3 or less for him to <em>hit</em> the enemy.  If the tank hits the enemy, then the other player chooses one of his " + "<br>units to die, and the battle continues.  After each round of dice, the attacker chooses to retreat or press on " + "<br>until he has defeated all enemy units in that territory.  The game rolls the dice for you automatically.</li>" + "<li>After this, the Player may move any units that have not yet moved as a <em>Non-Combat</em> move, and any air units " + "<br>return to friendly territories to land.</li>" + "<li>When the player has completed all of this, then he or she may place the units that they have purchased at the " + "<br>beginning of their turn.  Then the game engine counts out the value of the territories they control and gives " + "<br>them that much money.  The next nation then begins their turn.  Games last until one side surrenders.</li></ol>" + "To see specific rules for each game, click <em>Game Notes</em> from inside that game, " + "<br> accessible from the <em>Help</em> menu button at the top of the screen inside a game.</p>";
        JEditorPane editorPane = new JEditorPane();
        editorPane.setBorder(null);
        editorPane.setBackground(this.getBackground());
        editorPane.setEditable(false);
        editorPane.setContentType("text/html");
        editorPane.setText(text);
        JScrollPane scroll = new JScrollPane(editorPane, 20, 30);
        scroll.setBorder(null);
        JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(this.getParent()), editorPane, "About...", -1);
    }

    private void connectToLobby() {
        LobbyLogin login;
        LobbyClient client;
        LobbyServerProperties props = this.getLobbyServerProperties();
        if (props == null) {
            props = new LobbyServerProperties(null, -1, "<html>Server Lookup failed, try again later. <br>Either TripleA could not reach the internet, or the server host is down. <br>Please make sure you are using the latest version of TripleA: http://triplea.sourceforge.net/</html>", null);
        }
        if (System.getProperties().getProperty("triplea.lobby.debug") != null) {
            props = new LobbyServerProperties("127.0.0.1", 3304, "", "the server says");
        }
        if ((client = (login = new LobbyLogin(JOptionPane.getFrameForComponent(this), props)).login()) == null) {
            return;
        }
        LobbyFrame lobbyFrame = new LobbyFrame(client, props);
        NewGameChooser.clearNewGameChooserModel();
        MainFrame.getInstance().setVisible(false);
        MainFrame.getInstance().dispose();
        lobbyFrame.setVisible(true);
    }

    private LobbyServerProperties getLobbyServerProperties() {
        File f = new File(GameRunner2.getRootFolder(), "lobby.properties");
        if (f.exists()) {
            Properties props = new Properties();
            try {
                FileInputStream fis = new FileInputStream(f);
                props.load(fis);
                return new LobbyServerProperties(props);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        List<URL> serverPropsList = this.getServerLookupURL();
        if (serverPropsList == null || serverPropsList.isEmpty()) {
            throw new IllegalStateException("No Server Properties Found!");
        }
        Iterator<URL> iter = serverPropsList.iterator();
        LobbyServerProperties props = null;
        while (iter.hasNext() && (props == null || props.getPort() == -1)) {
            URL serverPropertiesURL = iter.next();
            props = this.contactServerForLobbyServerProperties(serverPropertiesURL);
        }
        return props;
    }

    private LobbyServerProperties contactServerForLobbyServerProperties(final URL serverPropsURL) {
        if (s_logger.isLoggable(Level.FINE)) {
            s_logger.log(Level.FINE, "lobby url:" + serverPropsURL);
        }
        final AtomicReference ref = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 5; ++i) {
                    this.spawnRequest(serverPropsURL, ref, latch);
                    try {
                        latch.await(2L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (ref.get() != null) break;
                }
                try {
                    latch.await(15L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }

            private void spawnRequest(final URL serverPropsURL2, final AtomicReference<LobbyServerProperties> ref2, final CountDownLatch latch2) {
                Thread t1 = new Thread(new Runnable(){

                    public void run() {
                        ref2.set(new LobbyServerProperties(serverPropsURL2));
                        latch2.countDown();
                    }
                });
                t1.start();
            }
        };
        BackgroundTaskRunner.runInBackground(this, "Looking Up Server", r);
        LobbyServerProperties props = (LobbyServerProperties)ref.get();
        return props;
    }

    private List<URL> getServerLookupURL() {
        ArrayList<URL> rVal = new ArrayList<URL>();
        String propertyString = System.getProperties().getProperty("triplea.lobby.server.lookup.url");
        if (propertyString != null) {
            try {
                URL propertyURL = new URL(propertyString);
                rVal.add(propertyURL);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            return rVal;
        }
        try {
            rVal.add(new URL("http://triplea.sourceforge.net/lobby/" + s_serverPropertiesName));
            rVal.add(new URL("http://www.tripleawarclub.org/lobby/" + s_serverPropertiesName));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return rVal;
    }

    @Override
    public void setWidgetActivation() {
        if (this.m_model == null || this.m_model.getGameSelectorModel() == null || this.m_model.getGameSelectorModel().getGameData() == null) {
            this.m_startLocal.setEnabled(false);
            this.m_startPBEM.setEnabled(false);
            this.m_hostGame.setEnabled(false);
        } else {
            this.m_startLocal.setEnabled(true);
            this.m_startPBEM.setEnabled(true);
            this.m_hostGame.setEnabled(true);
        }
    }

    @Override
    public boolean canGameStart() {
        return false;
    }

    @Override
    public void shutDown() {
    }

    @Override
    public void cancel() {
    }
}

