/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.framework.startup.LocalBeanCache;
import games.strategy.engine.framework.startup.launcher.ILauncher;
import games.strategy.engine.framework.startup.launcher.LocalLauncher;
import games.strategy.engine.framework.startup.mc.GameSelectorModel;
import games.strategy.engine.framework.startup.ui.SetupPanel;
import games.strategy.engine.framework.startup.ui.editors.IBean;
import games.strategy.engine.framework.startup.ui.editors.SelectAndViewEditor;
import games.strategy.engine.pbem.GenericEmailSender;
import games.strategy.engine.pbem.GmailEmailSender;
import games.strategy.engine.pbem.HotmailEmailSender;
import games.strategy.engine.pbem.IEmailSender;
import games.strategy.engine.pbem.IForumPoster;
import games.strategy.engine.pbem.IWebPoster;
import games.strategy.engine.pbem.NullEmailSender;
import games.strategy.engine.pbem.NullForumPoster;
import games.strategy.engine.pbem.NullWebPoster;
import games.strategy.engine.pbem.TripleAWarClubForumPoster;
import games.strategy.engine.pbem.TripleAWebPoster;
import games.strategy.engine.random.IRemoteDiceServer;
import games.strategy.engine.random.InternalDiceServer;
import games.strategy.engine.random.PBEMDiceRoller;
import games.strategy.engine.random.PropertiesDiceRoller;
import games.strategy.triplea.pbem.AxisAndAlliesForumPoster;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBEMSetupPanel
extends SetupPanel
implements Observer {
    private static final long serialVersionUID = 9006941131918034674L;
    private static final String DICE_ROLLER = "games.strategy.engine.random.IRemoteDiceServer";
    private final GameSelectorModel m_gameSelectorModel;
    private final SelectAndViewEditor m_diceServerEditor;
    private final SelectAndViewEditor m_forumPosterEditor;
    private final SelectAndViewEditor m_emailSenderEditor;
    private final SelectAndViewEditor m_webPosterEditor;

    public PBEMSetupPanel(GameSelectorModel model) {
        this.m_gameSelectorModel = model;
        this.m_gameSelectorModel.addObserver(this);
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.m_diceServerEditor = new SelectAndViewEditor("Dice Server", "");
        this.m_forumPosterEditor = new SelectAndViewEditor("Post to Forum", "forumPosters.html");
        this.m_emailSenderEditor = new SelectAndViewEditor("Provider", "emailSenders.html");
        this.m_webPosterEditor = new SelectAndViewEditor("Send to Website", "websiteSenders.html");
        int row = 0;
        this.add((Component)this.m_diceServerEditor, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 0, 20, 0), 0, 0));
        this.m_forumPosterEditor.setBorder(new TitledBorder("Play By Forum"));
        this.add((Component)this.m_forumPosterEditor, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 20, 0), 0, 0));
        JPanel emailPanel = new JPanel(new GridBagLayout());
        emailPanel.setBorder(new TitledBorder("Play By Email"));
        this.add((Component)emailPanel, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 20, 0), 0, 0));
        int panelRow = 0;
        emailPanel.add((Component)this.m_emailSenderEditor, new GridBagConstraints(0, panelRow++, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 2, 0), 0, 0));
        this.m_webPosterEditor.setBorder(new TitledBorder("Play By Web Site"));
        this.add((Component)this.m_webPosterEditor, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 10, 0), 0, 0));
        this.setupListeners();
        if (this.m_gameSelectorModel.getGameData() != null) {
            this.loadAll();
        }
        this.setWidgetActivation();
    }

    @Override
    public void setWidgetActivation() {
    }

    private void setupListeners() {
        this.m_diceServerEditor.addPropertyChangeListener(new NotifyingPropertyChangeListener());
        this.m_forumPosterEditor.addPropertyChangeListener(new NotifyingPropertyChangeListener());
        this.m_emailSenderEditor.addPropertyChangeListener(new NotifyingPropertyChangeListener());
        this.m_webPosterEditor.addPropertyChangeListener(new NotifyingPropertyChangeListener());
    }

    private void loadAll() {
        this.loadDiceServer(this.m_gameSelectorModel.getGameData());
        this.loadForumPosters(this.m_gameSelectorModel.getGameData());
        this.loadEmailSender(this.m_gameSelectorModel.getGameData());
        this.loadWebPosters(this.m_gameSelectorModel.getGameData());
    }

    private void loadDiceServer(GameData data) {
        IRemoteDiceServer roller;
        ArrayList<PropertiesDiceRoller> diceRollers = new ArrayList<PropertiesDiceRoller>(PropertiesDiceRoller.loadFromFile());
        diceRollers.add((PropertiesDiceRoller)((Object)new InternalDiceServer()));
        for (IRemoteDiceServer iRemoteDiceServer : diceRollers) {
            IRemoteDiceServer cached = (IRemoteDiceServer)LocalBeanCache.getInstance().getSerializable(iRemoteDiceServer.getDisplayName());
            if (cached == null) continue;
            iRemoteDiceServer.setCcAddress(cached.getCcAddress());
            iRemoteDiceServer.setToAddress(cached.getToAddress());
            iRemoteDiceServer.setGameId(cached.getGameId());
        }
        this.m_diceServerEditor.setBeans(diceRollers);
        if (this.m_gameSelectorModel.isSavedGame() && (roller = (IRemoteDiceServer)data.getProperties().get(DICE_ROLLER)) != null) {
            this.m_diceServerEditor.setSelectedBean(roller);
        }
    }

    private void loadForumPosters(GameData data) {
        ArrayList<IForumPoster> forumPosters = new ArrayList<IForumPoster>();
        forumPosters.add((IForumPoster)this.findCachedOrCreateNew(NullForumPoster.class));
        forumPosters.add((IForumPoster)this.findCachedOrCreateNew(AxisAndAlliesForumPoster.class));
        forumPosters.add((IForumPoster)this.findCachedOrCreateNew(TripleAWarClubForumPoster.class));
        this.m_forumPosterEditor.setBeans(forumPosters);
        IForumPoster forumPoster = (IForumPoster)data.getProperties().get("games.strategy.engine.pbem.IForumPoster");
        if (forumPoster != null) {
            IForumPoster cached = (IForumPoster)LocalBeanCache.getInstance().getSerializable(forumPoster.getClass().getCanonicalName());
            if (cached != null) {
                forumPoster.setUsername(cached.getUsername());
                forumPoster.setPassword(cached.getPassword());
            }
            this.m_forumPosterEditor.setSelectedBean(forumPoster);
        }
    }

    private void loadWebPosters(GameData data) {
        ArrayList<IWebPoster> webPosters = new ArrayList<IWebPoster>();
        webPosters.add((IWebPoster)this.findCachedOrCreateNew(NullWebPoster.class));
        TripleAWebPoster poster = (TripleAWebPoster)this.findCachedOrCreateNew(TripleAWebPoster.class);
        poster.setParties(data.getPlayerList().getNames());
        webPosters.add(poster);
        this.m_webPosterEditor.setBeans(webPosters);
        IWebPoster webPoster = (IWebPoster)data.getProperties().get("games.strategy.engine.pbem.IWebPoster");
        if (webPoster != null) {
            poster.addToAllHosts(webPoster.getHost());
            webPoster.setAllHosts(poster.getAllHosts());
            this.m_webPosterEditor.setSelectedBean(webPoster);
        }
    }

    private void loadEmailSender(GameData data) {
        ArrayList<IEmailSender> emailSenders = new ArrayList<IEmailSender>();
        emailSenders.add((IEmailSender)this.findCachedOrCreateNew(NullEmailSender.class));
        emailSenders.add((IEmailSender)this.findCachedOrCreateNew(GmailEmailSender.class));
        emailSenders.add((IEmailSender)this.findCachedOrCreateNew(HotmailEmailSender.class));
        emailSenders.add((IEmailSender)this.findCachedOrCreateNew(GenericEmailSender.class));
        this.m_emailSenderEditor.setBeans(emailSenders);
        IEmailSender sender = (IEmailSender)data.getProperties().get("games.strategy.engine.pbem.IEmailSender");
        if (sender != null) {
            IEmailSender cached = (IEmailSender)LocalBeanCache.getInstance().getSerializable(sender.getClass().getCanonicalName());
            if (cached != null) {
                sender.setUserName(cached.getUserName());
                sender.setPassword(cached.getPassword());
            }
            this.m_emailSenderEditor.setSelectedBean(sender);
        }
    }

    private IBean findCachedOrCreateNew(Class<? extends IBean> theClassType) {
        IBean cached = LocalBeanCache.getInstance().getSerializable(theClassType.getCanonicalName());
        if (cached == null) {
            try {
                cached = theClassType.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Bean of type " + theClassType + " doesn't have public default constructor, error: " + e.getMessage());
            }
        }
        return cached;
    }

    @Override
    public void shutDown() {
        this.m_gameSelectorModel.deleteObserver(this);
    }

    @Override
    public void cancel() {
        this.m_gameSelectorModel.deleteObserver(this);
    }

    @Override
    public boolean canGameStart() {
        boolean diceServerValid = this.m_diceServerEditor.isBeanValid();
        boolean summaryValid = this.m_forumPosterEditor.isBeanValid();
        boolean webSiteValid = this.m_webPosterEditor.isBeanValid();
        boolean emailValid = this.m_emailSenderEditor.isBeanValid();
        return diceServerValid && summaryValid && emailValid && webSiteValid && this.m_gameSelectorModel.getGameData() != null;
    }

    @Override
    public void postStartGame() {
        IWebPoster webPoster;
        IEmailSender sender;
        GameData data = this.m_gameSelectorModel.getGameData();
        data.getProperties().set(DICE_ROLLER, this.m_diceServerEditor.getBean());
        IForumPoster poster = (IForumPoster)this.m_forumPosterEditor.getBean();
        if (poster != null) {
            IForumPoster summaryPoster = poster;
            summaryPoster = summaryPoster.doClone();
            summaryPoster.clearSensitiveInfo();
            data.getProperties().set("games.strategy.engine.pbem.IForumPoster", summaryPoster);
        }
        if ((sender = (IEmailSender)this.m_emailSenderEditor.getBean()) != null) {
            sender = sender.doClone();
            sender.clearSensitiveInfo();
            data.getProperties().set("games.strategy.engine.pbem.IEmailSender", sender);
        }
        if ((webPoster = (IWebPoster)this.m_webPosterEditor.getBean()) != null) {
            webPoster = webPoster.doClone();
            webPoster.clearSensitiveInfo();
            data.getProperties().set("games.strategy.engine.pbem.IWebPoster", webPoster);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PBEMSetupPanel.this.loadAll();
                }
            });
        } else {
            this.loadAll();
        }
    }

    @Override
    public ILauncher getLauncher() {
        IWebPoster web;
        IEmailSender sender;
        IForumPoster poster = (IForumPoster)this.m_forumPosterEditor.getBean();
        if (poster != null) {
            LocalBeanCache.getInstance().storeSerializable(poster.getClass().getCanonicalName(), poster);
        }
        if ((sender = (IEmailSender)this.m_emailSenderEditor.getBean()) != null) {
            LocalBeanCache.getInstance().storeSerializable(sender.getClass().getCanonicalName(), sender);
        }
        if ((web = (IWebPoster)this.m_webPosterEditor.getBean()) != null) {
            LocalBeanCache.getInstance().storeSerializable(web.getClass().getCanonicalName(), web);
        }
        IRemoteDiceServer server = (IRemoteDiceServer)this.m_diceServerEditor.getBean();
        LocalBeanCache.getInstance().storeSerializable(server.getDisplayName(), server);
        LocalBeanCache.getInstance().writeToDisk();
        String gameUUID = (String)this.m_gameSelectorModel.getGameData().getProperties().get("GAME_UUID");
        PBEMDiceRoller randomSource = new PBEMDiceRoller((IRemoteDiceServer)this.m_diceServerEditor.getBean(), gameUUID);
        HashMap<String, String> playerTypes = new HashMap<String, String>();
        String playerType = this.m_gameSelectorModel.getGameData().getGameLoader().getServerPlayerTypes()[0];
        for (String playerName : this.m_gameSelectorModel.getGameData().getPlayerList().getNames()) {
            playerTypes.put(playerName, playerType);
        }
        return new LocalLauncher(this.m_gameSelectorModel, randomSource, playerTypes);
    }

    private class NotifyingPropertyChangeListener
    implements PropertyChangeListener {
        private NotifyingPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            PBEMSetupPanel.this.notifyObservers();
        }
    }
}

