/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.ui;

import games.strategy.engine.framework.GameRunner2;
import games.strategy.ui.IntTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class ServerOptions
extends JDialog {
    private static final long serialVersionUID = -9074816386666798281L;
    private JTextField m_nameField;
    private IntTextField m_portField;
    private JPasswordField m_passwordField;
    private boolean m_okPressed;
    private JCheckBox m_requirePasswordCheckBox;
    private JTextField m_comment;
    private boolean m_showComment = false;
    private final Action m_okAction = new AbstractAction("OK"){
        private static final long serialVersionUID = -479176526245850045L;

        public void actionPerformed(ActionEvent e) {
            ServerOptions.this.setVisible(false);
            ServerOptions.this.m_okPressed = true;
        }
    };
    private final Action m_cancelAction = new AbstractAction("Cancel"){
        private static final long serialVersionUID = 6591074291179846696L;

        public void actionPerformed(ActionEvent e) {
            ServerOptions.this.setVisible(false);
        }
    };

    public ServerOptions(Component owner, String defaultName, int defaultPort, boolean showComment) {
        super(owner == null ? null : JOptionPane.getFrameForComponent(owner), "Server options", true);
        this.m_showComment = showComment;
        this.initComponents();
        this.layoutComponents();
        this.setupActions();
        this.m_nameField.setText(defaultName);
        this.m_portField.setValue(defaultPort);
        this.setWidgetActivation();
        this.pack();
    }

    public void setNameEditable(boolean editable) {
        this.m_nameField.setEditable(editable);
    }

    private void setupActions() {
        this.m_requirePasswordCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServerOptions.this.setWidgetActivation();
            }
        });
    }

    public String getName() {
        String s = this.m_nameField.getText().trim();
        if (s.length() > 20) {
            return s.substring(0, 20);
        }
        return s;
    }

    public String getPassword() {
        if (!this.m_requirePasswordCheckBox.isSelected()) {
            return null;
        }
        String password = new String(this.m_passwordField.getPassword());
        if (password.trim().length() == 0) {
            return null;
        }
        return password;
    }

    public int getPort() {
        return this.m_portField.getValue();
    }

    private void initComponents() {
        this.m_nameField = new JTextField(10);
        this.m_portField = new IntTextField(0, Integer.MAX_VALUE);
        this.m_portField.setColumns(7);
        this.m_passwordField = new JPasswordField();
        this.m_passwordField.setColumns(10);
        this.m_comment = new JTextField();
        this.m_comment.setColumns(20);
    }

    private void layoutComponents() {
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        JPanel title = new JPanel();
        title.add(new JLabel("Select server options"));
        content.add((Component)title, "North");
        Insets labelSpacing = new Insets(3, 7, 0, 0);
        Insets fieldSpacing = new Insets(3, 5, 0, 7);
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.anchor = 17;
        labelConstraints.gridx = 0;
        labelConstraints.insets = labelSpacing;
        GridBagConstraints fieldConstraints = new GridBagConstraints();
        fieldConstraints.anchor = 17;
        fieldConstraints.gridx = 1;
        fieldConstraints.insets = fieldSpacing;
        this.m_requirePasswordCheckBox = new JCheckBox("");
        JLabel passwordRequiredLabel = new JLabel("Require Password:");
        JPanel fields = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        fields.setLayout(layout);
        JLabel nameLabel = new JLabel("Name:");
        JLabel portLabel = new JLabel("Port:");
        JLabel passwordLabel = new JLabel("Password:");
        JLabel commentLabel = new JLabel("Comments:");
        layout.setConstraints(portLabel, labelConstraints);
        layout.setConstraints(nameLabel, labelConstraints);
        layout.setConstraints(passwordLabel, labelConstraints);
        layout.setConstraints(this.m_portField, fieldConstraints);
        layout.setConstraints(this.m_nameField, fieldConstraints);
        layout.setConstraints(this.m_passwordField, fieldConstraints);
        layout.setConstraints(this.m_requirePasswordCheckBox, fieldConstraints);
        layout.setConstraints(passwordRequiredLabel, labelConstraints);
        fields.add(nameLabel);
        fields.add(this.m_nameField);
        fields.add(portLabel);
        fields.add(this.m_portField);
        fields.add(passwordRequiredLabel);
        fields.add(this.m_requirePasswordCheckBox);
        fields.add(passwordLabel);
        fields.add(this.m_passwordField);
        if (this.m_showComment) {
            layout.setConstraints(commentLabel, labelConstraints);
            layout.setConstraints(this.m_comment, fieldConstraints);
            fields.add(commentLabel);
            fields.add(this.m_comment);
        }
        content.add((Component)fields, "Center");
        JPanel buttons = new JPanel();
        buttons.add(new JButton(this.m_okAction));
        buttons.add(new JButton(this.m_cancelAction));
        content.add((Component)buttons, "South");
    }

    public boolean getOKPressed() {
        return this.m_okPressed;
    }

    private void setWidgetActivation() {
        this.m_passwordField.setEnabled(this.m_requirePasswordCheckBox.isSelected());
        Color backGround = this.m_passwordField.isEnabled() ? this.m_portField.getBackground() : this.getBackground();
        this.m_passwordField.setBackground(backGround);
        if (GameRunner2.areWeOldExtraJar() && System.getProperty("triplea.server", "false").equalsIgnoreCase("true")) {
            this.setNameEditable(false);
        }
    }

    public String getComments() {
        return this.m_comment.getText();
    }
}

