/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.ui;

import games.strategy.common.ui.InGameLobbyWatcherWrapper;
import games.strategy.engine.chat.IChatPanel;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.framework.HeadlessGameServer;
import games.strategy.engine.framework.IGame;
import games.strategy.engine.framework.networkMaintenance.BanPlayerAction;
import games.strategy.engine.framework.networkMaintenance.BootPlayerAction;
import games.strategy.engine.framework.networkMaintenance.MutePlayerAction;
import games.strategy.engine.framework.networkMaintenance.SetPasswordAction;
import games.strategy.engine.framework.startup.launcher.ILauncher;
import games.strategy.engine.framework.startup.launcher.ServerLauncher;
import games.strategy.engine.framework.startup.login.ClientLoginValidator;
import games.strategy.engine.framework.startup.mc.GameSelectorModel;
import games.strategy.engine.framework.startup.mc.IRemoteModelListener;
import games.strategy.engine.framework.startup.mc.ServerModel;
import games.strategy.engine.framework.startup.ui.InGameLobbyWatcher;
import games.strategy.engine.framework.startup.ui.SetupPanel;
import games.strategy.engine.lobby.client.ui.action.EditGameCommentAction;
import games.strategy.engine.lobby.client.ui.action.RemoveGameFromLobbyAction;
import games.strategy.net.IServerMessenger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerSetupPanel
extends SetupPanel
implements IRemoteModelListener {
    private static final long serialVersionUID = -2849872641665561807L;
    private final ServerModel m_model;
    private JTextField m_portField;
    private JTextField m_addressField;
    private JTextField m_nameField;
    private List<PlayerRow> m_playerRows = new ArrayList<PlayerRow>();
    private final GameSelectorModel m_gameSelectorModel;
    private JPanel m_info;
    private JPanel m_networkPanel;
    private final InGameLobbyWatcherWrapper m_lobbyWatcher = new InGameLobbyWatcherWrapper();

    public ServerSetupPanel(ServerModel model, GameSelectorModel gameSelectorModel) {
        this.m_model = model;
        this.m_gameSelectorModel = gameSelectorModel;
        this.m_model.setRemoteModelListener(this);
        this.createLobbyWatcher();
        this.createComponents();
        this.layoutComponents();
        this.setupListeners();
        this.setWidgetActivation();
        this.internalPlayerListChanged();
    }

    public void createLobbyWatcher() {
        this.m_lobbyWatcher.setInGameLobbyWatcher(InGameLobbyWatcher.newInGameLobbyWatcher(this.m_model.getMessenger(), this, this.m_lobbyWatcher.getInGameLobbyWatcher()));
        if (this.m_lobbyWatcher != null) {
            this.m_lobbyWatcher.setGameSelectorModel(this.m_gameSelectorModel);
        }
    }

    public synchronized void repostLobbyWatcher(IGame iGame) {
        if (iGame != null) {
            return;
        }
        if (this.canGameStart()) {
            return;
        }
        System.out.println("Restarting lobby watcher");
        this.shutDownLobbyWatcher();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        HeadlessGameServer.resetLobbyHostOldExtensionProperties();
        this.createLobbyWatcher();
    }

    public void shutDownLobbyWatcher() {
        if (this.m_lobbyWatcher != null) {
            this.m_lobbyWatcher.shutDown();
        }
    }

    private void createComponents() {
        IServerMessenger messenger = this.m_model.getMessenger();
        Color backGround = new JTextField().getBackground();
        this.m_portField = new JTextField("" + messenger.getLocalNode().getPort());
        this.m_portField.setEnabled(true);
        this.m_portField.setEditable(false);
        this.m_portField.setBackground(backGround);
        this.m_portField.setColumns(6);
        this.m_addressField = new JTextField(messenger.getLocalNode().getAddress().getHostAddress());
        this.m_addressField.setEnabled(true);
        this.m_addressField.setEditable(false);
        this.m_addressField.setBackground(backGround);
        this.m_addressField.setColumns(20);
        this.m_nameField = new JTextField(messenger.getLocalNode().getName());
        this.m_nameField.setEnabled(true);
        this.m_nameField.setEditable(false);
        this.m_nameField.setBackground(backGround);
        this.m_nameField.setColumns(20);
        this.m_info = new JPanel();
        this.m_networkPanel = new JPanel();
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        this.m_info.setLayout(new GridBagLayout());
        this.m_info.add((Component)new JLabel("Name:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 5), 0, 0));
        this.m_info.add((Component)new JLabel("Address:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 5), 0, 0));
        this.m_info.add((Component)new JLabel("Port:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 5), 0, 0));
        this.m_info.add((Component)this.m_nameField, new GridBagConstraints(1, 0, 1, 1, 0.5, 1.0, 17, 1, new Insets(5, 0, 0, 5), 0, 0));
        this.m_info.add((Component)this.m_addressField, new GridBagConstraints(1, 1, 1, 1, 0.5, 1.0, 17, 1, new Insets(5, 0, 0, 5), 0, 0));
        this.m_info.add((Component)this.m_portField, new GridBagConstraints(1, 2, 1, 1, 0.5, 1.0, 17, 1, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)this.m_info, "North");
    }

    private void layoutPlayers() {
        JPanel players = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        players.setLayout(layout);
        Insets spacing = new Insets(3, 23, 0, 0);
        Insets lastSpacing = new Insets(3, 23, 0, 23);
        GridBagConstraints nameConstraints = new GridBagConstraints();
        nameConstraints.anchor = 17;
        nameConstraints.gridx = 0;
        nameConstraints.insets = spacing;
        GridBagConstraints playerConstraints = new GridBagConstraints();
        playerConstraints.anchor = 17;
        playerConstraints.gridx = 1;
        playerConstraints.insets = spacing;
        GridBagConstraints localConstraints = new GridBagConstraints();
        localConstraints.anchor = 17;
        localConstraints.gridx = 2;
        localConstraints.insets = spacing;
        GridBagConstraints typeConstraints = new GridBagConstraints();
        typeConstraints.anchor = 17;
        typeConstraints.gridx = 3;
        typeConstraints.insets = spacing;
        GridBagConstraints allianceConstraints = new GridBagConstraints();
        allianceConstraints.anchor = 17;
        allianceConstraints.gridx = 4;
        allianceConstraints.insets = lastSpacing;
        JLabel nameLabel = new JLabel("Name");
        nameLabel.setForeground(Color.black);
        layout.setConstraints(nameLabel, nameConstraints);
        players.add(nameLabel);
        JLabel playedByLabel = new JLabel("Played by");
        playedByLabel.setForeground(Color.black);
        layout.setConstraints(playedByLabel, playerConstraints);
        players.add(playedByLabel);
        JLabel localLabel = new JLabel("Local");
        localLabel.setForeground(Color.black);
        layout.setConstraints(localLabel, localConstraints);
        players.add(localLabel);
        JLabel typeLabel = new JLabel("Type");
        typeLabel.setForeground(Color.black);
        layout.setConstraints(typeLabel, typeConstraints);
        players.add(typeLabel);
        JLabel allianceLabel = new JLabel("Alliance");
        allianceLabel.setForeground(Color.black);
        layout.setConstraints(allianceLabel, allianceConstraints);
        players.add(allianceLabel);
        Iterator<PlayerRow> iter = this.m_playerRows.iterator();
        if (!iter.hasNext()) {
            JLabel noPlayers = new JLabel("Load a game file first");
            layout.setConstraints(noPlayers, nameConstraints);
            players.add(noPlayers);
        }
        while (iter.hasNext()) {
            PlayerRow row = iter.next();
            layout.setConstraints(row.getName(), nameConstraints);
            players.add(row.getName());
            layout.setConstraints(row.getPlayer(), playerConstraints);
            players.add(row.getPlayer());
            layout.setConstraints(row.getLocal(), localConstraints);
            players.add(row.getLocal());
            layout.setConstraints(row.getType(), typeConstraints);
            players.add(row.getType());
            layout.setConstraints(row.getAlliance(), allianceConstraints);
            players.add(row.getAlliance());
        }
        this.removeAll();
        this.add((Component)this.m_info, "North");
        JScrollPane scroll = new JScrollPane(players, 20, 30);
        scroll.setBorder(null);
        scroll.setViewportBorder(null);
        this.add((Component)scroll, "Center");
        this.add((Component)this.m_networkPanel, "South");
        this.invalidate();
        this.validate();
    }

    private void setupListeners() {
    }

    @Override
    public void setWidgetActivation() {
    }

    @Override
    public void shutDown() {
        this.m_model.setRemoteModelListener(IRemoteModelListener.NULL_LISTENER);
        this.m_model.shutDown();
        if (this.m_lobbyWatcher != null) {
            this.m_lobbyWatcher.shutDown();
        }
    }

    @Override
    public void cancel() {
        this.m_model.setRemoteModelListener(IRemoteModelListener.NULL_LISTENER);
        this.m_model.cancel();
        if (this.m_lobbyWatcher != null) {
            this.m_lobbyWatcher.shutDown();
        }
    }

    @Override
    public boolean canGameStart() {
        if (this.m_gameSelectorModel.getGameData() == null || this.m_model == null) {
            return false;
        }
        Map<String, String> players = this.m_model.getPlayers();
        if (players == null || players.isEmpty()) {
            return false;
        }
        for (String player : players.keySet()) {
            if (players.get(player) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void playerListChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ServerSetupPanel.this.internalPlayerListChanged();
            }
        });
    }

    @Override
    public void playersTakenChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ServerSetupPanel.this.internalPlayersTakenChanged();
            }
        });
    }

    private void internalPlayersTakenChanged() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Wrong thread");
        }
        Map<String, String> players = this.m_model.getPlayers();
        for (PlayerRow row : this.m_playerRows) {
            row.update(players);
        }
        super.notifyObservers();
    }

    private void internalPlayerListChanged() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Wrong thread");
        }
        this.m_playerRows = new ArrayList<PlayerRow>();
        Map<String, String> players = this.m_model.getPlayers();
        Map<String, Collection<String>> m_playerNamesAndAlliancesInTurnOrder = this.m_model.getPlayerNamesAndAlliancesInTurnOrderLinkedHashMap();
        LinkedHashMap<String, String> reloadSelections = PlayerID.currentPlayers(this.m_gameSelectorModel.getGameData());
        Set<String> playerNames = m_playerNamesAndAlliancesInTurnOrder.keySet();
        for (String name : playerNames) {
            PlayerRow newPlayerRow = new PlayerRow(name, reloadSelections, m_playerNamesAndAlliancesInTurnOrder.get(name), this.m_gameSelectorModel.getGameData().getGameLoader().getServerPlayerTypes());
            this.m_playerRows.add(newPlayerRow);
            newPlayerRow.update(players);
        }
        this.layoutPlayers();
        this.internalPlayersTakenChanged();
    }

    @Override
    public IChatPanel getChatPanel() {
        return this.m_model.getChatPanel();
    }

    public ServerModel getModel() {
        return this.m_model;
    }

    @Override
    public synchronized ILauncher getLauncher() {
        ServerLauncher launcher = (ServerLauncher)this.m_model.getLauncher();
        if (launcher == null) {
            return null;
        }
        launcher.setInGameLobbyWatcher(this.m_lobbyWatcher);
        return launcher;
    }

    @Override
    public List<Action> getUserActions() {
        ArrayList<Action> rVal = new ArrayList<Action>();
        rVal.add(new BootPlayerAction(this, this.m_model.getMessenger()));
        rVal.add(new BanPlayerAction(this, this.m_model.getMessenger()));
        rVal.add(new MutePlayerAction(this, this.m_model.getMessenger()));
        rVal.add(new SetPasswordAction(this, this.m_lobbyWatcher, (ClientLoginValidator)this.m_model.getMessenger().getLoginValidator()));
        if (this.m_lobbyWatcher != null && this.m_lobbyWatcher.isActive()) {
            rVal.add(new EditGameCommentAction(this.m_lobbyWatcher, this));
            rVal.add(new RemoveGameFromLobbyAction(this.m_lobbyWatcher));
        }
        return rVal;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PlayerRow {
        private final JLabel m_nameLabel;
        private final JLabel m_playerLabel;
        private final JCheckBox m_localCheckBox;
        private final JComboBox m_type;
        private JLabel m_alliance;
        private final ActionListener m_actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (PlayerRow.this.m_localCheckBox.isSelected()) {
                    ServerSetupPanel.this.m_model.takePlayer(PlayerRow.this.m_nameLabel.getText());
                } else {
                    ServerSetupPanel.this.m_model.releasePlayer(PlayerRow.this.m_nameLabel.getText());
                }
                PlayerRow.this.setWidgetActivation();
            }
        };

        PlayerRow(String playerName, Map<String, String> reloadSelections, Collection<String> playerAlliances, String[] types) {
            this.m_nameLabel = new JLabel(playerName);
            this.m_playerLabel = new JLabel(ServerSetupPanel.this.m_model.getMessenger().getLocalNode().getName());
            this.m_localCheckBox = new JCheckBox();
            this.m_localCheckBox.addActionListener(this.m_actionListener);
            this.m_localCheckBox.setSelected(true);
            this.m_type = new JComboBox<String>(types);
            String previousSelection = reloadSelections.get(playerName);
            if (previousSelection.equalsIgnoreCase("Client")) {
                previousSelection = "Human";
            }
            if (!previousSelection.equals("no_one") && Arrays.asList(types).contains(previousSelection)) {
                this.m_type.setSelectedItem(previousSelection);
                ServerSetupPanel.this.m_model.setLocalPlayerType(this.m_nameLabel.getText(), (String)this.m_type.getSelectedItem());
            } else if (playerName.startsWith("Neutral") || playerName.startsWith("AI")) {
                this.m_type.setSelectedItem("Moore N. Able (AI)");
                ServerSetupPanel.this.m_model.setLocalPlayerType(this.m_nameLabel.getText(), (String)this.m_type.getSelectedItem());
            }
            this.m_alliance = playerAlliances.contains(playerName) ? new JLabel() : new JLabel(playerAlliances.toString());
            this.m_type.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ServerSetupPanel.this.m_model.setLocalPlayerType(PlayerRow.this.m_nameLabel.getText(), (String)PlayerRow.this.m_type.getSelectedItem());
                }
            });
        }

        public JComboBox getType() {
            return this.m_type;
        }

        public JLabel getName() {
            return this.m_nameLabel;
        }

        public JLabel getAlliance() {
            return this.m_alliance;
        }

        public JLabel getPlayer() {
            return this.m_playerLabel;
        }

        public JCheckBox getLocal() {
            return this.m_localCheckBox;
        }

        public void update(Map<String, String> players) {
            String text = players.get(this.m_nameLabel.getText());
            if (text == null) {
                text = "-";
            }
            this.m_playerLabel.setText(text);
            this.m_localCheckBox.setSelected(text.equals(ServerSetupPanel.this.m_model.getMessenger().getLocalNode().getName()));
            this.setWidgetActivation();
        }

        private void setWidgetActivation() {
            this.m_type.setEnabled(this.m_localCheckBox.isSelected());
        }
    }
}

