/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.ui.editors;

import games.strategy.engine.framework.GameRunner2;
import games.strategy.engine.framework.startup.ui.MainFrame;
import games.strategy.engine.framework.startup.ui.editors.EditorPanel;
import games.strategy.engine.framework.startup.ui.editors.IBean;
import games.strategy.engine.framework.startup.ui.editors.validators.EmailValidator;
import games.strategy.engine.framework.startup.ui.editors.validators.IntegerRangeValidator;
import games.strategy.engine.pbem.GenericEmailSender;
import games.strategy.engine.pbem.IEmailSender;
import games.strategy.ui.ProgressWindow;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class EmailSenderEditor
extends EditorPanel {
    private static final long serialVersionUID = -4647781117491269926L;
    private final GenericEmailSender m_bean;
    private final JTextField m_subject = new JTextField();
    private final JTextField m_toAddress = new JTextField();
    private final JTextField m_host = new JTextField();
    private final JTextField m_port = new JTextField();
    private final JTextField m_login = new JTextField();
    private final JCheckBox m_useTLS = new JCheckBox("Use TLS encryption");
    private final JTextField m_password = new JPasswordField();
    private final JLabel m_toLabel = new JLabel("To:");
    private final JLabel m_loginLabel = new JLabel("Login:");
    private final JLabel m_passwordLabel = new JLabel("Password:");
    private final JLabel m_hostLabel = new JLabel("Host:");
    private final JLabel m_portLabel = new JLabel("Port:");
    private final JButton m_testEmail = new JButton("Test Email");
    private final JCheckBox m_alsoPostAfterCombatMove = new JCheckBox("Also Post After Combat Move");

    public EmailSenderEditor(GenericEmailSender bean, EditorConfiguration editorConfiguration) {
        this.m_bean = bean;
        this.m_subject.setText(this.m_bean.getSubjectPrefix());
        this.m_host.setText(this.m_bean.getHost());
        this.m_port.setText(String.valueOf(this.m_bean.getPort()));
        this.m_toAddress.setText(this.m_bean.getToAddress());
        this.m_login.setText(this.m_bean.getUserName());
        this.m_password.setText(this.m_bean.getPassword());
        this.m_useTLS.setSelected(this.m_bean.getEncryption() == GenericEmailSender.Encryption.TLS);
        boolean bottomSpace = true;
        int labelSpace = 2;
        int row = 0;
        this.add((Component)new JLabel("Subject:"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 1, 2), 0, 0));
        this.add((Component)this.m_subject, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 1, 0), 0, 0));
        this.add((Component)this.m_toLabel, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 1, 2), 0, 0));
        this.add((Component)this.m_toAddress, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 1, 0), 0, 0));
        this.add((Component)this.m_loginLabel, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 1, 2), 0, 0));
        this.add((Component)this.m_login, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 1, 0), 0, 0));
        this.add((Component)this.m_passwordLabel, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 1, 2), 0, 0));
        this.add((Component)this.m_password, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 1, 0), 0, 0));
        if (editorConfiguration.showHost) {
            this.add((Component)this.m_hostLabel, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 1, 2), 0, 0));
            this.add((Component)this.m_host, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 1, 0), 0, 0));
        }
        if (editorConfiguration.showPort) {
            this.add((Component)this.m_portLabel, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 1, 2), 0, 0));
            this.add((Component)this.m_port, new GridBagConstraints(1, row, 2, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 1, 0), 0, 0));
        }
        if (editorConfiguration.showEncryption) {
            this.add((Component)this.m_useTLS, new GridBagConstraints(0, ++row, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 1, 0), 0, 0));
            this.add((Component)this.m_testEmail, new GridBagConstraints(2, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 1, 0), 0, 0));
            this.add((Component)this.m_alsoPostAfterCombatMove, new GridBagConstraints(0, ++row, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 1, 0), 0, 0));
        } else {
            this.add((Component)this.m_alsoPostAfterCombatMove, new GridBagConstraints(0, ++row, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 1, 0), 0, 0));
            this.add((Component)this.m_testEmail, new GridBagConstraints(2, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 1, 0), 0, 0));
        }
        this.setupListeners();
    }

    private void setupListeners() {
        EditorPanel.EditorChangedFiringDocumentListener listener = new EditorPanel.EditorChangedFiringDocumentListener();
        this.m_host.getDocument().addDocumentListener(listener);
        this.m_login.getDocument().addDocumentListener(listener);
        this.m_port.getDocument().addDocumentListener(listener);
        this.m_password.getDocument().addDocumentListener(listener);
        this.m_toAddress.getDocument().addDocumentListener(listener);
        this.m_useTLS.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EmailSenderEditor.this.fireEditorChanged();
            }
        });
        this.m_testEmail.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EmailSenderEditor.this.testEmail();
            }
        });
    }

    private void testEmail() {
        final ProgressWindow progressWindow = new ProgressWindow(MainFrame.getInstance(), "Sending test email...");
        progressWindow.setVisible(true);
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                int finalMessageType;
                String finalMessage;
                String message = "An unknown occurred, report this as a bug on the TripleA dev forum";
                int messageType = 0;
                try {
                    String html = "<html><body><h1>Success</h1><p>This was a test email sent by TripleA<p></body></html>";
                    File dummy = new File(GameRunner2.getUserRootFolder(), "dummySave.txt");
                    dummy.deleteOnExit();
                    FileOutputStream fout = new FileOutputStream(dummy);
                    fout.write("This file would normally be a save game".getBytes());
                    fout.close();
                    ((IEmailSender)EmailSenderEditor.this.getBean()).sendEmail("TripleA Test", "<html><body><h1>Success</h1><p>This was a test email sent by TripleA<p></body></html>", dummy, "dummy.txt");
                    message = "Email sent, it should arrive shortly, otherwise check your spam folder";
                    messageType = 1;
                    finalMessage = message;
                    finalMessageType = messageType;
                }
                catch (IOException ioe) {
                    int finalMessageType2;
                    String finalMessage2;
                    try {
                        finalMessage2 = message = "Unable to send email: " + ioe.getMessage();
                        finalMessageType2 = messageType;
                    }
                    catch (Throwable throwable) {
                        String finalMessage3 = message;
                        int finalMessageType3 = messageType;
                        SwingUtilities.invokeLater(new Runnable(finalMessage3, finalMessageType3){
                            final /* synthetic */ String val$finalMessage;
                            final /* synthetic */ int val$finalMessageType;
                            {
                                this.val$finalMessage = string;
                                this.val$finalMessageType = n;
                            }

                            public void run() {
                                try {
                                    JOptionPane.showMessageDialog(MainFrame.getInstance(), this.val$finalMessage, "Email Test", this.val$finalMessageType);
                                }
                                catch (HeadlessException headlessException) {
                                    // empty catch block
                                }
                            }
                        });
                        progressWindow.setVisible(false);
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    progressWindow.setVisible(false);
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                progressWindow.setVisible(false);
            }
        };
        Thread t = new Thread(runnable);
        t.start();
    }

    public boolean isBeanValid() {
        boolean hostValid = this.validateTextFieldNotEmpty(this.m_host, this.m_hostLabel);
        boolean portValid = this.validateTextField(this.m_port, this.m_portLabel, new IntegerRangeValidator(0, 65635));
        boolean addressValid = this.validateTextField(this.m_toAddress, this.m_toLabel, new EmailValidator(false));
        boolean allValid = hostValid && portValid && addressValid;
        this.m_testEmail.setEnabled(allValid);
        return allValid;
    }

    public IBean getBean() {
        this.m_bean.setEncryption(this.m_useTLS.isSelected() ? GenericEmailSender.Encryption.TLS : GenericEmailSender.Encryption.NONE);
        this.m_bean.setSubjectPrefix(this.m_subject.getText());
        this.m_bean.setHost(this.m_host.getText());
        this.m_bean.setUserName(this.m_login.getText());
        this.m_bean.setPassword(this.m_password.getText());
        int port = 0;
        try {
            port = Integer.parseInt(this.m_port.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.m_bean.setPort(port);
        this.m_bean.setToAddress(this.m_toAddress.getText());
        this.m_bean.setAlsoPostAfterCombatMove(this.m_alsoPostAfterCombatMove.isSelected());
        return this.m_bean;
    }

    public static class EditorConfiguration {
        public boolean showHost;
        public boolean showPort;
        public boolean showEncryption;

        public EditorConfiguration() {
        }

        public EditorConfiguration(boolean showHost, boolean showPort, boolean showEncryption) {
            this.showHost = showHost;
            this.showPort = showPort;
            this.showEncryption = showEncryption;
        }
    }
}

