/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.ui.editors;

import games.strategy.engine.framework.startup.ui.MainFrame;
import games.strategy.engine.framework.startup.ui.editors.EditorPanel;
import games.strategy.engine.framework.startup.ui.editors.IBean;
import games.strategy.engine.framework.startup.ui.editors.validators.IValidator;
import games.strategy.engine.pbem.IWebPoster;
import games.strategy.engine.pbem.TripleAWebPoster;
import games.strategy.ui.ProgressWindow;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.httpclient.methods.multipart.Part;

public class MicroWebPosterEditor
extends EditorPanel {
    private static final long serialVersionUID = -6069315084412575053L;
    public static final String HTTP_BLANK = "http://";
    private final JButton m_viewSite = new JButton("View Web Site");
    private final JButton m_testSite = new JButton("Test Web Site");
    private final JButton m_initGame = new JButton("Initialize Game");
    private final JTextField m_id = new JTextField();
    private final JLabel m_hostLabel = new JLabel("Host:");
    private final JComboBox m_hosts;
    private final JCheckBox m_includeSaveGame = new JCheckBox("Send emails");
    private final IWebPoster m_bean;
    private final String[] m_parties;
    private final JLabel m_gameNameLabel = new JLabel("Game Name:");
    private final JTextField m_gameName = new JTextField();

    public MicroWebPosterEditor(IWebPoster bean, String[] parties) {
        this.m_bean = bean;
        this.m_parties = parties;
        boolean bottomSpace = true;
        int labelSpace = 2;
        int row = 0;
        this.add((Component)this.m_hostLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 1, 2), 0, 0));
        this.m_bean.addToAllHosts(this.m_bean.getHost());
        this.m_hosts = new JComboBox<String>(this.m_bean.getAllHosts());
        this.m_hosts.setEditable(true);
        this.m_hosts.setMaximumRowCount(6);
        this.add((Component)this.m_hosts, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 1, 0), 0, 0));
        this.add((Component)this.m_viewSite, new GridBagConstraints(2, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 2, 1, 0), 0, 0));
        this.add((Component)this.m_gameNameLabel, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 1, 2), 0, 0));
        this.add((Component)this.m_gameName, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 1, 0), 0, 0));
        this.m_gameName.setText(this.m_bean.getGameName());
        this.add((Component)this.m_initGame, new GridBagConstraints(2, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 2, 1, 0), 0, 0));
        if (this.m_parties == null || this.m_parties.length == 0) {
            this.m_initGame.setEnabled(false);
        }
        this.add((Component)this.m_includeSaveGame, new GridBagConstraints(0, ++row, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_includeSaveGame.setSelected(this.m_bean.getMailSaveGame());
        this.add((Component)this.m_testSite, new GridBagConstraints(2, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 2, 1, 0), 0, 0));
        this.setupListeners();
    }

    private void setupListeners() {
        this.m_viewSite.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((IWebPoster)MicroWebPosterEditor.this.getBean()).viewSite();
            }
        });
        this.m_testSite.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MicroWebPosterEditor.this.testSite();
            }
        });
        this.m_initGame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MicroWebPosterEditor.this.initGame();
            }
        });
        this.m_hosts.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MicroWebPosterEditor.this.fireEditorChanged();
            }
        });
        EditorPanel.EditorChangedFiringDocumentListener docListener = new EditorPanel.EditorChangedFiringDocumentListener();
        this.m_id.getDocument().addDocumentListener(docListener);
        this.m_gameName.getDocument().addDocumentListener(docListener);
    }

    private void initGame() {
        if (this.m_parties == null) {
            return;
        }
        final String hostUrl = !((String)this.m_hosts.getSelectedItem()).endsWith("/") ? (String)this.m_hosts.getSelectedItem() : (String)this.m_hosts.getSelectedItem() + "/";
        ArrayList<String> players = new ArrayList<String>();
        try {
            String inputLine;
            URL url = new URL(hostUrl + "getplayers.php");
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((inputLine = in.readLine()) != null) {
                players.add(inputLine);
            }
            in.close();
            for (int i = 0; i < players.size(); ++i) {
                players.set(i, ((String)players.get(i)).substring(0, ((String)players.get(i)).indexOf("\t")));
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(MainFrame.getInstance(), "Retrieving players from " + hostUrl + " failed:\n" + ex.toString(), "Error", 1);
            return;
        }
        final JFrame window = new JFrame("Select Players");
        window.setLayout(new GridBagLayout());
        window.getContentPane().add((Component)new JLabel("Select Players For Each Nation:"), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(20, 20, 20, 20), 0, 0));
        final JComboBox[] comboBoxes = new JComboBox[this.m_parties.length];
        for (int i = 0; i < this.m_parties.length; ++i) {
            JLabel label = new JLabel(this.m_parties[i] + ": ");
            comboBoxes[i] = new JComboBox();
            for (int p = 0; p < players.size(); ++p) {
                comboBoxes[i].addItem(players.get(p));
            }
            comboBoxes[i].setSelectedIndex(i % players.size());
            window.getContentPane().add((Component)label, new GridBagConstraints(0, i + 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 20, 5, 5), 0, 0));
            window.getContentPane().add((Component)comboBoxes[i], new GridBagConstraints(1, i + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 20), 0, 0));
        }
        JButton btnClose = new JButton("Cancel");
        btnClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                window.setVisible(false);
                window.dispose();
            }
        });
        JButton btnOK = new JButton("Initialize");
        btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                window.setVisible(false);
                window.dispose();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < comboBoxes.length; ++i) {
                    sb.append(MicroWebPosterEditor.this.m_parties[i]);
                    sb.append(": ");
                    sb.append((String)comboBoxes[i].getSelectedItem());
                    sb.append("\n");
                }
                ArrayList<Part> parts = new ArrayList<Part>();
                parts.add(TripleAWebPoster.createStringPart("siteid", MicroWebPosterEditor.this.m_id.getText()));
                parts.add(TripleAWebPoster.createStringPart("players", sb.toString()));
                parts.add(TripleAWebPoster.createStringPart("gamename", MicroWebPosterEditor.this.m_gameName.getText()));
                try {
                    String response = TripleAWebPoster.executePost(hostUrl, "create.php", parts);
                    if (response.toLowerCase().contains("success")) {
                        JOptionPane.showMessageDialog(MainFrame.getInstance(), response, "Game initialized", 1);
                    } else {
                        JOptionPane.showMessageDialog(MainFrame.getInstance(), "Game initialization failed:\n" + response, "Error", 1);
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(MainFrame.getInstance(), "Game initialization failed:\n" + ex.toString(), "Error", 1);
                }
            }
        });
        window.getContentPane().add((Component)btnOK, new GridBagConstraints(0, this.m_parties.length + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(30, 20, 20, 10), 0, 0));
        window.getContentPane().add((Component)btnClose, new GridBagConstraints(1, this.m_parties.length + 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(30, 10, 20, 20), 0, 0));
        window.pack();
        window.setLocationRelativeTo(null);
        window.setVisible(true);
    }

    void testSite() {
        final IWebPoster poster = (IWebPoster)this.getBean();
        final ProgressWindow progressWindow = new ProgressWindow(MainFrame.getInstance(), poster.getTestMessage());
        progressWindow.setVisible(true);
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Exception tmpException = null;
                try {
                    File f = File.createTempFile("123", "test");
                    f.deleteOnExit();
                    BufferedImage image = new BufferedImage(130, 40, 1);
                    Graphics g = image.getGraphics();
                    g.drawString("Testing file upload", 10, 20);
                    ImageIO.write((RenderedImage)image, "jpg", f);
                    poster.addSaveGame(f, "Test.jpg");
                    poster.postTurnSummary(null, "Test Turn Summary.", "TestPlayer", 1);
                }
                catch (Exception ex) {
                    tmpException = ex;
                }
                finally {
                    progressWindow.setVisible(false);
                }
                final Exception exception = tmpException;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            String message = exception != null ? exception.toString() : MicroWebPosterEditor.this.m_bean.getServerMessage();
                            JOptionPane.showMessageDialog(MainFrame.getInstance(), message, "Test Turn Summary Post", 1);
                        }
                        catch (HeadlessException headlessException) {
                            // empty catch block
                        }
                    }
                });
            }
        };
        Thread t = new Thread(runnable);
        t.start();
    }

    public boolean isBeanValid() {
        boolean hostValid = this.validateText((String)this.m_hosts.getSelectedItem(), this.m_hostLabel, new IValidator(){

            public boolean isValid(String text) {
                return text != null && text.length() > 0 && !text.equalsIgnoreCase(MicroWebPosterEditor.HTTP_BLANK);
            }
        });
        boolean idValid = this.validateTextFieldNotEmpty(this.m_gameName, this.m_gameNameLabel);
        boolean allValid = hostValid && idValid;
        this.m_testSite.setEnabled(allValid);
        this.m_initGame.setEnabled(allValid);
        this.m_viewSite.setEnabled(hostValid);
        return allValid;
    }

    public IBean getBean() {
        this.m_bean.setHost((String)this.m_hosts.getSelectedItem());
        this.m_bean.addToAllHosts((String)this.m_hosts.getSelectedItem());
        this.m_bean.getAllHosts().remove(HTTP_BLANK);
        this.m_bean.setSiteId(this.m_id.getText());
        this.m_bean.setMailSaveGame(this.m_includeSaveGame.isSelected());
        this.m_bean.setGameName(this.m_gameName.getText());
        return this.m_bean;
    }
}

