/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.gamePlayer;

import games.strategy.engine.GameOverException;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.events.GameStepListener;
import games.strategy.engine.delegate.IDelegate;
import games.strategy.engine.delegate.IPersistentDelegate;
import games.strategy.engine.framework.IGame;
import games.strategy.engine.framework.ServerGame;
import games.strategy.engine.gamePlayer.GameOverInvocationHandler;
import games.strategy.engine.gamePlayer.IPlayerBridge;
import games.strategy.engine.message.IRemote;
import games.strategy.engine.message.MessengerException;
import games.strategy.engine.message.RemoteName;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Properties;

public class DefaultPlayerBridge
implements IPlayerBridge {
    private final IGame m_game;
    private String m_currentStep;
    private String m_currentDelegate;
    private final GameStepListener m_gameStepListener = new GameStepListener(){

        public void gameStepChanged(String stepName, String delegateName, PlayerID player, int round, String displayName) {
            if (stepName == null) {
                throw new IllegalArgumentException("Null step");
            }
            if (delegateName == null) {
                throw new IllegalArgumentException("Null delegate");
            }
            DefaultPlayerBridge.this.m_currentStep = stepName;
            DefaultPlayerBridge.this.m_currentDelegate = delegateName;
        }
    };

    public DefaultPlayerBridge(IGame aGame) {
        this.m_game = aGame;
        this.m_game.addGameStepListener(this.m_gameStepListener);
    }

    public String getStepName() {
        return this.m_currentStep;
    }

    public boolean isGameOver() {
        return this.m_game.isGameOver();
    }

    public GameData getGameData() {
        return this.m_game.getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemote getRemoteDelegate() {
        if (this.m_game.isGameOver()) {
            throw new GameOverException("Game Over");
        }
        this.m_game.getData().acquireReadLock();
        try {
            RemoteName remoteName;
            IDelegate delegate = this.m_game.getData().getDelegateList().getDelegate(this.m_currentDelegate);
            if (delegate == null) {
                String errorMessage = "IDelegate in DefaultPlayerBridge.getRemote() can not be null. CurrentStep: " + this.m_currentStep + ", and CurrentDelegate: " + this.m_currentDelegate;
                System.err.println(errorMessage);
                throw new IllegalStateException(errorMessage);
            }
            try {
                remoteName = ServerGame.getRemoteName(delegate);
            }
            catch (Exception e) {
                e.printStackTrace();
                String errorMessage = "IDelegate IRemote interface class returned null or was not correct interface. CurrentStep: " + this.m_currentStep + ", and CurrentDelegate: " + this.m_currentDelegate;
                System.err.println(errorMessage);
                throw new IllegalStateException(errorMessage, e);
            }
            IRemote iRemote = this.getRemoteThatChecksForGameOver(this.m_game.getRemoteMessenger().getRemote(remoteName));
            this.m_game.getData().releaseReadLock();
            return iRemote;
        }
        catch (Throwable throwable) {
            try {
                this.m_game.getData().releaseReadLock();
                throw throwable;
            }
            catch (MessengerException me) {
                throw new GameOverException("Game Over!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRemote getRemotePersistentDelegate(String name) {
        if (this.m_game.isGameOver()) {
            throw new GameOverException("Game Over");
        }
        try {
            this.m_game.getData().acquireReadLock();
            try {
                IDelegate delegate = this.m_game.getData().getDelegateList().getDelegate(name);
                if (delegate == null) {
                    String errorMessage = "IDelegate in DefaultPlayerBridge.getRemote() can not be null. Looking for delegate named: " + name;
                    System.err.println(errorMessage);
                    throw new IllegalStateException(errorMessage);
                }
                if (!(delegate instanceof IPersistentDelegate)) {
                    IRemote iRemote = null;
                    return iRemote;
                }
                IRemote iRemote = this.getRemoteThatChecksForGameOver(this.m_game.getRemoteMessenger().getRemote(ServerGame.getRemoteName(delegate)));
                return iRemote;
            }
            finally {
                this.m_game.getData().releaseReadLock();
            }
        }
        catch (MessengerException me) {
            throw new GameOverException("Game Over!");
        }
    }

    public Properties getStepProperties() {
        return this.m_game.getData().getSequence().getStep().getProperties();
    }

    private IRemote getRemoteThatChecksForGameOver(IRemote implementor) {
        Class<?>[] classes = implementor.getClass().getInterfaces();
        GameOverInvocationHandler goih = new GameOverInvocationHandler(implementor, this.m_game);
        return (IRemote)Proxy.newProxyInstance(implementor.getClass().getClassLoader(), classes, (InvocationHandler)goih);
    }
}

