/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.gamePlayer;

import games.strategy.engine.GameOverException;
import games.strategy.engine.framework.IGame;
import games.strategy.engine.message.RemoteNotFoundException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class GameOverInvocationHandler
implements InvocationHandler {
    private final Object m_delegate;
    private final IGame m_game;

    public GameOverInvocationHandler(Object delegate, IGame game) {
        this.m_delegate = delegate;
        this.m_game = game;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(this.m_delegate, args);
        }
        catch (InvocationTargetException ite) {
            if (!this.m_game.isGameOver()) {
                throw ite.getCause();
            }
            throw new GameOverException("Game Over Exception!");
        }
        catch (RemoteNotFoundException rnfe) {
            throw new GameOverException("Game Over!");
        }
    }
}

