/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.history;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangePerformer;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.history.Event;
import games.strategy.engine.history.EventChild;
import games.strategy.engine.history.HistoryNode;
import games.strategy.engine.history.HistoryWriter;
import games.strategy.engine.history.IndexedHistoryNode;
import games.strategy.engine.history.RootHistoryNode;
import games.strategy.engine.history.SerializedHistory;
import games.strategy.triplea.ui.history.HistoryPanel;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class History
extends DefaultTreeModel
implements Serializable {
    private final HistoryWriter m_writer = new HistoryWriter(this);
    private final List<Change> m_changes = new ArrayList<Change>();
    private final GameData m_data;
    private HistoryNode m_currentNode;
    HistoryPanel m_panel = null;

    private void assertCorrectThread() {
        if (this.m_data.areChangesOnlyInSwingEventThread() && !SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Wrong thread");
        }
    }

    public History(GameData data) {
        super(new RootHistoryNode("Game History", true));
        this.m_data = data;
    }

    public HistoryWriter getHistoryWriter() {
        return this.m_writer;
    }

    public void setTreePanel(HistoryPanel panel) {
        this.m_panel = panel;
    }

    public void goToEnd() {
        if (this.m_panel != null) {
            this.m_panel.goToEnd();
        }
    }

    public HistoryNode getLastNode() {
        this.assertCorrectThread();
        return this.getLastChildInternal((HistoryNode)this.getRoot());
    }

    private HistoryNode getLastChildInternal(HistoryNode node) {
        if (node.getChildCount() == 0) {
            return node;
        }
        return this.getLastChildInternal((HistoryNode)node.getLastChild());
    }

    private int getLastChange(HistoryNode node) {
        int rVal = node == this.getRoot() ? 0 : (node instanceof Event ? ((Event)node).getChangeEndIndex() : (node instanceof EventChild ? ((Event)node.getParent()).getChangeEndIndex() : (node instanceof IndexedHistoryNode ? ((IndexedHistoryNode)node).getChangeStartIndex() : 0)));
        if (rVal == -1) {
            return this.m_changes.size();
        }
        return rVal;
    }

    public Change getDelta(HistoryNode start, HistoryNode end) {
        this.assertCorrectThread();
        int firstChange = this.getLastChange(start);
        int lastChange = this.getLastChange(end);
        if (firstChange == lastChange) {
            return null;
        }
        List<Change> changes = this.m_changes.subList(Math.min(firstChange, lastChange), Math.max(firstChange, lastChange));
        CompositeChange compositeChange = new CompositeChange(changes);
        if (lastChange >= firstChange) {
            return compositeChange;
        }
        return ((Change)compositeChange).invert();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void gotoNode(HistoryNode node) {
        this.assertCorrectThread();
        this.getGameData().acquireWriteLock();
        try {
            if (this.m_currentNode == null) {
                this.m_currentNode = this.getLastNode();
            }
            Change dataChange = this.getDelta(this.m_currentNode, node);
            this.m_currentNode = node;
            if (dataChange != null) {
                new ChangePerformer(this.m_data).perform(dataChange);
            }
        }
        finally {
            this.getGameData().releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeAllHistoryAfterNode(HistoryNode removeAfterNode) {
        this.gotoNode(removeAfterNode);
        this.assertCorrectThread();
        this.getGameData().acquireWriteLock();
        try {
            int lastChange = this.getLastChange(removeAfterNode);
            while (this.m_changes.size() > lastChange) {
                this.m_changes.remove(lastChange);
            }
            ArrayList<HistoryNode> nodesToRemove = new ArrayList<HistoryNode>();
            Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.getRoot()).preorderEnumeration();
            enumeration.nextElement();
            boolean startRemoving = false;
            while (enumeration.hasMoreElements()) {
                HistoryNode node = (HistoryNode)enumeration.nextElement();
                if (!(node instanceof IndexedHistoryNode)) continue;
                int index = ((IndexedHistoryNode)node).getChangeStartIndex();
                if (index >= lastChange) {
                    startRemoving = true;
                }
                if (!startRemoving) continue;
                nodesToRemove.add(node);
            }
            while (!nodesToRemove.isEmpty()) {
                this.removeNodeFromParent((MutableTreeNode)nodesToRemove.remove(0));
            }
        }
        finally {
            this.getGameData().releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void changeAdded(Change aChange) {
        this.m_changes.add(aChange);
        if (this.m_currentNode == null) {
            return;
        }
        if (this.m_currentNode == this.getLastNode()) {
            this.getGameData().acquireWriteLock();
            try {
                new ChangePerformer(this.m_data).perform(aChange);
            }
            finally {
                this.getGameData().releaseWriteLock();
            }
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializedHistory(this, this.m_data, this.m_changes);
    }

    List<Change> getChanges() {
        return this.m_changes;
    }

    GameData getGameData() {
        return this.m_data;
    }
}

